=begin
#OpenAPI Petstore

#This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

The version of the OpenAPI document: 1.0.0

Generated by: https://openapi-generator.tech
OpenAPI Generator version: 7.2.0-SNAPSHOT

=end

require 'spec_helper'

describe Petstore::Configuration do
  let(:config) { Petstore::Configuration.default }

  before(:each) do
    # uncomment below to setup host and base_path
    # require 'URI'
    # uri = URI.parse("http://petstore.swagger.io:80/v2")
    # Petstore.configure do |c|
    #   c.host = uri.host
    #   c.base_path = uri.path
    # end
  end

  describe '#base_url' do
    it 'should have the default value' do
      # uncomment below to test default value of the base path
      # expect(config.base_url).to eq("http://petstore.swagger.io:80/v2")
    end

    it 'should remove trailing slashes' do
      [nil, '', '/', '//'].each do |base_path|
        config.base_path = base_path
        # uncomment below to test trailing slashes
        # expect(config.base_url).to eq("http://petstore.swagger.io:80/v2")
      end
    end
  end

  describe '#configure' do
    let(:session) { HTTPX::Session.new }

    before do
      module CustomPlugin
        module InstanceMethods; end
      end
      module AnotherCustomPlugin
        module InstanceMethods; end
      end

      config.configure_session do |session|
        session.plugin(CustomPlugin)
      end
    end

    it 'adds a block that will be used to configure the connection' do
      sess = config.configure(session)

      expect(sess.class.ancestors).to include(CustomPlugin::InstanceMethods)
    end

    it 'supports multiple configuration blocks' do
      config.configure_session do |session|
        session.plugin(AnotherCustomPlugin)
      end
      sess = config.configure(session)

      expect(sess.class.ancestors).to include(CustomPlugin::InstanceMethods)
      expect(sess.class.ancestors).to include(AnotherCustomPlugin::InstanceMethods)
    end
  end
end
