=begin
#OpenAPI Petstore

#This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

The version of the OpenAPI document: 1.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.20.0-SNAPSHOT

=end

require 'cgi'

module Petstore
  class FakeApi
    attr_accessor :api_client

    def initialize(api_client = ApiClient.default)
      @api_client = api_client
    end
    # for Java apache and Java native, test toUrlQueryString for maps with BegDecimal keys
    # @param [Hash] opts the optional parameters
    # @return [FakeBigDecimalMap200Response]
    def fake_big_decimal_map(opts = {})
      data, _status_code, _headers = fake_big_decimal_map_with_http_info(opts)
      data
    end

    # for Java apache and Java native, test toUrlQueryString for maps with BegDecimal keys
    # @param [Hash] opts the optional parameters
    # @return [Array<(FakeBigDecimalMap200Response, Integer, Hash)>] FakeBigDecimalMap200Response data, response status code and response headers
    def fake_big_decimal_map_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.fake_big_decimal_map ...'
      end
      # resource path
      local_var_path = '/fake/BigDecimalMap'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*']) unless header_params['Accept']

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'FakeBigDecimalMap200Response'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.fake_big_decimal_map",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#fake_big_decimal_map\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Health check endpoint
    # @param [Hash] opts the optional parameters
    # @return [HealthCheckResult]
    def fake_health_get(opts = {})
      data, _status_code, _headers = fake_health_get_with_http_info(opts)
      data
    end

    # Health check endpoint
    # @param [Hash] opts the optional parameters
    # @return [Array<(HealthCheckResult, Integer, Hash)>] HealthCheckResult data, response status code and response headers
    def fake_health_get_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.fake_health_get ...'
      end
      # resource path
      local_var_path = '/fake/health'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json']) unless header_params['Accept']

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'HealthCheckResult'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.fake_health_get",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#fake_health_get\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # test http signature authentication
    # @param pet [Pet] Pet object that needs to be added to the store
    # @param [Hash] opts the optional parameters
    # @option opts [String] :query_1 query parameter
    # @option opts [String] :header_1 header parameter
    # @return [nil]
    def fake_http_signature_test(pet, opts = {})
      fake_http_signature_test_with_http_info(pet, opts)
      nil
    end

    # test http signature authentication
    # @param pet [Pet] Pet object that needs to be added to the store
    # @param [Hash] opts the optional parameters
    # @option opts [String] :query_1 query parameter
    # @option opts [String] :header_1 header parameter
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def fake_http_signature_test_with_http_info(pet, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.fake_http_signature_test ...'
      end
      # verify the required parameter 'pet' is set
      if @api_client.config.client_side_validation && pet.nil?
        fail ArgumentError, "Missing the required parameter 'pet' when calling FakeApi.fake_http_signature_test"
      end
      # resource path
      local_var_path = '/fake/http-signature-test'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'query_1'] = opts[:'query_1'] if !opts[:'query_1'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json', 'application/xml'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end
      header_params['header_1'] = opts[:'header_1'] if !opts[:'header_1'].nil?

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(pet)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || ['http_signature_test']

      new_options = opts.merge(
        :operation => :"FakeApi.fake_http_signature_test",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#fake_http_signature_test\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Test serialization of outer boolean types
    # @param [Hash] opts the optional parameters
    # @option opts [Boolean] :body Input boolean as post body
    # @return [Boolean]
    def fake_outer_boolean_serialize(opts = {})
      data, _status_code, _headers = fake_outer_boolean_serialize_with_http_info(opts)
      data
    end

    # Test serialization of outer boolean types
    # @param [Hash] opts the optional parameters
    # @option opts [Boolean] :body Input boolean as post body
    # @return [Array<(Boolean, Integer, Hash)>] Boolean data, response status code and response headers
    def fake_outer_boolean_serialize_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.fake_outer_boolean_serialize ...'
      end
      # resource path
      local_var_path = '/fake/outer/boolean'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*']) unless header_params['Accept']
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(opts[:'body'])

      # return_type
      return_type = opts[:debug_return_type] || 'Boolean'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.fake_outer_boolean_serialize",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#fake_outer_boolean_serialize\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Test serialization of object with outer number type
    # @param [Hash] opts the optional parameters
    # @option opts [OuterComposite] :outer_composite Input composite as post body
    # @return [OuterComposite]
    def fake_outer_composite_serialize(opts = {})
      data, _status_code, _headers = fake_outer_composite_serialize_with_http_info(opts)
      data
    end

    # Test serialization of object with outer number type
    # @param [Hash] opts the optional parameters
    # @option opts [OuterComposite] :outer_composite Input composite as post body
    # @return [Array<(OuterComposite, Integer, Hash)>] OuterComposite data, response status code and response headers
    def fake_outer_composite_serialize_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.fake_outer_composite_serialize ...'
      end
      # resource path
      local_var_path = '/fake/outer/composite'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*']) unless header_params['Accept']
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(opts[:'outer_composite'])

      # return_type
      return_type = opts[:debug_return_type] || 'OuterComposite'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.fake_outer_composite_serialize",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#fake_outer_composite_serialize\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Test serialization of outer number types
    # @param [Hash] opts the optional parameters
    # @option opts [Float] :body Input number as post body
    # @return [Float]
    def fake_outer_number_serialize(opts = {})
      data, _status_code, _headers = fake_outer_number_serialize_with_http_info(opts)
      data
    end

    # Test serialization of outer number types
    # @param [Hash] opts the optional parameters
    # @option opts [Float] :body Input number as post body
    # @return [Array<(Float, Integer, Hash)>] Float data, response status code and response headers
    def fake_outer_number_serialize_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.fake_outer_number_serialize ...'
      end
      # resource path
      local_var_path = '/fake/outer/number'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*']) unless header_params['Accept']
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(opts[:'body'])

      # return_type
      return_type = opts[:debug_return_type] || 'Float'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.fake_outer_number_serialize",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#fake_outer_number_serialize\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Test serialization of outer string types
    # @param [Hash] opts the optional parameters
    # @option opts [String] :body Input string as post body
    # @return [String]
    def fake_outer_string_serialize(opts = {})
      data, _status_code, _headers = fake_outer_string_serialize_with_http_info(opts)
      data
    end

    # Test serialization of outer string types
    # @param [Hash] opts the optional parameters
    # @option opts [String] :body Input string as post body
    # @return [Array<(String, Integer, Hash)>] String data, response status code and response headers
    def fake_outer_string_serialize_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.fake_outer_string_serialize ...'
      end
      # resource path
      local_var_path = '/fake/outer/string'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*']) unless header_params['Accept']
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(opts[:'body'])

      # return_type
      return_type = opts[:debug_return_type] || 'String'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.fake_outer_string_serialize",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#fake_outer_string_serialize\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Test serialization of enum (int) properties with examples
    # @param outer_object_with_enum_property [OuterObjectWithEnumProperty] Input enum (int) as post body
    # @param [Hash] opts the optional parameters
    # @return [OuterObjectWithEnumProperty]
    def fake_property_enum_integer_serialize(outer_object_with_enum_property, opts = {})
      data, _status_code, _headers = fake_property_enum_integer_serialize_with_http_info(outer_object_with_enum_property, opts)
      data
    end

    # Test serialization of enum (int) properties with examples
    # @param outer_object_with_enum_property [OuterObjectWithEnumProperty] Input enum (int) as post body
    # @param [Hash] opts the optional parameters
    # @return [Array<(OuterObjectWithEnumProperty, Integer, Hash)>] OuterObjectWithEnumProperty data, response status code and response headers
    def fake_property_enum_integer_serialize_with_http_info(outer_object_with_enum_property, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.fake_property_enum_integer_serialize ...'
      end
      # verify the required parameter 'outer_object_with_enum_property' is set
      if @api_client.config.client_side_validation && outer_object_with_enum_property.nil?
        fail ArgumentError, "Missing the required parameter 'outer_object_with_enum_property' when calling FakeApi.fake_property_enum_integer_serialize"
      end
      # resource path
      local_var_path = '/fake/property/enum-int'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*']) unless header_params['Accept']
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(outer_object_with_enum_property)

      # return_type
      return_type = opts[:debug_return_type] || 'OuterObjectWithEnumProperty'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.fake_property_enum_integer_serialize",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#fake_property_enum_integer_serialize\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # parameter name mapping test
    # @param underscore_type [Integer] _type
    # @param type [String] type
    # @param type_with_underscore [String] type_
    # @param http_debug_option [String] http debug option (to test parameter naming option)
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def get_parameter_name_mapping(underscore_type, type, type_with_underscore, http_debug_option, opts = {})
      get_parameter_name_mapping_with_http_info(underscore_type, type, type_with_underscore, http_debug_option, opts)
      nil
    end

    # parameter name mapping test
    # @param underscore_type [Integer] _type
    # @param type [String] type
    # @param type_with_underscore [String] type_
    # @param http_debug_option [String] http debug option (to test parameter naming option)
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def get_parameter_name_mapping_with_http_info(underscore_type, type, type_with_underscore, http_debug_option, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.get_parameter_name_mapping ...'
      end
      # verify the required parameter 'underscore_type' is set
      if @api_client.config.client_side_validation && underscore_type.nil?
        fail ArgumentError, "Missing the required parameter 'underscore_type' when calling FakeApi.get_parameter_name_mapping"
      end
      # verify the required parameter 'type' is set
      if @api_client.config.client_side_validation && type.nil?
        fail ArgumentError, "Missing the required parameter 'type' when calling FakeApi.get_parameter_name_mapping"
      end
      # verify the required parameter 'type_with_underscore' is set
      if @api_client.config.client_side_validation && type_with_underscore.nil?
        fail ArgumentError, "Missing the required parameter 'type_with_underscore' when calling FakeApi.get_parameter_name_mapping"
      end
      # verify the required parameter 'http_debug_option' is set
      if @api_client.config.client_side_validation && http_debug_option.nil?
        fail ArgumentError, "Missing the required parameter 'http_debug_option' when calling FakeApi.get_parameter_name_mapping"
      end
      # resource path
      local_var_path = '/fake/parameter-name-mapping'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'type'] = type
      query_params[:'http_debug_option'] = http_debug_option

      # header parameters
      header_params = opts[:header_params] || {}
      header_params['_type'] = underscore_type
      header_params['type_'] = type_with_underscore

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.get_parameter_name_mapping",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#get_parameter_name_mapping\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # test referenced additionalProperties
    # 
    # @param request_body [Hash<String, Object>] request body
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def test_additional_properties_reference(request_body, opts = {})
      test_additional_properties_reference_with_http_info(request_body, opts)
      nil
    end

    # test referenced additionalProperties
    # 
    # @param request_body [Hash<String, Object>] request body
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def test_additional_properties_reference_with_http_info(request_body, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_additional_properties_reference ...'
      end
      # verify the required parameter 'request_body' is set
      if @api_client.config.client_side_validation && request_body.nil?
        fail ArgumentError, "Missing the required parameter 'request_body' when calling FakeApi.test_additional_properties_reference"
      end
      # resource path
      local_var_path = '/fake/additionalProperties-reference'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(request_body)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.test_additional_properties_reference",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_additional_properties_reference\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # For this test, the body has to be a binary file.
    # @param body [File] image to upload
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def test_body_with_binary(body, opts = {})
      test_body_with_binary_with_http_info(body, opts)
      nil
    end

    # For this test, the body has to be a binary file.
    # @param body [File] image to upload
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def test_body_with_binary_with_http_info(body, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_body_with_binary ...'
      end
      # resource path
      local_var_path = '/fake/body-with-binary'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['image/png'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(body)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.test_body_with_binary",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:PUT, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_body_with_binary\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # For this test, the body for this request must reference a schema named `File`.
    # @param file_schema_test_class [FileSchemaTestClass] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def test_body_with_file_schema(file_schema_test_class, opts = {})
      test_body_with_file_schema_with_http_info(file_schema_test_class, opts)
      nil
    end

    # For this test, the body for this request must reference a schema named &#x60;File&#x60;.
    # @param file_schema_test_class [FileSchemaTestClass] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def test_body_with_file_schema_with_http_info(file_schema_test_class, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_body_with_file_schema ...'
      end
      # verify the required parameter 'file_schema_test_class' is set
      if @api_client.config.client_side_validation && file_schema_test_class.nil?
        fail ArgumentError, "Missing the required parameter 'file_schema_test_class' when calling FakeApi.test_body_with_file_schema"
      end
      # resource path
      local_var_path = '/fake/body-with-file-schema'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(file_schema_test_class)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.test_body_with_file_schema",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:PUT, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_body_with_file_schema\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param query [String] 
    # @param user [User] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def test_body_with_query_params(query, user, opts = {})
      test_body_with_query_params_with_http_info(query, user, opts)
      nil
    end

    # @param query [String] 
    # @param user [User] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def test_body_with_query_params_with_http_info(query, user, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_body_with_query_params ...'
      end
      # verify the required parameter 'query' is set
      if @api_client.config.client_side_validation && query.nil?
        fail ArgumentError, "Missing the required parameter 'query' when calling FakeApi.test_body_with_query_params"
      end
      # verify the required parameter 'user' is set
      if @api_client.config.client_side_validation && user.nil?
        fail ArgumentError, "Missing the required parameter 'user' when calling FakeApi.test_body_with_query_params"
      end
      # resource path
      local_var_path = '/fake/body-with-query-params'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'query'] = query

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(user)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.test_body_with_query_params",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:PUT, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_body_with_query_params\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # To test \"client\" model
    # To test \"client\" model
    # @param client [Client] client model
    # @param [Hash] opts the optional parameters
    # @return [Client]
    def test_client_model(client, opts = {})
      data, _status_code, _headers = test_client_model_with_http_info(client, opts)
      data
    end

    # To test \&quot;client\&quot; model
    # To test \&quot;client\&quot; model
    # @param client [Client] client model
    # @param [Hash] opts the optional parameters
    # @return [Array<(Client, Integer, Hash)>] Client data, response status code and response headers
    def test_client_model_with_http_info(client, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_client_model ...'
      end
      # verify the required parameter 'client' is set
      if @api_client.config.client_side_validation && client.nil?
        fail ArgumentError, "Missing the required parameter 'client' when calling FakeApi.test_client_model"
      end
      # resource path
      local_var_path = '/fake'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json']) unless header_params['Accept']
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(client)

      # return_type
      return_type = opts[:debug_return_type] || 'Client'

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.test_client_model",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:PATCH, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_client_model\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
    # Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
    # @param number [Float] None
    # @param double [Float] None
    # @param pattern_without_delimiter [String] None
    # @param byte [String] None
    # @param [Hash] opts the optional parameters
    # @option opts [Integer] :integer None
    # @option opts [Integer] :int32 None
    # @option opts [Integer] :int64 None
    # @option opts [Float] :float None
    # @option opts [String] :string None
    # @option opts [File] :binary None
    # @option opts [Date] :date None
    # @option opts [Time] :date_time None
    # @option opts [String] :password None
    # @option opts [String] :callback None
    # @return [nil]
    def test_endpoint_parameters(number, double, pattern_without_delimiter, byte, opts = {})
      test_endpoint_parameters_with_http_info(number, double, pattern_without_delimiter, byte, opts)
      nil
    end

    # Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
    # Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
    # @param number [Float] None
    # @param double [Float] None
    # @param pattern_without_delimiter [String] None
    # @param byte [String] None
    # @param [Hash] opts the optional parameters
    # @option opts [Integer] :integer None
    # @option opts [Integer] :int32 None
    # @option opts [Integer] :int64 None
    # @option opts [Float] :float None
    # @option opts [String] :string None
    # @option opts [File] :binary None
    # @option opts [Date] :date None
    # @option opts [Time] :date_time None
    # @option opts [String] :password None
    # @option opts [String] :callback None
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def test_endpoint_parameters_with_http_info(number, double, pattern_without_delimiter, byte, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_endpoint_parameters ...'
      end
      # verify the required parameter 'number' is set
      if @api_client.config.client_side_validation && number.nil?
        fail ArgumentError, "Missing the required parameter 'number' when calling FakeApi.test_endpoint_parameters"
      end
      if @api_client.config.client_side_validation && number > 543.2
        fail ArgumentError, 'invalid value for "number" when calling FakeApi.test_endpoint_parameters, must be smaller than or equal to 543.2.'
      end

      if @api_client.config.client_side_validation && number < 32.1
        fail ArgumentError, 'invalid value for "number" when calling FakeApi.test_endpoint_parameters, must be greater than or equal to 32.1.'
      end

      # verify the required parameter 'double' is set
      if @api_client.config.client_side_validation && double.nil?
        fail ArgumentError, "Missing the required parameter 'double' when calling FakeApi.test_endpoint_parameters"
      end
      if @api_client.config.client_side_validation && double > 123.4
        fail ArgumentError, 'invalid value for "double" when calling FakeApi.test_endpoint_parameters, must be smaller than or equal to 123.4.'
      end

      if @api_client.config.client_side_validation && double < 67.8
        fail ArgumentError, 'invalid value for "double" when calling FakeApi.test_endpoint_parameters, must be greater than or equal to 67.8.'
      end

      # verify the required parameter 'pattern_without_delimiter' is set
      if @api_client.config.client_side_validation && pattern_without_delimiter.nil?
        fail ArgumentError, "Missing the required parameter 'pattern_without_delimiter' when calling FakeApi.test_endpoint_parameters"
      end
      pattern = Regexp.new(/^[A-Z].*/)
      if @api_client.config.client_side_validation && pattern_without_delimiter !~ pattern
        fail ArgumentError, "invalid value for 'pattern_without_delimiter' when calling FakeApi.test_endpoint_parameters, must conform to the pattern #{pattern}."
      end

      # verify the required parameter 'byte' is set
      if @api_client.config.client_side_validation && byte.nil?
        fail ArgumentError, "Missing the required parameter 'byte' when calling FakeApi.test_endpoint_parameters"
      end
      if @api_client.config.client_side_validation && !opts[:'integer'].nil? && opts[:'integer'] > 100
        fail ArgumentError, 'invalid value for "opts[:"integer"]" when calling FakeApi.test_endpoint_parameters, must be smaller than or equal to 100.'
      end

      if @api_client.config.client_side_validation && !opts[:'integer'].nil? && opts[:'integer'] < 10
        fail ArgumentError, 'invalid value for "opts[:"integer"]" when calling FakeApi.test_endpoint_parameters, must be greater than or equal to 10.'
      end

      if @api_client.config.client_side_validation && !opts[:'int32'].nil? && opts[:'int32'] > 200
        fail ArgumentError, 'invalid value for "opts[:"int32"]" when calling FakeApi.test_endpoint_parameters, must be smaller than or equal to 200.'
      end

      if @api_client.config.client_side_validation && !opts[:'int32'].nil? && opts[:'int32'] < 20
        fail ArgumentError, 'invalid value for "opts[:"int32"]" when calling FakeApi.test_endpoint_parameters, must be greater than or equal to 20.'
      end

      if @api_client.config.client_side_validation && !opts[:'float'].nil? && opts[:'float'] > 987.6
        fail ArgumentError, 'invalid value for "opts[:"float"]" when calling FakeApi.test_endpoint_parameters, must be smaller than or equal to 987.6.'
      end

      pattern = Regexp.new(/[a-z]/i)
      if @api_client.config.client_side_validation && !opts[:'string'].nil? && opts[:'string'] !~ pattern
        fail ArgumentError, "invalid value for 'opts[:\"string\"]' when calling FakeApi.test_endpoint_parameters, must conform to the pattern #{pattern}."
      end

      if @api_client.config.client_side_validation && !opts[:'password'].nil? && opts[:'password'].to_s.length > 64
        fail ArgumentError, 'invalid value for "opts[:"password"]" when calling FakeApi.test_endpoint_parameters, the character length must be smaller than or equal to 64.'
      end

      if @api_client.config.client_side_validation && !opts[:'password'].nil? && opts[:'password'].to_s.length < 10
        fail ArgumentError, 'invalid value for "opts[:"password"]" when calling FakeApi.test_endpoint_parameters, the character length must be greater than or equal to 10.'
      end

      # resource path
      local_var_path = '/fake'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/x-www-form-urlencoded'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}
      form_params['number'] = number
      form_params['double'] = double
      form_params['pattern_without_delimiter'] = pattern_without_delimiter
      form_params['byte'] = byte
      form_params['integer'] = opts[:'integer'] if !opts[:'integer'].nil?
      form_params['int32'] = opts[:'int32'] if !opts[:'int32'].nil?
      form_params['int64'] = opts[:'int64'] if !opts[:'int64'].nil?
      form_params['float'] = opts[:'float'] if !opts[:'float'].nil?
      form_params['string'] = opts[:'string'] if !opts[:'string'].nil?
      form_params['binary'] = opts[:'binary'] if !opts[:'binary'].nil?
      form_params['date'] = opts[:'date'] if !opts[:'date'].nil?
      form_params['dateTime'] = opts[:'date_time'] if !opts[:'date_time'].nil?
      form_params['password'] = opts[:'password'] if !opts[:'password'].nil?
      form_params['callback'] = opts[:'callback'] if !opts[:'callback'].nil?

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || ['http_basic_test']

      new_options = opts.merge(
        :operation => :"FakeApi.test_endpoint_parameters",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_endpoint_parameters\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # To test enum parameters
    # To test enum parameters
    # @param [Hash] opts the optional parameters
    # @option opts [Array<String>] :enum_header_string_array Header parameter enum test (string array)
    # @option opts [String] :enum_header_string Header parameter enum test (string) (default to '-efg')
    # @option opts [Array<String>] :enum_query_string_array Query parameter enum test (string array)
    # @option opts [String] :enum_query_string Query parameter enum test (string) (default to '-efg')
    # @option opts [Integer] :enum_query_integer Query parameter enum test (double)
    # @option opts [Float] :enum_query_double Query parameter enum test (double)
    # @option opts [Array<EnumClass>] :enum_query_model_array 
    # @option opts [Array<String>] :enum_form_string_array Form parameter enum test (string array) (default to '$')
    # @option opts [String] :enum_form_string Form parameter enum test (string) (default to '-efg')
    # @return [nil]
    def test_enum_parameters(opts = {})
      test_enum_parameters_with_http_info(opts)
      nil
    end

    # To test enum parameters
    # To test enum parameters
    # @param [Hash] opts the optional parameters
    # @option opts [Array<String>] :enum_header_string_array Header parameter enum test (string array)
    # @option opts [String] :enum_header_string Header parameter enum test (string) (default to '-efg')
    # @option opts [Array<String>] :enum_query_string_array Query parameter enum test (string array)
    # @option opts [String] :enum_query_string Query parameter enum test (string) (default to '-efg')
    # @option opts [Integer] :enum_query_integer Query parameter enum test (double)
    # @option opts [Float] :enum_query_double Query parameter enum test (double)
    # @option opts [Array<EnumClass>] :enum_query_model_array 
    # @option opts [Array<String>] :enum_form_string_array Form parameter enum test (string array) (default to '$')
    # @option opts [String] :enum_form_string Form parameter enum test (string) (default to '-efg')
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def test_enum_parameters_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_enum_parameters ...'
      end
      allowable_values = [">", "$"]
      if @api_client.config.client_side_validation && opts[:'enum_header_string_array'] && !opts[:'enum_header_string_array'].all? { |item| allowable_values.include?(item) }
        fail ArgumentError, "invalid value for \"enum_header_string_array\", must include one of #{allowable_values}"
      end
      allowable_values = ["_abc", "-efg", "(xyz)"]
      if @api_client.config.client_side_validation && opts[:'enum_header_string'] && !allowable_values.include?(opts[:'enum_header_string'])
        fail ArgumentError, "invalid value for \"enum_header_string\", must be one of #{allowable_values}"
      end
      allowable_values = [">", "$"]
      if @api_client.config.client_side_validation && opts[:'enum_query_string_array'] && !opts[:'enum_query_string_array'].all? { |item| allowable_values.include?(item) }
        fail ArgumentError, "invalid value for \"enum_query_string_array\", must include one of #{allowable_values}"
      end
      allowable_values = ["_abc", "-efg", "(xyz)"]
      if @api_client.config.client_side_validation && opts[:'enum_query_string'] && !allowable_values.include?(opts[:'enum_query_string'])
        fail ArgumentError, "invalid value for \"enum_query_string\", must be one of #{allowable_values}"
      end
      allowable_values = [1, -2]
      if @api_client.config.client_side_validation && opts[:'enum_query_integer'] && !allowable_values.include?(opts[:'enum_query_integer'])
        fail ArgumentError, "invalid value for \"enum_query_integer\", must be one of #{allowable_values}"
      end
      allowable_values = [1.1, -1.2]
      if @api_client.config.client_side_validation && opts[:'enum_query_double'] && !allowable_values.include?(opts[:'enum_query_double'])
        fail ArgumentError, "invalid value for \"enum_query_double\", must be one of #{allowable_values}"
      end
      allowable_values = [">", "$"]
      if @api_client.config.client_side_validation && opts[:'enum_form_string_array'] && !opts[:'enum_form_string_array'].all? { |item| allowable_values.include?(item) }
        fail ArgumentError, "invalid value for \"enum_form_string_array\", must include one of #{allowable_values}"
      end
      allowable_values = ["_abc", "-efg", "(xyz)"]
      if @api_client.config.client_side_validation && opts[:'enum_form_string'] && !allowable_values.include?(opts[:'enum_form_string'])
        fail ArgumentError, "invalid value for \"enum_form_string\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/fake'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'enum_query_string_array'] = @api_client.build_collection_param(opts[:'enum_query_string_array'], :multi) if !opts[:'enum_query_string_array'].nil?
      query_params[:'enum_query_string'] = opts[:'enum_query_string'] if !opts[:'enum_query_string'].nil?
      query_params[:'enum_query_integer'] = opts[:'enum_query_integer'] if !opts[:'enum_query_integer'].nil?
      query_params[:'enum_query_double'] = opts[:'enum_query_double'] if !opts[:'enum_query_double'].nil?
      query_params[:'enum_query_model_array'] = @api_client.build_collection_param(opts[:'enum_query_model_array'], :multi) if !opts[:'enum_query_model_array'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/x-www-form-urlencoded'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end
      header_params['enum_header_string_array'] = @api_client.build_collection_param(opts[:'enum_header_string_array'], :csv) if !opts[:'enum_header_string_array'].nil?
      header_params['enum_header_string'] = opts[:'enum_header_string'] if !opts[:'enum_header_string'].nil?

      # form parameters
      form_params = opts[:form_params] || {}
      form_params['enum_form_string_array'] = @api_client.build_collection_param(opts[:'enum_form_string_array'], :csv) if !opts[:'enum_form_string_array'].nil?
      form_params['enum_form_string'] = opts[:'enum_form_string'] if !opts[:'enum_form_string'].nil?

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.test_enum_parameters",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_enum_parameters\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Fake endpoint to test group parameters (optional)
    # Fake endpoint to test group parameters (optional)
    # @param [Hash] opts the parameters
    # @option opts [Integer] :required_string_group Required String in group parameters (required)
    # @option opts [Boolean] :required_boolean_group Required Boolean in group parameters (required)
    # @option opts [Integer] :required_int64_group Required Integer in group parameters (required)
    # @option opts [Integer] :string_group String in group parameters
    # @option opts [Boolean] :boolean_group Boolean in group parameters
    # @option opts [Integer] :int64_group Integer in group parameters
    # @return [nil]
    def test_group_parameters(opts = {})
      test_group_parameters_with_http_info(opts)
      nil
    end

    # Fake endpoint to test group parameters (optional)
    # Fake endpoint to test group parameters (optional)
    # @param [Hash] opts the parameters
    # @option opts [Integer] :required_string_group Required String in group parameters (required)
    # @option opts [Boolean] :required_boolean_group Required Boolean in group parameters (required)
    # @option opts [Integer] :required_int64_group Required Integer in group parameters (required)
    # @option opts [Integer] :string_group String in group parameters
    # @option opts [Boolean] :boolean_group Boolean in group parameters
    # @option opts [Integer] :int64_group Integer in group parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def test_group_parameters_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_group_parameters ...'
      end
      # unbox the parameters from the hash
      required_string_group = opts[:'required_string_group']
      required_boolean_group = opts[:'required_boolean_group']
      required_int64_group = opts[:'required_int64_group']
      # verify the required parameter 'required_string_group' is set
      if @api_client.config.client_side_validation && required_string_group.nil?
        fail ArgumentError, "Missing the required parameter 'required_string_group' when calling FakeApi.test_group_parameters"
      end
      # verify the required parameter 'required_boolean_group' is set
      if @api_client.config.client_side_validation && required_boolean_group.nil?
        fail ArgumentError, "Missing the required parameter 'required_boolean_group' when calling FakeApi.test_group_parameters"
      end
      # verify the required parameter 'required_int64_group' is set
      if @api_client.config.client_side_validation && required_int64_group.nil?
        fail ArgumentError, "Missing the required parameter 'required_int64_group' when calling FakeApi.test_group_parameters"
      end
      # resource path
      local_var_path = '/fake'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'required_string_group'] = required_string_group
      query_params[:'required_int64_group'] = required_int64_group
      query_params[:'string_group'] = opts[:'string_group'] if !opts[:'string_group'].nil?
      query_params[:'int64_group'] = opts[:'int64_group'] if !opts[:'int64_group'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      header_params['required_boolean_group'] = required_boolean_group
      header_params['boolean_group'] = opts[:'boolean_group'] if !opts[:'boolean_group'].nil?

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || ['bearer_test']

      new_options = opts.merge(
        :operation => :"FakeApi.test_group_parameters",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_group_parameters\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # test inline additionalProperties
    # 
    # @param request_body [Hash<String, String>] request body
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def test_inline_additional_properties(request_body, opts = {})
      test_inline_additional_properties_with_http_info(request_body, opts)
      nil
    end

    # test inline additionalProperties
    # 
    # @param request_body [Hash<String, String>] request body
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def test_inline_additional_properties_with_http_info(request_body, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_inline_additional_properties ...'
      end
      # verify the required parameter 'request_body' is set
      if @api_client.config.client_side_validation && request_body.nil?
        fail ArgumentError, "Missing the required parameter 'request_body' when calling FakeApi.test_inline_additional_properties"
      end
      # resource path
      local_var_path = '/fake/inline-additionalProperties'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(request_body)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.test_inline_additional_properties",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_inline_additional_properties\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # test inline free-form additionalProperties
    # 
    # @param test_inline_freeform_additional_properties_request [TestInlineFreeformAdditionalPropertiesRequest] request body
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def test_inline_freeform_additional_properties(test_inline_freeform_additional_properties_request, opts = {})
      test_inline_freeform_additional_properties_with_http_info(test_inline_freeform_additional_properties_request, opts)
      nil
    end

    # test inline free-form additionalProperties
    # 
    # @param test_inline_freeform_additional_properties_request [TestInlineFreeformAdditionalPropertiesRequest] request body
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def test_inline_freeform_additional_properties_with_http_info(test_inline_freeform_additional_properties_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_inline_freeform_additional_properties ...'
      end
      # verify the required parameter 'test_inline_freeform_additional_properties_request' is set
      if @api_client.config.client_side_validation && test_inline_freeform_additional_properties_request.nil?
        fail ArgumentError, "Missing the required parameter 'test_inline_freeform_additional_properties_request' when calling FakeApi.test_inline_freeform_additional_properties"
      end
      # resource path
      local_var_path = '/fake/inline-freeform-additionalProperties'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(test_inline_freeform_additional_properties_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.test_inline_freeform_additional_properties",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_inline_freeform_additional_properties\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # test json serialization of form data
    # 
    # @param param [String] field1
    # @param param2 [String] field2
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def test_json_form_data(param, param2, opts = {})
      test_json_form_data_with_http_info(param, param2, opts)
      nil
    end

    # test json serialization of form data
    # 
    # @param param [String] field1
    # @param param2 [String] field2
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def test_json_form_data_with_http_info(param, param2, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_json_form_data ...'
      end
      # verify the required parameter 'param' is set
      if @api_client.config.client_side_validation && param.nil?
        fail ArgumentError, "Missing the required parameter 'param' when calling FakeApi.test_json_form_data"
      end
      # verify the required parameter 'param2' is set
      if @api_client.config.client_side_validation && param2.nil?
        fail ArgumentError, "Missing the required parameter 'param2' when calling FakeApi.test_json_form_data"
      end
      # resource path
      local_var_path = '/fake/jsonFormData'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/x-www-form-urlencoded'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}
      form_params['param'] = param
      form_params['param2'] = param2

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.test_json_form_data",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_json_form_data\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # To test the collection format in query parameters
    # @param pipe [Array<String>] 
    # @param ioutil [Array<String>] 
    # @param http [Array<String>] 
    # @param url [Array<String>] 
    # @param context [Array<String>] 
    # @param allow_empty [String] 
    # @param [Hash] opts the optional parameters
    # @option opts [Hash<String, String>] :language 
    # @return [nil]
    def test_query_parameter_collection_format(pipe, ioutil, http, url, context, allow_empty, opts = {})
      test_query_parameter_collection_format_with_http_info(pipe, ioutil, http, url, context, allow_empty, opts)
      nil
    end

    # To test the collection format in query parameters
    # @param pipe [Array<String>] 
    # @param ioutil [Array<String>] 
    # @param http [Array<String>] 
    # @param url [Array<String>] 
    # @param context [Array<String>] 
    # @param allow_empty [String] 
    # @param [Hash] opts the optional parameters
    # @option opts [Hash<String, String>] :language 
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def test_query_parameter_collection_format_with_http_info(pipe, ioutil, http, url, context, allow_empty, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_query_parameter_collection_format ...'
      end
      # verify the required parameter 'pipe' is set
      if @api_client.config.client_side_validation && pipe.nil?
        fail ArgumentError, "Missing the required parameter 'pipe' when calling FakeApi.test_query_parameter_collection_format"
      end
      # verify the required parameter 'ioutil' is set
      if @api_client.config.client_side_validation && ioutil.nil?
        fail ArgumentError, "Missing the required parameter 'ioutil' when calling FakeApi.test_query_parameter_collection_format"
      end
      # verify the required parameter 'http' is set
      if @api_client.config.client_side_validation && http.nil?
        fail ArgumentError, "Missing the required parameter 'http' when calling FakeApi.test_query_parameter_collection_format"
      end
      # verify the required parameter 'url' is set
      if @api_client.config.client_side_validation && url.nil?
        fail ArgumentError, "Missing the required parameter 'url' when calling FakeApi.test_query_parameter_collection_format"
      end
      # verify the required parameter 'context' is set
      if @api_client.config.client_side_validation && context.nil?
        fail ArgumentError, "Missing the required parameter 'context' when calling FakeApi.test_query_parameter_collection_format"
      end
      # verify the required parameter 'allow_empty' is set
      if @api_client.config.client_side_validation && allow_empty.nil?
        fail ArgumentError, "Missing the required parameter 'allow_empty' when calling FakeApi.test_query_parameter_collection_format"
      end
      # resource path
      local_var_path = '/fake/test-query-parameters'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'pipe'] = @api_client.build_collection_param(pipe, :pipes)
      query_params[:'ioutil'] = @api_client.build_collection_param(ioutil, :csv)
      query_params[:'http'] = @api_client.build_collection_param(http, :ssv)
      query_params[:'url'] = @api_client.build_collection_param(url, :csv)
      query_params[:'context'] = @api_client.build_collection_param(context, :multi)
      query_params[:'allowEmpty'] = allow_empty
      query_params[:'language'] = opts[:'language'] if !opts[:'language'].nil?

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.test_query_parameter_collection_format",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:PUT, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_query_parameter_collection_format\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # test referenced string map
    # 
    # @param request_body [Hash<String, String>] request body
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def test_string_map_reference(request_body, opts = {})
      test_string_map_reference_with_http_info(request_body, opts)
      nil
    end

    # test referenced string map
    # 
    # @param request_body [Hash<String, String>] request body
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def test_string_map_reference_with_http_info(request_body, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: FakeApi.test_string_map_reference ...'
      end
      # verify the required parameter 'request_body' is set
      if @api_client.config.client_side_validation && request_body.nil?
        fail ArgumentError, "Missing the required parameter 'request_body' when calling FakeApi.test_string_map_reference"
      end
      # resource path
      local_var_path = '/fake/stringMap-reference'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(request_body)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"FakeApi.test_string_map_reference",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: FakeApi#test_string_map_reference\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end
  end
end
