/*
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

use std::rc::Rc;
use std::borrow::Borrow;
use std::pin::Pin;
#[allow(unused_imports)]
use std::option::Option;

use hyper;
use futures::Future;

use crate::models;
use super::{Error, configuration};
use super::request as __internal_request;

pub struct StoreApiClient<C: hyper::client::connect::Connect>
    where C: Clone + std::marker::Send + Sync + 'static {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::connect::Connect> StoreApiClient<C>
    where C: Clone + std::marker::Send + Sync {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> StoreApiClient<C> {
        StoreApiClient {
            configuration,
        }
    }
}

pub trait StoreApi {
    fn delete_order(&self, order_id: &str) -> Pin<Box<dyn Future<Output = Result<(), Error>>>>;
    fn get_inventory(&self, ) -> Pin<Box<dyn Future<Output = Result<std::collections::HashMap<String, i32>, Error>>>>;
    fn get_order_by_id(&self, order_id: i64) -> Pin<Box<dyn Future<Output = Result<models::Order, Error>>>>;
    fn place_order(&self, order: models::Order) -> Pin<Box<dyn Future<Output = Result<models::Order, Error>>>>;
}

impl<C: hyper::client::connect::Connect>StoreApi for StoreApiClient<C>
    where C: Clone + std::marker::Send + Sync {
    #[allow(unused_mut)]
    fn delete_order(&self, order_id: &str) -> Pin<Box<dyn Future<Output = Result<(), Error>>>> {
        let mut req = __internal_request::Request::new(hyper::Method::DELETE, "/store/order/{orderId}".to_string())
        ;
        req = req.with_path_param("orderId".to_string(), order_id.to_string());
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

    #[allow(unused_mut)]
    fn get_inventory(&self, ) -> Pin<Box<dyn Future<Output = Result<std::collections::HashMap<String, i32>, Error>>>> {
        let mut req = __internal_request::Request::new(hyper::Method::GET, "/store/inventory".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "api_key".to_owned(),
            }))
        ;

        req.execute(self.configuration.borrow())
    }

    #[allow(unused_mut)]
    fn get_order_by_id(&self, order_id: i64) -> Pin<Box<dyn Future<Output = Result<models::Order, Error>>>> {
        let mut req = __internal_request::Request::new(hyper::Method::GET, "/store/order/{orderId}".to_string())
        ;
        req = req.with_path_param("orderId".to_string(), order_id.to_string());

        req.execute(self.configuration.borrow())
    }

    #[allow(unused_mut)]
    fn place_order(&self, order: models::Order) -> Pin<Box<dyn Future<Output = Result<models::Order, Error>>>> {
        let mut req = __internal_request::Request::new(hyper::Method::POST, "/store/order".to_string())
        ;
        req = req.with_body_param(order);

        req.execute(self.configuration.borrow())
    }

}
