/*
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

use std::rc::Rc;
use std::borrow::Borrow;
use std::pin::Pin;
#[allow(unused_imports)]
use std::option::Option;

use hyper;
use futures::Future;

use crate::models;
use super::{Error, configuration};
use super::request as __internal_request;

pub struct UserApiClient<C: hyper::client::connect::Connect>
    where C: Clone + std::marker::Send + Sync + 'static {
    configuration: Rc<configuration::Configuration<C>>,
}

impl<C: hyper::client::connect::Connect> UserApiClient<C>
    where C: Clone + std::marker::Send + Sync {
    pub fn new(configuration: Rc<configuration::Configuration<C>>) -> UserApiClient<C> {
        UserApiClient {
            configuration,
        }
    }
}

pub trait UserApi {
    fn create_user(&self, user: models::User) -> Pin<Box<dyn Future<Output = Result<(), Error>>>>;
    fn create_users_with_array_input(&self, user: Vec<models::User>) -> Pin<Box<dyn Future<Output = Result<(), Error>>>>;
    fn create_users_with_list_input(&self, user: Vec<models::User>) -> Pin<Box<dyn Future<Output = Result<(), Error>>>>;
    fn delete_user(&self, username: &str) -> Pin<Box<dyn Future<Output = Result<(), Error>>>>;
    fn get_user_by_name(&self, username: &str) -> Pin<Box<dyn Future<Output = Result<models::User, Error>>>>;
    fn login_user(&self, username: &str, password: &str) -> Pin<Box<dyn Future<Output = Result<String, Error>>>>;
    fn logout_user(&self, ) -> Pin<Box<dyn Future<Output = Result<(), Error>>>>;
    fn update_user(&self, username: &str, user: models::User) -> Pin<Box<dyn Future<Output = Result<(), Error>>>>;
}

impl<C: hyper::client::connect::Connect>UserApi for UserApiClient<C>
    where C: Clone + std::marker::Send + Sync {
    #[allow(unused_mut)]
    fn create_user(&self, user: models::User) -> Pin<Box<dyn Future<Output = Result<(), Error>>>> {
        let mut req = __internal_request::Request::new(hyper::Method::POST, "/user".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "api_key".to_owned(),
            }))
        ;
        req = req.with_body_param(user);
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

    #[allow(unused_mut)]
    fn create_users_with_array_input(&self, user: Vec<models::User>) -> Pin<Box<dyn Future<Output = Result<(), Error>>>> {
        let mut req = __internal_request::Request::new(hyper::Method::POST, "/user/createWithArray".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "api_key".to_owned(),
            }))
        ;
        req = req.with_body_param(user);
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

    #[allow(unused_mut)]
    fn create_users_with_list_input(&self, user: Vec<models::User>) -> Pin<Box<dyn Future<Output = Result<(), Error>>>> {
        let mut req = __internal_request::Request::new(hyper::Method::POST, "/user/createWithList".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "api_key".to_owned(),
            }))
        ;
        req = req.with_body_param(user);
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

    #[allow(unused_mut)]
    fn delete_user(&self, username: &str) -> Pin<Box<dyn Future<Output = Result<(), Error>>>> {
        let mut req = __internal_request::Request::new(hyper::Method::DELETE, "/user/{username}".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "api_key".to_owned(),
            }))
        ;
        req = req.with_path_param("username".to_string(), username.to_string());
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

    #[allow(unused_mut)]
    fn get_user_by_name(&self, username: &str) -> Pin<Box<dyn Future<Output = Result<models::User, Error>>>> {
        let mut req = __internal_request::Request::new(hyper::Method::GET, "/user/{username}".to_string())
        ;
        req = req.with_path_param("username".to_string(), username.to_string());

        req.execute(self.configuration.borrow())
    }

    #[allow(unused_mut)]
    fn login_user(&self, username: &str, password: &str) -> Pin<Box<dyn Future<Output = Result<String, Error>>>> {
        let mut req = __internal_request::Request::new(hyper::Method::GET, "/user/login".to_string())
        ;
        req = req.with_query_param("username".to_string(), username.to_string());
        req = req.with_query_param("password".to_string(), password.to_string());

        req.execute(self.configuration.borrow())
    }

    #[allow(unused_mut)]
    fn logout_user(&self, ) -> Pin<Box<dyn Future<Output = Result<(), Error>>>> {
        let mut req = __internal_request::Request::new(hyper::Method::GET, "/user/logout".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "api_key".to_owned(),
            }))
        ;
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

    #[allow(unused_mut)]
    fn update_user(&self, username: &str, user: models::User) -> Pin<Box<dyn Future<Output = Result<(), Error>>>> {
        let mut req = __internal_request::Request::new(hyper::Method::PUT, "/user/{username}".to_string())
            .with_auth(__internal_request::Auth::ApiKey(__internal_request::ApiKey{
                in_header: true,
                in_query: false,
                param_name: "api_key".to_owned(),
            }))
        ;
        req = req.with_path_param("username".to_string(), username.to_string());
        req = req.with_body_param(user);
        req = req.returns_nothing();

        req.execute(self.configuration.borrow())
    }

}
