/*
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */


use reqwest;
use serde::{Deserialize, Serialize, de::Error as _};
use crate::{apis::ResponseContent, models};
use super::{Error, configuration, ContentType};

/// struct for passing parameters to the method [`tests_all_of_with_one_model_get`]
#[derive(Clone, Debug)]
pub struct TestsAllOfWithOneModelGetParams {
    pub person: models::Person
}

/// struct for passing parameters to the method [`tests_inline_enum_boxing_get`]
#[derive(Clone, Debug)]
pub struct TestsInlineEnumBoxingGetParams {
    /// Filter by status (inline enum)
    pub status: Option<String>
}

/// struct for passing parameters to the method [`tests_inline_enum_boxing_post`]
#[derive(Clone, Debug)]
pub struct TestsInlineEnumBoxingPostParams {
    pub model_with_inline_enum: models::ModelWithInlineEnum
}


/// struct for typed successes of method [`tests_all_of_with_one_model_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestsAllOfWithOneModelGetSuccess {
    Status200(String),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`tests_file_response_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestsFileResponseGetSuccess {
    Status200(std::path::PathBuf),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`tests_inline_enum_boxing_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestsInlineEnumBoxingGetSuccess {
    Status200(Vec<models::ModelWithInlineEnum>),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`tests_inline_enum_boxing_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestsInlineEnumBoxingPostSuccess {
    Status200(models::ModelWithInlineEnum),
    UnknownValue(serde_json::Value),
}

/// struct for typed successes of method [`tests_type_testing_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestsTypeTestingGetSuccess {
    Status200(models::TypeTesting),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`tests_all_of_with_one_model_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestsAllOfWithOneModelGetError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`tests_file_response_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestsFileResponseGetError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`tests_inline_enum_boxing_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestsInlineEnumBoxingGetError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`tests_inline_enum_boxing_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestsInlineEnumBoxingPostError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`tests_type_testing_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TestsTypeTestingGetError {
    UnknownValue(serde_json::Value),
}


pub async fn tests_all_of_with_one_model_get(configuration: &configuration::Configuration, params: TestsAllOfWithOneModelGetParams) -> Result<ResponseContent<TestsAllOfWithOneModelGetSuccess>, Error<TestsAllOfWithOneModelGetError>> {

    let uri_str = format!("{}/tests/allOfWithOneModel", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    req_builder = req_builder.json(&params.person);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<TestsAllOfWithOneModelGetSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<TestsAllOfWithOneModelGetError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

pub async fn tests_file_response_get(configuration: &configuration::Configuration) -> Result<reqwest::Response, Error<TestsFileResponseGetError>> {

    let uri_str = format!("{}/tests/fileResponse", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    if !status.is_client_error() && !status.is_server_error() {
        Ok(resp)
    } else {
        let content = resp.text().await?;
        let entity: Option<TestsFileResponseGetError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

/// Tests inline enum query parameters
pub async fn tests_inline_enum_boxing_get(configuration: &configuration::Configuration, params: TestsInlineEnumBoxingGetParams) -> Result<ResponseContent<TestsInlineEnumBoxingGetSuccess>, Error<TestsInlineEnumBoxingGetError>> {

    let uri_str = format!("{}/tests/inlineEnumBoxing", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref param_value) = params.status {
        req_builder = req_builder.query(&[("status", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<TestsInlineEnumBoxingGetSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<TestsInlineEnumBoxingGetError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

/// Regression test to ensure inline enum fields are not wrapped in Box::new() in model constructors
pub async fn tests_inline_enum_boxing_post(configuration: &configuration::Configuration, params: TestsInlineEnumBoxingPostParams) -> Result<ResponseContent<TestsInlineEnumBoxingPostSuccess>, Error<TestsInlineEnumBoxingPostError>> {

    let uri_str = format!("{}/tests/inlineEnumBoxing", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::POST, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }
    req_builder = req_builder.json(&params.model_with_inline_enum);

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<TestsInlineEnumBoxingPostSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<TestsInlineEnumBoxingPostError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

pub async fn tests_type_testing_get(configuration: &configuration::Configuration) -> Result<ResponseContent<TestsTypeTestingGetSuccess>, Error<TestsTypeTestingGetError>> {

    let uri_str = format!("{}/tests/typeTesting", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        let entity: Option<TestsTypeTestingGetSuccess> = serde_json::from_str(&content).ok();
        Ok(ResponseContent { status, content, entity })
    } else {
        let content = resp.text().await?;
        let entity: Option<TestsTypeTestingGetError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

