/*
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct FooModelWithInlineEnum {
    /// Model ID
    #[serde(rename = "id", skip_serializing_if = "Option::is_none")]
    pub id: Option<i64>,
    /// Status with inline enum (tests inline enum not being boxed in constructor)
    #[serde(rename = "status")]
    pub status: Status,
    /// Priority level (optional inline enum)
    #[serde(rename = "priority", skip_serializing_if = "Option::is_none")]
    pub priority: Option<Priority>,
    #[serde(rename = "metadata", skip_serializing_if = "Option::is_none")]
    pub metadata: Option<Box<models::FooModelWithInlineEnumMetadata>>,
}

impl FooModelWithInlineEnum {
    pub fn new(status: Status) -> FooModelWithInlineEnum {
        FooModelWithInlineEnum {
            id: None,
            status,
            priority: None,
            metadata: None,
        }
    }
}
/// Status with inline enum (tests inline enum not being boxed in constructor)
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Status {
    #[serde(rename = "draft")]
    Draft,
    #[serde(rename = "published")]
    Published,
    #[serde(rename = "archived")]
    Archived,
}

impl Default for Status {
    fn default() -> Status {
        Self::Draft
    }
}
/// Priority level (optional inline enum)
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Priority {
    #[serde(rename = "low")]
    Low,
    #[serde(rename = "medium")]
    Medium,
    #[serde(rename = "high")]
    High,
    #[serde(rename = "critical")]
    Critical,
}

impl Default for Priority {
    fn default() -> Priority {
        Self::Low
    }
}

