/** OpenAPI Petstore
  * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
  *
  * The version of the OpenAPI document: 1.0.0
  * Contact: team@openapitools.org
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
  * https://openapi-generator.tech
  * Do not edit the class manually.
  */
package org.openapitools.client.apis

import cats.effect.Concurrent
import io.circe.Encoder
import org.http4s.Uri
import org.http4s.client.Client as Http4sClient
import java.time.Instant
import scala.collection.immutable.Seq
import org.openapitools.client.models.User
import org.openapitools.client.models.*

trait UserApiEndpoints[F[*]] {

  def createUser(user: User)(using auth: _Authorization.ApiKey): F[Unit]
  def createUsersWithArrayInput(user: Seq[User])(using auth: _Authorization.ApiKey): F[Unit]
  def createUsersWithListInput(user: Seq[User])(using auth: _Authorization.ApiKey): F[Unit]
  def deleteUser(username: String)(using auth: _Authorization.ApiKey): F[Unit]
  def getUserByName(username: String): F[User]
  def loginUser(username: String, password: String): F[String]
  def logoutUser()(using auth: _Authorization.ApiKey): F[Unit]
  def updateUser(username: String, user: User)(using auth: _Authorization.ApiKey): F[Unit]

}

class UserApiEndpointsImpl[F[*]: Concurrent](
  override val baseUrl: Uri,
  defaultHeaders: Seq[(String, String)] = Nil,
  httpClient: Http4sClient[F]
) extends BaseClient[F](baseUrl, defaultHeaders, httpClient) with UserApiEndpoints[F] {
  
  import JsonSupports.*
  import io.circe.syntax.EncoderOps
  import cats.implicits.toFlatMapOps

  override def createUser(user: User)(using auth: _Authorization.ApiKey): F[Unit] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten

    _executeRequest[User, Unit](
      method = "POST",
      path = s"/user",
      body = Some(user),
      formParameters = None,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = Some(auth)) {
        r => Concurrent[F].pure(())
    }
  }

  override def createUsersWithArrayInput(user: Seq[User])(using auth: _Authorization.ApiKey): F[Unit] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten

    _executeRequest[Seq[User], Unit](
      method = "POST",
      path = s"/user/createWithArray",
      body = Some(user),
      formParameters = None,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = Some(auth)) {
        r => Concurrent[F].pure(())
    }
  }

  override def createUsersWithListInput(user: Seq[User])(using auth: _Authorization.ApiKey): F[Unit] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten

    _executeRequest[Seq[User], Unit](
      method = "POST",
      path = s"/user/createWithList",
      body = Some(user),
      formParameters = None,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = Some(auth)) {
        r => Concurrent[F].pure(())
    }
  }

  override def deleteUser(username: String)(using auth: _Authorization.ApiKey): F[Unit] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten

    _executeRequest[Unit, Unit](
      method = "DELETE",
      path = s"/user/${username}",
      body = None,
      formParameters = None,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = Some(auth)) {
        
        case r if r.status.code == 400 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
        case r if r.status.code == 404 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
    }
  }

  override def getUserByName(username: String): F[User] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten

    _executeRequest[Unit, User](
      method = "GET",
      path = s"/user/${username}",
      body = None,
      formParameters = None,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = None) {
        
        case r if r.status.code == 200 => parseJson[F, User]("User", r)
        case r if r.status.code == 400 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
        case r if r.status.code == 404 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
    }
  }

  override def loginUser(username: String, password: String): F[String] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten
    val queryParameters = (
      Some(Seq("username" -> username)) ++ 
      Some(Seq("password" -> password))
    ).toSeq.flatten

    _executeRequest[Unit, String](
      method = "GET",
      path = s"/user/login",
      body = None,
      formParameters = None,
      queryParameters = queryParameters,
      requestHeaders = requestHeaders,
      auth = None) {
        
        case r if r.status.code == 200 => parseJson[F, String]("String", r)
        case r if r.status.code == 400 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
    }
  }

  override def logoutUser()(using auth: _Authorization.ApiKey): F[Unit] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten

    _executeRequest[Unit, Unit](
      method = "GET",
      path = s"/user/logout",
      body = None,
      formParameters = None,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = Some(auth)) {
        r => Concurrent[F].pure(())
    }
  }

  override def updateUser(username: String, user: User)(using auth: _Authorization.ApiKey): F[Unit] = {
    val requestHeaders = Seq(
      Some("Content-Type" -> "application/json")
    ).flatten

    _executeRequest[User, Unit](
      method = "PUT",
      path = s"/user/${username}",
      body = Some(user),
      formParameters = None,
      queryParameters = Nil,
      requestHeaders = requestHeaders,
      auth = Some(auth)) {
        
        case r if r.status.code == 400 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
        case r if r.status.code == 404 => Concurrent[F].raiseError(_FailedRequest(r.status.code, r.status.reason))
    }
  }

}


