/** OpenAPI Petstore
  * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
  *
  * The version of the OpenAPI document: 1.0.0
  * Contact: team@openapitools.org
  *
  * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
  * https://openapi-generator.tech
  * Do not edit the class manually.
  */
package org.openapitools.client

import io.circe.{Decoder, Encoder, Json, ACursor}
import java.time.{Instant, LocalDate, OffsetDateTime}
import java.util.UUID

package object models {

  given decodeUUID: Decoder[UUID] =
    Decoder.decodeString.map(str => UUID.fromString(str))

  given encodeUUID: Encoder[UUID] =
    Encoder.encodeString.contramap[UUID](uuid => uuid.toString)

  given decodeInstant: Decoder[Instant] =
    Decoder.decodeString.map(str => OffsetDateTime.parse(str).toInstant)

  given encodeInstant: Encoder[Instant] =
    Encoder.encodeString.contramap[Instant](_.toString)

  given decodeLocalDate: Decoder[LocalDate] =
    Decoder.decodeString.map(str => LocalDate.parse(str))

  given encodeLocalDate: Encoder[LocalDate] =
    Encoder.encodeString.contramap[LocalDate](_.toString)

  given decodeJson: Decoder[Json] =
    Decoder.decodeString.map(str => Json.fromString(str))

  given encodeJson: Encoder[Json] =
    Encoder.encodeString.contramap[Json](_.toString)

  def mapEmptyStringToNull(f: ACursor): ACursor =
    f.withFocus(json => if json.toString == "\"\"" then Json.Null else json)

}