/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.openapitools.client.api

import java.time.OffsetDateTime
import org.openapitools.client.model.User
import org.openapitools.client.core._
import org.openapitools.client.core.CollectionFormats._
import org.openapitools.client.core.ApiKeyLocations._

object UserApi {

  def apply(baseUrl: String = "https://petstore.swagger.io/v2") = new UserApi(baseUrl)
}

class UserApi(baseUrl: String) {

  /**
   * This can only be done by the logged in user.
   * 
   * Expected answers:
   *   code 0 :  (successful operation)
   * 
   * Available security schemes:
   *   auth_cookie (apiKey)
   * 
   * @param user Created user object
   */
  def createUser(user: User)(implicit apiKey: ApiKeyValue): ApiRequest[Unit] =
    ApiRequest[Unit](ApiMethods.POST, baseUrl, "/user", "application/json")
      .withApiKey(apiKey, "AUTH_KEY", COOKIE)
      .withBody(user)
      .withDefaultErrorResponse[Unit]
      

  /**
   * 
   * 
   * Expected answers:
   *   code 0 :  (successful operation)
   * 
   * Available security schemes:
   *   auth_cookie (apiKey)
   * 
   * @param user List of user object
   */
  def createUsersWithArrayInput(user: Seq[User])(implicit apiKey: ApiKeyValue): ApiRequest[Unit] =
    ApiRequest[Unit](ApiMethods.POST, baseUrl, "/user/createWithArray", "application/json")
      .withApiKey(apiKey, "AUTH_KEY", COOKIE)
      .withBody(user)
      .withDefaultErrorResponse[Unit]
      

  /**
   * 
   * 
   * Expected answers:
   *   code 0 :  (successful operation)
   * 
   * Available security schemes:
   *   auth_cookie (apiKey)
   * 
   * @param user List of user object
   */
  def createUsersWithListInput(user: Seq[User])(implicit apiKey: ApiKeyValue): ApiRequest[Unit] =
    ApiRequest[Unit](ApiMethods.POST, baseUrl, "/user/createWithList", "application/json")
      .withApiKey(apiKey, "AUTH_KEY", COOKIE)
      .withBody(user)
      .withDefaultErrorResponse[Unit]
      

  /**
   * This can only be done by the logged in user.
   * 
   * Expected answers:
   *   code 400 :  (Invalid username supplied)
   *   code 404 :  (User not found)
   * 
   * Available security schemes:
   *   auth_cookie (apiKey)
   * 
   * @param username The name that needs to be deleted
   */
  def deleteUser(username: String)(implicit apiKey: ApiKeyValue): ApiRequest[Unit] =
    ApiRequest[Unit](ApiMethods.DELETE, baseUrl, "/user/{username}", "application/json")
      .withApiKey(apiKey, "AUTH_KEY", COOKIE)
      .withPathParam("username", username)
      .withErrorResponse[Unit](400)
      .withErrorResponse[Unit](404)
      

  /**
   * 
   * 
   * Expected answers:
   *   code 200 : User (successful operation)
   *   code 400 :  (Invalid username supplied)
   *   code 404 :  (User not found)
   * 
   * @param username The name that needs to be fetched. Use user1 for testing.
   */
  def getUserByName(username: String): ApiRequest[User] =
    ApiRequest[User](ApiMethods.GET, baseUrl, "/user/{username}", "application/json")
      .withPathParam("username", username)
      .withSuccessResponse[User](200)
      .withErrorResponse[Unit](400)
      .withErrorResponse[Unit](404)
      

  /**
   * 
   * 
   * Expected answers:
   *   code 200 : String (successful operation)
   *              Headers :
   *                Set-Cookie - Cookie authentication key for use with the `auth_cookie` apiKey authentication.
   *                X-Rate-Limit - calls per hour allowed by the user
   *                X-Expires-After - date in UTC when token expires
   *   code 400 :  (Invalid username/password supplied)
   * 
   * @param username The user name for login
   * @param password The password for login in clear text
   */
  def loginUser(username: String, password: String): ApiRequest[String] =
    ApiRequest[String](ApiMethods.GET, baseUrl, "/user/login", "application/json")
      .withQueryParam("username", username)
      .withQueryParam("password", password)
      .withSuccessResponse[String](200)
      .withErrorResponse[Unit](400)
      
  object LoginUserHeaders {
    def setCookie(r: ApiReturnWithHeaders) = r.getStringHeader("Set-Cookie")
    def xRateLimit(r: ApiReturnWithHeaders) = r.getIntHeader("X-Rate-Limit")
    def xExpiresAfter(r: ApiReturnWithHeaders) = r.getOffsetDateTimeHeader("X-Expires-After")
  }

  /**
   * 
   * 
   * Expected answers:
   *   code 0 :  (successful operation)
   * 
   * Available security schemes:
   *   auth_cookie (apiKey)
   */
  def logoutUser()(implicit apiKey: ApiKeyValue): ApiRequest[Unit] =
    ApiRequest[Unit](ApiMethods.GET, baseUrl, "/user/logout", "application/json")
      .withApiKey(apiKey, "AUTH_KEY", COOKIE)
      .withDefaultErrorResponse[Unit]
      

  /**
   * This can only be done by the logged in user.
   * 
   * Expected answers:
   *   code 400 :  (Invalid user supplied)
   *   code 404 :  (User not found)
   * 
   * Available security schemes:
   *   auth_cookie (apiKey)
   * 
   * @param username name that need to be deleted
   * @param user Updated user object
   */
  def updateUser(username: String, user: User)(implicit apiKey: ApiKeyValue): ApiRequest[Unit] =
    ApiRequest[Unit](ApiMethods.PUT, baseUrl, "/user/{username}", "application/json")
      .withApiKey(apiKey, "AUTH_KEY", COOKIE)
      .withBody(user)
      .withPathParam("username", username)
      .withErrorResponse[Unit](400)
      .withErrorResponse[Unit](404)
      



}

