# openapi-client

OpenAPI Petstore
- API version: 1.0.0
    - Generator version: 7.20.0-SNAPSHOT

This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.


*Automatically generated by the [OpenAPI Generator](https://openapi-generator.tech)*

## Requirements

Building the API client library requires:
1. Java 1.7+
2. Maven/Gradle/SBT

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
    <groupId>org.openapitools</groupId>
    <artifactId>openapi-client</artifactId>
    <version>1.0.0</version>
    <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
compile "org.openapitools:openapi-client:1.0.0"
```

### SBT users

```scala
libraryDependencies += "org.openapitools" % "openapi-client" % "1.0.0"
```

## Getting Started

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*PetApi* | **addPet** | **POST** /pet | Add a new pet to the store
*PetApi* | **deletePet** | **DELETE** /pet/${petIdPathParam} | Deletes a pet
*PetApi* | **findPetsByStatus** | **GET** /pet/findByStatus | Finds Pets by status
*PetApi* | **findPetsByTags** | **GET** /pet/findByTags | Finds Pets by tags
*PetApi* | **getPetById** | **GET** /pet/${petIdPathParam} | Find pet by ID
*PetApi* | **updatePet** | **PUT** /pet | Update an existing pet
*PetApi* | **updatePetWithForm** | **POST** /pet/${petIdPathParam} | Updates a pet in the store with form data
*PetApi* | **uploadFile** | **POST** /pet/${petIdPathParam}/uploadImage | uploads an image
*StoreApi* | **deleteOrder** | **DELETE** /store/order/${orderIdPathParam} | Delete purchase order by ID
*StoreApi* | **getInventory** | **GET** /store/inventory | Returns pet inventories by status
*StoreApi* | **getOrderById** | **GET** /store/order/${orderIdPathParam} | Find purchase order by ID
*StoreApi* | **placeOrder** | **POST** /store/order | Place an order for a pet
*UserApi* | **createUser** | **POST** /user | Create user
*UserApi* | **createUsersWithArrayInput** | **POST** /user/createWithArray | Creates list of users with given input array
*UserApi* | **createUsersWithListInput** | **POST** /user/createWithList | Creates list of users with given input array
*UserApi* | **deleteUser** | **DELETE** /user/${usernamePathParam} | Delete user
*UserApi* | **getUserByName** | **GET** /user/${usernamePathParam} | Get user by user name
*UserApi* | **loginUser** | **GET** /user/login | Logs user into the system
*UserApi* | **logoutUser** | **GET** /user/logout | Logs out current logged in user session
*UserApi* | **updateUser** | **PUT** /user/${usernamePathParam} | Updated user


## Documentation for Models

 - [ApiResponse](ApiResponse.md)
 - [Category](Category.md)
 - [Order](Order.md)
 - [Pet](Pet.md)
 - [Tag](Tag.md)
 - [User](User.md)


<a id="documentation-for-authorization"></a>
## Documentation for Authorization


Authentication schemes defined for the API:
    <a id="api_key"></a>
    ### api_key

    - **Type**: API key
    - **API key parameter name**: api_key
    - **Location**: HTTP header
                

## Author



