/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.openapitools.client.api

import org.openapitools.client.model.ApiResponse
import java.io.File
import org.openapitools.client.model.Pet
import org.openapitools.client.core.JsonSupport.{*, given}
import org.openapitools.client.core.FormSerializable
import org.openapitools.client.core.FormStyleFormat
import org.openapitools.client.core.HeaderSerializable
import org.openapitools.client.core.ApiKeyLocation
import org.openapitools.client.core.PathStyleFormat
import org.openapitools.client.core.PathSerializable
import org.openapitools.client.core.CookieSerializable
import org.openapitools.client.core.Helpers.*
import sttp.client4.jsoniter.*
import sttp.client4.*
import sttp.model.Method

object PetApi:
  def apply(baseUrl: String = "http://petstore.swagger.io/v2"): PetApi[org.openapitools.client.core.Authorization.NoAuthorization.type] = PetApi(baseUrl, org.openapitools.client.core.Authorization.NoAuthorization)
  def withBasicAuth(baseUrl: String, username: String, password: String): PetApi[org.openapitools.client.core.Authorization.BasicAuth] =
    PetApi(baseUrl, org.openapitools.client.core.Authorization.BasicAuth(username, password))

  def withApiKeyAuth(baseUrl: String, apiKey: String): PetApi[org.openapitools.client.core.Authorization.ApiKey] =
    PetApi(baseUrl, org.openapitools.client.core.Authorization.ApiKey(apiKey))

  def withBearerTokenAuth(baseUrl: String, token: String): PetApi[org.openapitools.client.core.Authorization.BearerToken] =
    PetApi(baseUrl, org.openapitools.client.core.Authorization.BearerToken(token))

case class PetApi[Auth <: org.openapitools.client.core.Authorization] private (baseUrl: String, authConfig: org.openapitools.client.core.Authorization):
  def withBasicAuth(username: String, password: String): PetApi[org.openapitools.client.core.Authorization.BasicAuth] =
    copy(authConfig = org.openapitools.client.core.Authorization.BasicAuth(username, password))

  def withApiKeyAuth(apiKey: String): PetApi[org.openapitools.client.core.Authorization.ApiKey] =
    copy(authConfig = org.openapitools.client.core.Authorization.ApiKey(apiKey))

  def withNoAuth: PetApi[org.openapitools.client.core.Authorization.NoAuthorization.type] =
    copy(authConfig = org.openapitools.client.core.Authorization.NoAuthorization)

  def withBearerTokenAuth(token: String): PetApi[org.openapitools.client.core.Authorization.BearerToken] =
    copy(authConfig = org.openapitools.client.core.Authorization.BearerToken(token))

  /**
   * 
   * 
   * Expected answers:
   *   code 200 : Pet (successful operation)
   *   code 405 :  (Invalid input)
   * 
   * @param pet Pet object that needs to be added to the store
   */
  def addPet(pet: Pet): sttp.client4.Request[Either[ResponseException[String], Pet]] =
    val requestURL =
      uri"$baseUrl/pet"

    basicRequest
      .method(Method.POST, requestURL)
      .contentType("application/json")
      .body(asJson(pet))
      .response(asJson[Pet])

  /**
   * 
   * 
   * Expected answers:
   *   code 400 :  (Invalid pet value)
   * 
   * @param petId Pet id to delete
   * @param apiKey 
   */
  def deletePet(petId: Long, apiKey: Option[String] = scala.None): sttp.client4.Request[Either[ResponseException[String], Unit]] =
    val petIdPathParam = PathSerializable.serialize("petId", petId, PathStyleFormat.SIMPLE, false)
    val requestURL =
      uri"$baseUrl/pet/${petIdPathParam}"

    basicRequest
      .method(Method.DELETE, requestURL)
      .contentType("application/json")
      .headers(HeaderSerializable.serialize("api_key", apiKey, false))
      .response(asString.mapWithMetadata(ResponseAs.deserializeRightWithError(_ => Right(()))))

  /**
   * Multiple status values can be provided with comma separated strings
   * 
   * Expected answers:
   *   code 200 : Seq[Pet] (successful operation)
   *   code 400 :  (Invalid status value)
   * 
   * @param status Status values that need to be considered for filter
   */
  def findPetsByStatus(status: Seq[String]): sttp.client4.Request[Either[ResponseException[String], Seq[Pet]]] =
    val requestURL =
      uri"$baseUrl/pet/findByStatus"
        .addParams(FormSerializable.serialize("status", status, FormStyleFormat.FORM, false): _*)

    basicRequest
      .method(Method.GET, requestURL)
      .contentType("application/json")
      .response(asJson[Seq[Pet]])

  /**
   * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
   * 
   * Expected answers:
   *   code 200 : Seq[Pet] (successful operation)
   *   code 400 :  (Invalid tag value)
   * 
   * @param tags Tags to filter by
   */
  def findPetsByTags(tags: Seq[String]): sttp.client4.Request[Either[ResponseException[String], Seq[Pet]]] =
    val requestURL =
      uri"$baseUrl/pet/findByTags"
        .addParams(FormSerializable.serialize("tags", tags, FormStyleFormat.FORM, false): _*)

    basicRequest
      .method(Method.GET, requestURL)
      .contentType("application/json")
      .response(asJson[Seq[Pet]])

  /**
   * Returns a single pet
   * 
   * Expected answers:
   *   code 200 : Pet (successful operation)
   *   code 400 :  (Invalid ID supplied)
   *   code 404 :  (Pet not found)
   * 
   * Available security schemes:
   *   api_key (apiKey)
   * 
   * @param petId ID of pet to return
   */
  def getPetById(petId: Long)(using Auth <:< org.openapitools.client.core.Authorization.ApiKey): sttp.client4.Request[Either[ResponseException[String], Pet]] =
    val petIdPathParam = PathSerializable.serialize("petId", petId, PathStyleFormat.SIMPLE, false)
    val requestURL =
      uri"$baseUrl/pet/${petIdPathParam}"

    basicRequest
      .method(Method.GET, requestURL)
      .contentType("application/json")
      .auth(authConfig, org.openapitools.client.core.ApiKeyLocation.HEADER, "api_key")
      .response(asJson[Pet])

  /**
   * 
   * 
   * Expected answers:
   *   code 200 : Pet (successful operation)
   *   code 400 :  (Invalid ID supplied)
   *   code 404 :  (Pet not found)
   *   code 405 :  (Validation exception)
   * 
   * @param pet Pet object that needs to be added to the store
   */
  def updatePet(pet: Pet): sttp.client4.Request[Either[ResponseException[String], Pet]] =
    val requestURL =
      uri"$baseUrl/pet"

    basicRequest
      .method(Method.PUT, requestURL)
      .contentType("application/json")
      .body(asJson(pet))
      .response(asJson[Pet])

  /**
   * 
   * 
   * Expected answers:
   *   code 405 :  (Invalid input)
   * 
   * @param petId ID of pet that needs to be updated
   * @param name Updated name of the pet
   * @param status Updated status of the pet
   */
  def updatePetWithForm(petId: Long, name: Option[String] = scala.None, status: Option[String] = scala.None): sttp.client4.Request[Either[ResponseException[String], Unit]] =
    val petIdPathParam = PathSerializable.serialize("petId", petId, PathStyleFormat.SIMPLE, false)
    val requestURL =
      uri"$baseUrl/pet/${petIdPathParam}"

    basicRequest
      .method(Method.POST, requestURL)
      .contentType("application/x-www-form-urlencoded")
      .body(
        FormSerializable.serialize("name", name, FormStyleFormat.FORM, false) ++ 
        FormSerializable.serialize("status", status, FormStyleFormat.FORM, false),
        "utf-8"
      )
      .response(asString.mapWithMetadata(ResponseAs.deserializeRightWithError(_ => Right(()))))

  /**
   * 
   * 
   * Expected answers:
   *   code 200 : ApiResponse (successful operation)
   * 
   * @param petId ID of pet to update
   * @param additionalMetadata Additional data to pass to server
   * @param file file to upload
   */
  def uploadFile(petId: Long, additionalMetadata: Option[String] = scala.None, file: Option[File] = scala.None): sttp.client4.Request[Either[ResponseException[String], ApiResponse]] =
    val petIdPathParam = PathSerializable.serialize("petId", petId, PathStyleFormat.SIMPLE, false)
    val requestURL =
      uri"$baseUrl/pet/${petIdPathParam}/uploadImage"

    basicRequest
      .method(Method.POST, requestURL)
      .contentType("multipart/form-data")
      .multipartBody(Seq(
            
        additionalMetadata.map(value => multipart("additionalMetadata", value.toString))
,

                file.map(multipartFile("file", _))
    

      ).flatten)
      .response(asJson[ApiResponse])

end PetApi