/*
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (7.20.0-SNAPSHOT).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.openapitools.api;

import java.time.OffsetDateTime;
import org.openapitools.model.User;
import io.swagger.annotations.*;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.20.0-SNAPSHOT")
@Validated
@Api(value = "user tag", description = "the user tag API")
public interface UserController {

    String PATH_CREATE_USER = "/user";
    /**
     * POST /user : Create user
     * This can only be done by the logged in user.
     *
     * @param body Created user object (required)
     * @return successful operation (status code 200)
     */
    @ApiOperation(
        tags = { "user tag" },
        value = "Create user",
        nickname = "createUser",
        notes = "This can only be done by the logged in user."
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "successful operation")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = UserController.PATH_CREATE_USER
    )
    ResponseEntity<Void> createUser(
        @ApiParam(value = "Created user object", required = true) @Valid @RequestBody User body
    );


    String PATH_CREATE_USERS_WITH_ARRAY_INPUT = "/user/createWithArray";
    /**
     * POST /user/createWithArray : Creates list of users with given input array
     *
     * @param body List of user object (required)
     * @return successful operation (status code 200)
     */
    @ApiOperation(
        tags = { "user tag" },
        value = "Creates list of users with given input array",
        nickname = "createUsersWithArrayInput",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "successful operation")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = UserController.PATH_CREATE_USERS_WITH_ARRAY_INPUT
    )
    ResponseEntity<Void> createUsersWithArrayInput(
        @ApiParam(value = "List of user object", required = true) @Valid @RequestBody List<@Valid User> body
    );


    String PATH_CREATE_USERS_WITH_LIST_INPUT = "/user/createWithList";
    /**
     * POST /user/createWithList : Creates list of users with given input array
     *
     * @param body List of user object (required)
     * @return successful operation (status code 200)
     */
    @ApiOperation(
        tags = { "user tag" },
        value = "Creates list of users with given input array",
        nickname = "createUsersWithListInput",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "successful operation")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = UserController.PATH_CREATE_USERS_WITH_LIST_INPUT
    )
    ResponseEntity<Void> createUsersWithListInput(
        @ApiParam(value = "List of user object", required = true) @Valid @RequestBody List<@Valid User> body
    );


    String PATH_DELETE_USER = "/user/{username}";
    /**
     * DELETE /user/{username} : Delete user
     * This can only be done by the logged in user.
     *
     * @param username The name that needs to be deleted (required)
     * @return Invalid username supplied (status code 400)
     *         or User not found (status code 404)
     */
    @ApiOperation(
        tags = { "user tag" },
        value = "Delete user",
        nickname = "deleteUser",
        notes = "This can only be done by the logged in user."
    )
    @ApiResponses({
        @ApiResponse(code = 400, message = "Invalid username supplied"),
        @ApiResponse(code = 404, message = "User not found")
    })
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = UserController.PATH_DELETE_USER
    )
    ResponseEntity<Void> deleteUser(
        @NotNull @ApiParam(value = "The name that needs to be deleted", required = true) @PathVariable("username") String username
    );


    String PATH_GET_USER_BY_NAME = "/user/{username}";
    /**
     * GET /user/{username} : Get user by user name
     *
     * @param username The name that needs to be fetched. Use user1 for testing. (required)
     * @return successful operation (status code 200)
     *         or Invalid username supplied (status code 400)
     *         or User not found (status code 404)
     */
    @ApiOperation(
        tags = { "user tag" },
        value = "Get user by user name",
        nickname = "getUserByName",
        notes = "",
        response = User.class
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "successful operation", response = User.class),
        @ApiResponse(code = 400, message = "Invalid username supplied"),
        @ApiResponse(code = 404, message = "User not found")
    })
    @RequestMapping(
        method = RequestMethod.GET,
        value = UserController.PATH_GET_USER_BY_NAME,
        produces = { "application/json", "application/xml" }
    )
    ResponseEntity<User> getUserByName(
        @NotNull @ApiParam(value = "The name that needs to be fetched. Use user1 for testing.", required = true) @PathVariable("username") String username
    );


    String PATH_LOGIN_USER = "/user/login";
    /**
     * GET /user/login : Logs user into the system
     *
     * @param username The user name for login (required)
     * @param password The password for login in clear text (required)
     * @return successful operation (status code 200)
     *         or Invalid username/password supplied (status code 400)
     */
    @ApiOperation(
        tags = { "user tag" },
        value = "Logs user into the system",
        nickname = "loginUser",
        notes = "",
        response = String.class
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "successful operation", response = String.class),
        @ApiResponse(code = 400, message = "Invalid username/password supplied")
    })
    @RequestMapping(
        method = RequestMethod.GET,
        value = UserController.PATH_LOGIN_USER,
        produces = { "application/json", "application/xml" }
    )
    ResponseEntity<String> loginUser(
        @NotNull @ApiParam(value = "The user name for login", required = true) @Valid @RequestParam(value = "username", required = true) String username,
        @NotNull @ApiParam(value = "The password for login in clear text", required = true) @Valid @RequestParam(value = "password", required = true) String password
    );


    String PATH_LOGOUT_USER = "/user/logout";
    /**
     * GET /user/logout : Logs out current logged in user session
     *
     * @return successful operation (status code 200)
     */
    @ApiOperation(
        tags = { "user tag" },
        value = "Logs out current logged in user session",
        nickname = "logoutUser",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "successful operation")
    })
    @RequestMapping(
        method = RequestMethod.GET,
        value = UserController.PATH_LOGOUT_USER
    )
    ResponseEntity<Void> logoutUser(
        
    );


    String PATH_LOGOUT_USER_OPTIONS = "/user/logout";
    /**
     * OPTIONS /user/logout : logoutUserOptions
     *
     * @return endpoint configuration response (status code 200)
     */
    @ApiOperation(
        tags = { "user tag" },
        value = "logoutUserOptions",
        nickname = "logoutUserOptions",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "endpoint configuration response")
    })
    @RequestMapping(
        method = RequestMethod.OPTIONS,
        value = UserController.PATH_LOGOUT_USER_OPTIONS
    )
    ResponseEntity<Void> logoutUserOptions(
        
    );


    String PATH_UPDATE_USER = "/user/{username}";
    /**
     * PUT /user/{username} : Updated user
     * This can only be done by the logged in user.
     *
     * @param username name that need to be deleted (required)
     * @param body Updated user object (required)
     * @return Invalid user supplied (status code 400)
     *         or User not found (status code 404)
     */
    @ApiOperation(
        tags = { "user tag" },
        value = "Updated user",
        nickname = "updateUser",
        notes = "This can only be done by the logged in user."
    )
    @ApiResponses({
        @ApiResponse(code = 400, message = "Invalid user supplied"),
        @ApiResponse(code = 404, message = "User not found")
    })
    @RequestMapping(
        method = RequestMethod.PUT,
        value = UserController.PATH_UPDATE_USER
    )
    ResponseEntity<Void> updateUser(
        @NotNull @ApiParam(value = "name that need to be deleted", required = true) @PathVariable("username") String username,
        @ApiParam(value = "Updated user object", required = true) @Valid @RequestBody User body
    );

}
