//
// JSONValue.swift
//
// Generated by openapi-generator
// https://openapi-generator.tech
//

import Foundation

internal enum JSONValue: Sendable, Codable, Hashable {
    case string(String)
    case int(Int)
    case double(Double)
    case bool(Bool)
    case array([JSONValue])
    case dictionary([String: JSONValue])
    case null
    
    // MARK: - Decoding Logic
    internal init(from decoder: Decoder) throws {
        let container = try decoder.singleValueContainer()

        if let stringValue = try? container.decode(String.self) {
            self = .string(stringValue)
        } else if let intValue = try? container.decode(Int.self) {
            self = .int(intValue)
        } else if let doubleValue = try? container.decode(Double.self) {
            self = .double(doubleValue)
        } else if let boolValue = try? container.decode(Bool.self) {
            self = .bool(boolValue)
        } else if let arrayValue = try? container.decode([JSONValue].self) {
            self = .array(arrayValue)
        } else if let dictionaryValue = try? container.decode([String: JSONValue].self) {
            self = .dictionary(dictionaryValue)
        } else if container.decodeNil() {
            self = .null
        } else {
            throw DecodingError.dataCorruptedError(in: container, debugDescription: "Unknown JSON value")
        }
    }

    // MARK: - Encoding Logic
    internal func encode(to encoder: Encoder) throws {
        var container = encoder.singleValueContainer()
        
        switch self {
        case .string(let value):
            try container.encode(value)
        case .int(let value):
            try container.encode(value)
        case .double(let value):
            try container.encode(value)
        case .bool(let value):
            try container.encode(value)
        case .array(let value):
            try container.encode(value)
        case .dictionary(let value):
            try container.encode(value)
        case .null:
            try container.encodeNil()
        }
    }
}

extension JSONValue {
    internal init(_ value: String) {
        self = .string(value)
    }
    
    internal init(_ value: Int) {
        self = .int(value)
    }
    
    internal init(_ value: Double) {
        self = .double(value)
    }
    
    internal init(_ value: Bool) {
        self = .bool(value)
    }
    
    internal init(_ value: [JSONValue]) {
        self = .array(value)
    }
    
    internal init(_ value: [String: JSONValue]) {
        self = .dictionary(value)
    }
    
    internal init<T: Codable>(_ codable: T) throws {
        let encoder = JSONEncoder()
        let encodedData = try encoder.encode(codable)
        let decoder = JSONDecoder()
        
        let decodedValue = try decoder.decode(JSONValue.self, from: encodedData)
        self = decodedValue
    }
}

extension JSONValue {
    internal var isString: Bool {
        if case .string = self { return true }
        return false
    }

    internal var isInt: Bool {
        if case .int = self { return true }
        return false
    }

    internal var isDouble: Bool {
        if case .double = self { return true }
        return false
    }

    internal var isBool: Bool {
        if case .bool = self { return true }
        return false
    }

    internal var isArray: Bool {
        if case .array = self { return true }
        return false
    }

    internal var isDictionary: Bool {
        if case .dictionary = self { return true }
        return false
    }

    internal var isNull: Bool {
        return self == .null
    }

}

extension JSONValue {
    internal var stringValue: String? {
        switch self {
        case .string(let value):
            return value
        default:
            return nil
        }
    }

    internal var intValue: Int? {
        switch self {
        case .int(let value):
            return value
        default:
            return nil
        }
    }

    internal var doubleValue: Double? {
        switch self {
        case .double(let value):
            return value
        default:
            return nil
        }
    }

    internal var boolValue: Bool? {
        switch self {
        case .bool(let value):
            return value
        default:
            return nil
        }
    }

    internal var arrayValue: [JSONValue]? {
        if case let .array(value) = self {
            return value
        }
        return nil
    }

    internal var dictionaryValue: [String: JSONValue]? {
        if case let .dictionary(value) = self {
            return value
        }
        return nil
    }
}

extension JSONValue {
    internal subscript(key: String) -> JSONValue? {
        return dictionaryValue?[key]
    }

    internal subscript(index: Int) -> JSONValue? {
        guard case let .array(array) = self, index >= 0 && index < array.count else {
            return nil
        }
        return array[index]
    }
}

extension JSONValue: ExpressibleByStringLiteral, ExpressibleByStringInterpolation {
    internal init(stringLiteral value: StringLiteralType) {
        self = .string(value)
    }
}

extension JSONValue: ExpressibleByIntegerLiteral {
    internal init(integerLiteral value: IntegerLiteralType) {
        self = .int(value)
    }
}

extension JSONValue: ExpressibleByFloatLiteral {
    internal init(floatLiteral value: FloatLiteralType) {
        self = .double(value)
    }
}


extension JSONValue: ExpressibleByBooleanLiteral {
    internal init(booleanLiteral value: BooleanLiteralType) {
        self = .bool(value)
    }
}

extension JSONValue: ExpressibleByArrayLiteral {
    internal init(arrayLiteral elements: JSONValue...) {
        self = .array(elements)
    }
}

extension JSONValue: ExpressibleByDictionaryLiteral {
    internal init(dictionaryLiteral elements: (String, JSONValue)...) {
        var dict: [String: JSONValue] = [:]
        for (key, value) in elements {
            dict[key] = value
        }
        self = .dictionary(dict)
    }
}

extension JSONValue: ExpressibleByNilLiteral {
    internal init(nilLiteral: ()) {
        self = .null
    }
}
