//
// FakeAPI.swift
//
// Generated by openapi-generator
// https://openapi-generator.tech
//

import Foundation
import Vapor

open class FakeAPI {

    /**
     creates an XmlItem
     POST /fake/create_xml_item
     this route creates an XmlItem
     - parameter xmlItem: (body) XmlItem Body 
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func createXmlItemRaw(xmlItem: XmlItem, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake/create_xml_item"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.POST, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            
            try localVariableRequest.content.encode(xmlItem, using: apiConfiguration.contentConfiguration.requireEncoder(for: XmlItem.defaultContentType))
            
            try beforeSend(&localVariableRequest)
        }
    }

    public enum CreateXmlItem {
        case http200(raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     creates an XmlItem
     POST /fake/create_xml_item
     this route creates an XmlItem
     - parameter xmlItem: (body) XmlItem Body 
     - returns: `EventLoopFuture` of `CreateXmlItem` 
     */
    open class func createXmlItem(xmlItem: XmlItem, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<CreateXmlItem> {
        return createXmlItemRaw(xmlItem: xmlItem, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> CreateXmlItem in
            switch response.status.code {
            case 200:
                return .http200(raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     POST /fake/outer/boolean
     Test serialization of outer boolean types
     - parameter body: (body) Input boolean as post body (optional)
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func fakeOuterBooleanSerializeRaw(body: Bool? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake/outer/boolean"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.POST, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            
            if let localVariableBody = body {
                try localVariableRequest.content.encode(localVariableBody, using: apiConfiguration.contentConfiguration.requireEncoder(for: Bool.defaultContentType))
            }
            
            try beforeSend(&localVariableRequest)
        }
    }

    public enum FakeOuterBooleanSerialize {
        case http200(value: Bool, raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     POST /fake/outer/boolean
     Test serialization of outer boolean types
     - parameter body: (body) Input boolean as post body (optional)
     - returns: `EventLoopFuture` of `FakeOuterBooleanSerialize` 
     */
    open class func fakeOuterBooleanSerialize(body: Bool? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<FakeOuterBooleanSerialize> {
        return fakeOuterBooleanSerializeRaw(body: body, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> FakeOuterBooleanSerialize in
            switch response.status.code {
            case 200:
                return .http200(value: try response.content.decode(Bool.self, using: apiConfiguration.contentConfiguration.requireDecoder(for: Bool.defaultContentType)), raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     POST /fake/outer/composite
     Test serialization of object with outer number type
     - parameter body: (body) Input composite as post body (optional)
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func fakeOuterCompositeSerializeRaw(body: OuterComposite? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake/outer/composite"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.POST, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            
            if let localVariableBody = body {
                try localVariableRequest.content.encode(localVariableBody, using: apiConfiguration.contentConfiguration.requireEncoder(for: OuterComposite.defaultContentType))
            }
            
            try beforeSend(&localVariableRequest)
        }
    }

    public enum FakeOuterCompositeSerialize {
        case http200(value: OuterComposite, raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     POST /fake/outer/composite
     Test serialization of object with outer number type
     - parameter body: (body) Input composite as post body (optional)
     - returns: `EventLoopFuture` of `FakeOuterCompositeSerialize` 
     */
    open class func fakeOuterCompositeSerialize(body: OuterComposite? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<FakeOuterCompositeSerialize> {
        return fakeOuterCompositeSerializeRaw(body: body, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> FakeOuterCompositeSerialize in
            switch response.status.code {
            case 200:
                return .http200(value: try response.content.decode(OuterComposite.self, using: apiConfiguration.contentConfiguration.requireDecoder(for: OuterComposite.defaultContentType)), raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     POST /fake/outer/number
     Test serialization of outer number types
     - parameter body: (body) Input number as post body (optional)
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func fakeOuterNumberSerializeRaw(body: Double? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake/outer/number"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.POST, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            
            if let localVariableBody = body {
                try localVariableRequest.content.encode(localVariableBody, using: apiConfiguration.contentConfiguration.requireEncoder(for: Double.defaultContentType))
            }
            
            try beforeSend(&localVariableRequest)
        }
    }

    public enum FakeOuterNumberSerialize {
        case http200(value: Double, raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     POST /fake/outer/number
     Test serialization of outer number types
     - parameter body: (body) Input number as post body (optional)
     - returns: `EventLoopFuture` of `FakeOuterNumberSerialize` 
     */
    open class func fakeOuterNumberSerialize(body: Double? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<FakeOuterNumberSerialize> {
        return fakeOuterNumberSerializeRaw(body: body, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> FakeOuterNumberSerialize in
            switch response.status.code {
            case 200:
                return .http200(value: try response.content.decode(Double.self, using: apiConfiguration.contentConfiguration.requireDecoder(for: Double.defaultContentType)), raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     POST /fake/outer/string
     Test serialization of outer string types
     - parameter body: (body) Input string as post body (optional)
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func fakeOuterStringSerializeRaw(body: String? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake/outer/string"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.POST, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            
            if let localVariableBody = body {
                try localVariableRequest.content.encode(localVariableBody, using: apiConfiguration.contentConfiguration.requireEncoder(for: String.defaultContentType))
            }
            
            try beforeSend(&localVariableRequest)
        }
    }

    public enum FakeOuterStringSerialize {
        case http200(value: String, raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     POST /fake/outer/string
     Test serialization of outer string types
     - parameter body: (body) Input string as post body (optional)
     - returns: `EventLoopFuture` of `FakeOuterStringSerialize` 
     */
    open class func fakeOuterStringSerialize(body: String? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<FakeOuterStringSerialize> {
        return fakeOuterStringSerializeRaw(body: body, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> FakeOuterStringSerialize in
            switch response.status.code {
            case 200:
                return .http200(value: try response.content.decode(String.self, using: apiConfiguration.contentConfiguration.requireDecoder(for: String.defaultContentType)), raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     PUT /fake/body-with-file-schema
     For this test, the body for this request much reference a schema named `File`.
     - parameter body: (body)  
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func testBodyWithFileSchemaRaw(body: FileSchemaTestClass, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake/body-with-file-schema"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.PUT, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            
            try localVariableRequest.content.encode(body, using: apiConfiguration.contentConfiguration.requireEncoder(for: FileSchemaTestClass.defaultContentType))
            
            try beforeSend(&localVariableRequest)
        }
    }

    public enum TestBodyWithFileSchema {
        case http200(raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     PUT /fake/body-with-file-schema
     For this test, the body for this request much reference a schema named `File`.
     - parameter body: (body)  
     - returns: `EventLoopFuture` of `TestBodyWithFileSchema` 
     */
    open class func testBodyWithFileSchema(body: FileSchemaTestClass, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<TestBodyWithFileSchema> {
        return testBodyWithFileSchemaRaw(body: body, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> TestBodyWithFileSchema in
            switch response.status.code {
            case 200:
                return .http200(raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     PUT /fake/body-with-query-params
     - parameter query: (query)  
     - parameter body: (body)  
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func testBodyWithQueryParamsRaw(query: String, body: User, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake/body-with-query-params"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.PUT, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            struct QueryParams: Content {
                var query: String

                enum CodingKeys: String, CodingKey {
                    case query = "query"
                }
            }
            try localVariableRequest.query.encode(QueryParams(query: query))
            try localVariableRequest.content.encode(body, using: apiConfiguration.contentConfiguration.requireEncoder(for: User.defaultContentType))
            
            try beforeSend(&localVariableRequest)
        }
    }

    public enum TestBodyWithQueryParams {
        case http200(raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     PUT /fake/body-with-query-params
     - parameter query: (query)  
     - parameter body: (body)  
     - returns: `EventLoopFuture` of `TestBodyWithQueryParams` 
     */
    open class func testBodyWithQueryParams(query: String, body: User, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<TestBodyWithQueryParams> {
        return testBodyWithQueryParamsRaw(query: query, body: body, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> TestBodyWithQueryParams in
            switch response.status.code {
            case 200:
                return .http200(raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     To test \"client\" model
     PATCH /fake
     To test \"client\" model
     - parameter body: (body) client model 
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func testClientModelRaw(body: Client, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.PATCH, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            
            try localVariableRequest.content.encode(body, using: apiConfiguration.contentConfiguration.requireEncoder(for: Client.defaultContentType))
            
            try beforeSend(&localVariableRequest)
        }
    }

    public enum TestClientModel {
        case http200(value: Client, raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     To test \"client\" model
     PATCH /fake
     To test \"client\" model
     - parameter body: (body) client model 
     - returns: `EventLoopFuture` of `TestClientModel` 
     */
    open class func testClientModel(body: Client, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<TestClientModel> {
        return testClientModelRaw(body: body, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> TestClientModel in
            switch response.status.code {
            case 200:
                return .http200(value: try response.content.decode(Client.self, using: apiConfiguration.contentConfiguration.requireDecoder(for: Client.defaultContentType)), raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
     POST /fake
     Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
     - BASIC:
       - type: http
       - name: http_basic_test
     - parameter number: (form) None 
     - parameter double: (form) None 
     - parameter patternWithoutDelimiter: (form) None 
     - parameter byte: (form) None 
     - parameter integer: (form) None (optional)
     - parameter int32: (form) None (optional)
     - parameter int64: (form) None (optional)
     - parameter float: (form) None (optional)
     - parameter string: (form) None (optional)
     - parameter binary: (form) None (optional)
     - parameter date: (form) None (optional)
     - parameter dateTime: (form) None (optional)
     - parameter password: (form) None (optional)
     - parameter callback: (form) None (optional)
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func testEndpointParametersRaw(number: Double, double: Double, patternWithoutDelimiter: String, byte: Data, integer: Int? = nil, int32: Int? = nil, int64: Int64? = nil, float: Float? = nil, string: String? = nil, binary: Data? = nil, date: Date? = nil, dateTime: Date? = nil, password: String? = nil, callback: String? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.POST, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            
            struct FormParams: Content {
                static let defaultContentType = Vapor.HTTPMediaType.formData
                var integer: Int?
                var int32: Int?
                var int64: Int64?
                var number: Double
                var float: Float?
                var double: Double
                var string: String?
                var patternWithoutDelimiter: String
                var byte: Data
                var binary: Data?
                var date: Date?
                var dateTime: Date?
                var password: String?
                var callback: String?
            }
            try localVariableRequest.content.encode(FormParams(integer: integer, int32: int32, int64: int64, number: number, float: float, double: double, string: string, patternWithoutDelimiter: patternWithoutDelimiter, byte: byte, binary: binary, date: date, dateTime: dateTime, password: password, callback: callback), using: apiConfiguration.contentConfiguration.requireEncoder(for: FormParams.defaultContentType))
            try beforeSend(&localVariableRequest)
        }
    }

    public enum TestEndpointParameters {
        case http400(raw: ClientResponse)
        case http404(raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
     POST /fake
     Fake endpoint for testing various parameters  假端點  偽のエンドポイント  가짜 엔드 포인트
     - BASIC:
       - type: http
       - name: http_basic_test
     - parameter number: (form) None 
     - parameter double: (form) None 
     - parameter patternWithoutDelimiter: (form) None 
     - parameter byte: (form) None 
     - parameter integer: (form) None (optional)
     - parameter int32: (form) None (optional)
     - parameter int64: (form) None (optional)
     - parameter float: (form) None (optional)
     - parameter string: (form) None (optional)
     - parameter binary: (form) None (optional)
     - parameter date: (form) None (optional)
     - parameter dateTime: (form) None (optional)
     - parameter password: (form) None (optional)
     - parameter callback: (form) None (optional)
     - returns: `EventLoopFuture` of `TestEndpointParameters` 
     */
    open class func testEndpointParameters(number: Double, double: Double, patternWithoutDelimiter: String, byte: Data, integer: Int? = nil, int32: Int? = nil, int64: Int64? = nil, float: Float? = nil, string: String? = nil, binary: Data? = nil, date: Date? = nil, dateTime: Date? = nil, password: String? = nil, callback: String? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<TestEndpointParameters> {
        return testEndpointParametersRaw(number: number, double: double, patternWithoutDelimiter: patternWithoutDelimiter, byte: byte, integer: integer, int32: int32, int64: int64, float: float, string: string, binary: binary, date: date, dateTime: dateTime, password: password, callback: callback, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> TestEndpointParameters in
            switch response.status.code {
            case 400:
                return .http400(raw: response)
            case 404:
                return .http404(raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     * enum for parameter enumHeaderStringArray
     */
    public enum EnumHeaderStringArray_testEnumParameters: String, Sendable, CaseIterable, Content {
        case greaterThan = ">"
        case dollar = "$"
    }

    /**
     * enum for parameter enumHeaderString
     */
    public enum EnumHeaderString_testEnumParameters: String, Sendable, CaseIterable, Content {
        case abc = "_abc"
        case efg = "-efg"
        case xyz = "(xyz)"
    }

    /**
     * enum for parameter enumQueryStringArray
     */
    public enum EnumQueryStringArray_testEnumParameters: String, Sendable, CaseIterable, Content {
        case greaterThan = ">"
        case dollar = "$"
    }

    /**
     * enum for parameter enumQueryString
     */
    public enum EnumQueryString_testEnumParameters: String, Sendable, CaseIterable, Content {
        case abc = "_abc"
        case efg = "-efg"
        case xyz = "(xyz)"
    }

    /**
     * enum for parameter enumQueryInteger
     */
    public enum EnumQueryInteger_testEnumParameters: Int, Sendable, CaseIterable, Content {
        case _1 = 1
        case number2 = -2
    }

    /**
     * enum for parameter enumQueryDouble
     */
    public enum EnumQueryDouble_testEnumParameters: Double, Sendable, CaseIterable, Content {
        case _11 = 1.1
        case number12 = -1.2
    }

    /**
     * enum for parameter enumFormStringArray
     */
    public enum EnumFormStringArray_testEnumParameters: String, Sendable, CaseIterable, Content {
        case greaterThan = ">"
        case dollar = "$"
    }

    /**
     * enum for parameter enumFormString
     */
    public enum EnumFormString_testEnumParameters: String, Sendable, CaseIterable, Content {
        case abc = "_abc"
        case efg = "-efg"
        case xyz = "(xyz)"
    }

    /**
     To test enum parameters
     GET /fake
     To test enum parameters
     - parameter enumHeaderStringArray: (header) Header parameter enum test (string array) (optional)
     - parameter enumHeaderString: (header) Header parameter enum test (string) (optional, default to .efg)
     - parameter enumQueryStringArray: (query) Query parameter enum test (string array) (optional)
     - parameter enumQueryString: (query) Query parameter enum test (string) (optional, default to .efg)
     - parameter enumQueryInteger: (query) Query parameter enum test (double) (optional)
     - parameter enumQueryDouble: (query) Query parameter enum test (double) (optional)
     - parameter enumFormStringArray: (form) Form parameter enum test (string array) (optional, default to .dollar)
     - parameter enumFormString: (form) Form parameter enum test (string) (optional, default to .efg)
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func testEnumParametersRaw(enumHeaderStringArray: [EnumHeaderStringArray_testEnumParameters]? = nil, enumHeaderString: EnumHeaderString_testEnumParameters? = nil, enumQueryStringArray: [EnumQueryStringArray_testEnumParameters]? = nil, enumQueryString: EnumQueryString_testEnumParameters? = nil, enumQueryInteger: EnumQueryInteger_testEnumParameters? = nil, enumQueryDouble: EnumQueryDouble_testEnumParameters? = nil, enumFormStringArray: [EnumFormStringArray_testEnumParameters]? = nil, enumFormString: EnumFormString_testEnumParameters? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.GET, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            localVariableRequest.headers.add(name: "enum_header_string_array", value: enumHeaderStringArray?.map { $0.rawValue.description }.description ?? "")
            
            localVariableRequest.headers.add(name: "enum_header_string", value: enumHeaderString?.rawValue.description ?? "")
            
            struct QueryParams: Content {
                var enumQueryStringArray: [EnumQueryStringArray_testEnumParameters]?
                var enumQueryString: EnumQueryString_testEnumParameters?
                var enumQueryInteger: EnumQueryInteger_testEnumParameters?
                var enumQueryDouble: EnumQueryDouble_testEnumParameters?

                enum CodingKeys: String, CodingKey {
                    case enumQueryStringArray = "enum_query_string_array"
                    case enumQueryString = "enum_query_string"
                    case enumQueryInteger = "enum_query_integer"
                    case enumQueryDouble = "enum_query_double"
                }
            }
            try localVariableRequest.query.encode(QueryParams(enumQueryStringArray: enumQueryStringArray, enumQueryString: enumQueryString, enumQueryInteger: enumQueryInteger, enumQueryDouble: enumQueryDouble))
            struct FormParams: Content {
                static let defaultContentType = Vapor.HTTPMediaType.formData
                var enumFormStringArray: [EnumFormStringArray_testEnumParameters]?
                var enumFormString: EnumFormString_testEnumParameters?
            }
            try localVariableRequest.content.encode(FormParams(enumFormStringArray: enumFormStringArray, enumFormString: enumFormString), using: apiConfiguration.contentConfiguration.requireEncoder(for: FormParams.defaultContentType))
            try beforeSend(&localVariableRequest)
        }
    }

    public enum TestEnumParameters {
        case http400(raw: ClientResponse)
        case http404(raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     To test enum parameters
     GET /fake
     To test enum parameters
     - parameter enumHeaderStringArray: (header) Header parameter enum test (string array) (optional)
     - parameter enumHeaderString: (header) Header parameter enum test (string) (optional, default to .efg)
     - parameter enumQueryStringArray: (query) Query parameter enum test (string array) (optional)
     - parameter enumQueryString: (query) Query parameter enum test (string) (optional, default to .efg)
     - parameter enumQueryInteger: (query) Query parameter enum test (double) (optional)
     - parameter enumQueryDouble: (query) Query parameter enum test (double) (optional)
     - parameter enumFormStringArray: (form) Form parameter enum test (string array) (optional, default to .dollar)
     - parameter enumFormString: (form) Form parameter enum test (string) (optional, default to .efg)
     - returns: `EventLoopFuture` of `TestEnumParameters` 
     */
    open class func testEnumParameters(enumHeaderStringArray: [EnumHeaderStringArray_testEnumParameters]? = nil, enumHeaderString: EnumHeaderString_testEnumParameters? = nil, enumQueryStringArray: [EnumQueryStringArray_testEnumParameters]? = nil, enumQueryString: EnumQueryString_testEnumParameters? = nil, enumQueryInteger: EnumQueryInteger_testEnumParameters? = nil, enumQueryDouble: EnumQueryDouble_testEnumParameters? = nil, enumFormStringArray: [EnumFormStringArray_testEnumParameters]? = nil, enumFormString: EnumFormString_testEnumParameters? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<TestEnumParameters> {
        return testEnumParametersRaw(enumHeaderStringArray: enumHeaderStringArray, enumHeaderString: enumHeaderString, enumQueryStringArray: enumQueryStringArray, enumQueryString: enumQueryString, enumQueryInteger: enumQueryInteger, enumQueryDouble: enumQueryDouble, enumFormStringArray: enumFormStringArray, enumFormString: enumFormString, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> TestEnumParameters in
            switch response.status.code {
            case 400:
                return .http400(raw: response)
            case 404:
                return .http404(raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     Fake endpoint to test group parameters (optional)
     DELETE /fake
     Fake endpoint to test group parameters (optional)
     - parameter requiredStringGroup: (query) Required String in group parameters 
     - parameter requiredBooleanGroup: (header) Required Boolean in group parameters 
     - parameter requiredInt64Group: (query) Required Integer in group parameters 
     - parameter stringGroup: (query) String in group parameters (optional)
     - parameter booleanGroup: (header) Boolean in group parameters (optional)
     - parameter int64Group: (query) Integer in group parameters (optional)
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func testGroupParametersRaw(requiredStringGroup: Int, requiredBooleanGroup: Bool, requiredInt64Group: Int64, stringGroup: Int? = nil, booleanGroup: Bool? = nil, int64Group: Int64? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.DELETE, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            localVariableRequest.headers.add(name: "required_boolean_group", value: requiredBooleanGroup.description)
            
            localVariableRequest.headers.add(name: "boolean_group", value: booleanGroup?.description ?? "")
            
            struct QueryParams: Content {
                var requiredStringGroup: Int
                var requiredInt64Group: Int64
                var stringGroup: Int?
                var int64Group: Int64?

                enum CodingKeys: String, CodingKey {
                    case requiredStringGroup = "required_string_group"
                    case requiredInt64Group = "required_int64_group"
                    case stringGroup = "string_group"
                    case int64Group = "int64_group"
                }
            }
            try localVariableRequest.query.encode(QueryParams(requiredStringGroup: requiredStringGroup, requiredInt64Group: requiredInt64Group, stringGroup: stringGroup, int64Group: int64Group))
            
            try beforeSend(&localVariableRequest)
        }
    }

    public enum TestGroupParameters {
        case http400(raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     Fake endpoint to test group parameters (optional)
     DELETE /fake
     Fake endpoint to test group parameters (optional)
     - parameter requiredStringGroup: (query) Required String in group parameters 
     - parameter requiredBooleanGroup: (header) Required Boolean in group parameters 
     - parameter requiredInt64Group: (query) Required Integer in group parameters 
     - parameter stringGroup: (query) String in group parameters (optional)
     - parameter booleanGroup: (header) Boolean in group parameters (optional)
     - parameter int64Group: (query) Integer in group parameters (optional)
     - returns: `EventLoopFuture` of `TestGroupParameters` 
     */
    open class func testGroupParameters(requiredStringGroup: Int, requiredBooleanGroup: Bool, requiredInt64Group: Int64, stringGroup: Int? = nil, booleanGroup: Bool? = nil, int64Group: Int64? = nil, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<TestGroupParameters> {
        return testGroupParametersRaw(requiredStringGroup: requiredStringGroup, requiredBooleanGroup: requiredBooleanGroup, requiredInt64Group: requiredInt64Group, stringGroup: stringGroup, booleanGroup: booleanGroup, int64Group: int64Group, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> TestGroupParameters in
            switch response.status.code {
            case 400:
                return .http400(raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     test inline additionalProperties
     POST /fake/inline-additionalProperties
     - parameter param: (body) request body 
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func testInlineAdditionalPropertiesRaw(param: [String: String], headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake/inline-additionalProperties"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.POST, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            
            try localVariableRequest.content.encode(param, using: apiConfiguration.contentConfiguration.requireEncoder(for: [String: String].defaultContentType))
            
            try beforeSend(&localVariableRequest)
        }
    }

    public enum TestInlineAdditionalProperties {
        case http200(raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     test inline additionalProperties
     POST /fake/inline-additionalProperties
     - parameter param: (body) request body 
     - returns: `EventLoopFuture` of `TestInlineAdditionalProperties` 
     */
    open class func testInlineAdditionalProperties(param: [String: String], headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<TestInlineAdditionalProperties> {
        return testInlineAdditionalPropertiesRaw(param: param, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> TestInlineAdditionalProperties in
            switch response.status.code {
            case 200:
                return .http200(raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     test json serialization of form data
     GET /fake/jsonFormData
     - parameter param: (form) field1 
     - parameter param2: (form) field2 
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func testJsonFormDataRaw(param: String, param2: String, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake/jsonFormData"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.GET, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            
            struct FormParams: Content {
                static let defaultContentType = Vapor.HTTPMediaType.formData
                var param: String
                var param2: String
            }
            try localVariableRequest.content.encode(FormParams(param: param, param2: param2), using: apiConfiguration.contentConfiguration.requireEncoder(for: FormParams.defaultContentType))
            try beforeSend(&localVariableRequest)
        }
    }

    public enum TestJsonFormData {
        case http200(raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     test json serialization of form data
     GET /fake/jsonFormData
     - parameter param: (form) field1 
     - parameter param2: (form) field2 
     - returns: `EventLoopFuture` of `TestJsonFormData` 
     */
    open class func testJsonFormData(param: String, param2: String, headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<TestJsonFormData> {
        return testJsonFormDataRaw(param: param, param2: param2, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> TestJsonFormData in
            switch response.status.code {
            case 200:
                return .http200(raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }

    /**
     PUT /fake/test-query-parameters
     To test the collection format in query parameters
     - parameter pipe: (query)  
     - parameter ioutil: (query)  
     - parameter http: (query)  
     - parameter url: (query)  
     - parameter context: (query)  
     - returns: `EventLoopFuture` of `ClientResponse` 
     */
    open class func testQueryParameterCollectionFormatRaw(pipe: [String], ioutil: [String], http: [String], url: [String], context: [String], headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<ClientResponse> {
        let localVariablePath = "/fake/test-query-parameters"
        let localVariableURLString = apiConfiguration.basePath + localVariablePath

        guard let localVariableApiClient = apiConfiguration.apiClient else {
            fatalError("apiConfiguration.apiClient is not set.")
        }

        return localVariableApiClient.send(.PUT, headers: headers, to: URI(string: localVariableURLString)) { localVariableRequest in
            try Configuration.apiWrapper(&localVariableRequest)
            
            struct QueryParams: Content {
                var pipe: [String]
                var ioutil: [String]
                var http: [String]
                var url: [String]
                var context: [String]

                enum CodingKeys: String, CodingKey {
                    case pipe = "pipe"
                    case ioutil = "ioutil"
                    case http = "http"
                    case url = "url"
                    case context = "context"
                }
            }
            try localVariableRequest.query.encode(QueryParams(pipe: pipe, ioutil: ioutil, http: http, url: url, context: context))
            
            try beforeSend(&localVariableRequest)
        }
    }

    public enum TestQueryParameterCollectionFormat {
        case http200(raw: ClientResponse)
        case http0(raw: ClientResponse)
    }

    /**
     PUT /fake/test-query-parameters
     To test the collection format in query parameters
     - parameter pipe: (query)  
     - parameter ioutil: (query)  
     - parameter http: (query)  
     - parameter url: (query)  
     - parameter context: (query)  
     - returns: `EventLoopFuture` of `TestQueryParameterCollectionFormat` 
     */
    open class func testQueryParameterCollectionFormat(pipe: [String], ioutil: [String], http: [String], url: [String], context: [String], headers: HTTPHeaders = PetstoreClientAPIConfiguration.shared.customHeaders, beforeSend: (inout ClientRequest) throws -> () = { _ in }) -> EventLoopFuture<TestQueryParameterCollectionFormat> {
        return testQueryParameterCollectionFormatRaw(pipe: pipe, ioutil: ioutil, http: http, url: url, context: context, headers: headers, beforeSend: beforeSend).flatMapThrowing { response -> TestQueryParameterCollectionFormat in
            switch response.status.code {
            case 200:
                return .http200(raw: response)
            default:
                return .http0(raw: response)
            }
        }
    }
}
