/* tslint:disable */
/* eslint-disable */
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import {Api} from './index';
import {List} from 'immutable';
import {all, fork, put, takeLatest} from "redux-saga/effects";
import {apiCall, createSagaAction as originalCreateSagaAction, BaseEntitySupportPayloadApiAction, BasePayloadApiAction, NormalizedRecordEntities, normalizedEntities} from "../runtimeSagasAndRecords";
import {Action} from "redux-ts-simple";

import {
    Order,
    OrderRecord,
    orderRecordUtils,
} from '../models/index';

const createSagaAction = <T>(type: string) => originalCreateSagaAction<T>(type, {namespace: "api_storeApi"});

export const storeApiSagaMap = new Map<string, () => Generator<any, any, any>>([
        ["deleteOrder", deleteOrderSaga],
        ["getInventory", getInventorySaga],
        ["getOrderById", getOrderByIdSaga],
        ["placeOrder", placeOrderSaga],
    ]
);

export function *storeApiAllSagas() {
    yield all([...storeApiSagaMap.values()].map(actionSaga => fork(actionSaga)));
}

//region deleteOrder

export interface PayloadDeleteOrder extends PayloadDeleteOrderRequest, BasePayloadApiAction {
}

export interface PayloadDeleteOrderRequest {
    orderId: string;
}

export const deleteOrderRequest = createSagaAction<PayloadDeleteOrderRequest>("deleteOrderRequest");
export const deleteOrderSuccess = createSagaAction<void>("deleteOrderSuccess");
export const deleteOrderFailure = createSagaAction<{error: any, requestPayload: PayloadDeleteOrder}>("deleteOrderFailure");

export const deleteOrder = createSagaAction<PayloadDeleteOrder>("deleteOrder");

export function *deleteOrderSaga() {
    yield takeLatest(deleteOrder, deleteOrderSagaImp);
}

export function *deleteOrderSagaImp(_action_: Action<PayloadDeleteOrder>): any {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            orderId,
        } = _payloadRest_;

        yield put(deleteOrderRequest(_action_.payload));

        const response = yield apiCall(Api.storeApi, Api.storeApi['deleteOrder'],
            orderId,
        );

            yield put(deleteOrderSuccess());

        return undefined;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(deleteOrderFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region getInventory

export interface PayloadGetInventory extends BasePayloadApiAction {
}


export const getInventoryRequest = createSagaAction<void>("getInventoryRequest");
export const getInventorySuccess = createSagaAction<{ [key: string]: number; }>("getInventorySuccess");
export const getInventoryFailure = createSagaAction<{error: any, requestPayload: PayloadGetInventory}>("getInventoryFailure");

export const getInventory = createSagaAction<PayloadGetInventory>("getInventory");

export function *getInventorySaga() {
    yield takeLatest(getInventory, getInventorySagaImp);
}

export function *getInventorySagaImp(_action_: Action<PayloadGetInventory>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {

        yield put(getInventoryRequest());

        const response: Required<{ [key: string]: number; }> = yield apiCall(Api.storeApi, Api.storeApi['getInventory'],
        );

        let successReturnValue: any = undefined;
            yield put(getInventorySuccess(response));

        return response;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(getInventoryFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region getOrderById

export interface PayloadGetOrderById extends PayloadGetOrderByIdRequest, BaseEntitySupportPayloadApiAction {
}

export interface PayloadGetOrderByIdRequest {
    orderId: string;
}

export const getOrderByIdRequest = createSagaAction<PayloadGetOrderByIdRequest>("getOrderByIdRequest");
export const getOrderByIdSuccess = createSagaAction<OrderRecord>("getOrderByIdSuccess");
export const getOrderByIdSuccess_Entities = createSagaAction<NormalizedRecordEntities>("getOrderByIdSuccess_Entities");
export const getOrderByIdFailure = createSagaAction<{error: any, requestPayload: PayloadGetOrderById}>("getOrderByIdFailure");

export const getOrderById = createSagaAction<PayloadGetOrderById>("getOrderById");

export function *getOrderByIdSaga() {
    yield takeLatest(getOrderById, getOrderByIdSagaImp);
}

export function *getOrderByIdSagaImp(_action_: Action<PayloadGetOrderById>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {toEntities, toInlined = !toEntities, ...requestPayload} = _payloadRest_;
        const {
            orderId,
        } = _payloadRest_;

        yield put(getOrderByIdRequest(requestPayload));

        const response: Required<Order> = yield apiCall(Api.storeApi, Api.storeApi['getOrderById'],
            parseFloat(orderId),
        );

        let successReturnValue: any = undefined;
        if (toEntities) {
            successReturnValue = orderRecordUtils.fromApiArrayAsEntities([response]);
            yield put(normalizedEntities(successReturnValue));
            yield put(getOrderByIdSuccess_Entities(successReturnValue));
        }
        if (toInlined) {
            successReturnValue = orderRecordUtils.fromApi(response);
            yield put(getOrderByIdSuccess(successReturnValue));
        }

        return successReturnValue;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(getOrderByIdFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region placeOrder

export interface PayloadPlaceOrder extends PayloadPlaceOrderRequest, BaseEntitySupportPayloadApiAction {
}

export interface PayloadPlaceOrderRequest {
    body: OrderRecord;
}

export const placeOrderRequest = createSagaAction<PayloadPlaceOrderRequest>("placeOrderRequest");
export const placeOrderSuccess = createSagaAction<OrderRecord>("placeOrderSuccess");
export const placeOrderSuccess_Entities = createSagaAction<NormalizedRecordEntities>("placeOrderSuccess_Entities");
export const placeOrderFailure = createSagaAction<{error: any, requestPayload: PayloadPlaceOrder}>("placeOrderFailure");

export const placeOrder = createSagaAction<PayloadPlaceOrder>("placeOrder");

export function *placeOrderSaga() {
    yield takeLatest(placeOrder, placeOrderSagaImp);
}

export function *placeOrderSagaImp(_action_: Action<PayloadPlaceOrder>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {toEntities, toInlined = !toEntities, ...requestPayload} = _payloadRest_;
        const {
            body,
        } = _payloadRest_;

        yield put(placeOrderRequest(requestPayload));

        const response: Required<Order> = yield apiCall(Api.storeApi, Api.storeApi['placeOrder'],
            orderRecordUtils.toApi(body),
        );

        let successReturnValue: any = undefined;
        if (toEntities) {
            successReturnValue = orderRecordUtils.fromApiArrayAsEntities([response]);
            yield put(normalizedEntities(successReturnValue));
            yield put(placeOrderSuccess_Entities(successReturnValue));
        }
        if (toInlined) {
            successReturnValue = orderRecordUtils.fromApi(response);
            yield put(placeOrderSuccess(successReturnValue));
        }

        return successReturnValue;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(placeOrderFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
