/* tslint:disable */
/* eslint-disable */
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import {Api} from './index';
import {List} from 'immutable';
import {all, fork, put, takeLatest} from "redux-saga/effects";
import {apiCall, createSagaAction as originalCreateSagaAction, BaseEntitySupportPayloadApiAction, BasePayloadApiAction, NormalizedRecordEntities, normalizedEntities} from "../runtimeSagasAndRecords";
import {Action} from "redux-ts-simple";

import {
    DefaultMetaOnlyResponse,
    DefaultMetaOnlyResponseRecord,
    defaultMetaOnlyResponseRecordUtils,
    User,
    UserRecord,
    userRecordUtils,
} from '../models/index';

const createSagaAction = <T>(type: string) => originalCreateSagaAction<T>(type, {namespace: "api_userApi"});

export const userApiSagaMap = new Map<string, () => Generator<any, any, any>>([
        ["createUser", createUserSaga],
        ["createUsersWithArrayInput", createUsersWithArrayInputSaga],
        ["createUsersWithListInput", createUsersWithListInputSaga],
        ["deleteUser", deleteUserSaga],
        ["getUserByName", getUserByNameSaga],
        ["loginUser", loginUserSaga],
        ["logoutUser", logoutUserSaga],
        ["updateUser", updateUserSaga],
    ]
);

export function *userApiAllSagas() {
    yield all([...userApiSagaMap.values()].map(actionSaga => fork(actionSaga)));
}

//region createUser

export interface PayloadCreateUser extends PayloadCreateUserRequest, BasePayloadApiAction {
}

export interface PayloadCreateUserRequest {
    body: UserRecord;
}

export const createUserRequest = createSagaAction<PayloadCreateUserRequest>("createUserRequest");
export const createUserSuccess = createSagaAction<void>("createUserSuccess");
export const createUserFailure = createSagaAction<{error: any, requestPayload: PayloadCreateUser}>("createUserFailure");

export const createUser = createSagaAction<PayloadCreateUser>("createUser");

export function *createUserSaga() {
    yield takeLatest(createUser, createUserSagaImp);
}

export function *createUserSagaImp(_action_: Action<PayloadCreateUser>): any {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            body,
        } = _payloadRest_;

        yield put(createUserRequest(_action_.payload));

        const response = yield apiCall(Api.userApi, Api.userApi['createUser'],
            userRecordUtils.toApi(body),
        );

            yield put(createUserSuccess());

        return undefined;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(createUserFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region createUsersWithArrayInput

export interface PayloadCreateUsersWithArrayInput extends PayloadCreateUsersWithArrayInputRequest, BasePayloadApiAction {
}

export interface PayloadCreateUsersWithArrayInputRequest {
    body: List<UserRecord>;
}

export const createUsersWithArrayInputRequest = createSagaAction<PayloadCreateUsersWithArrayInputRequest>("createUsersWithArrayInputRequest");
export const createUsersWithArrayInputSuccess = createSagaAction<void>("createUsersWithArrayInputSuccess");
export const createUsersWithArrayInputFailure = createSagaAction<{error: any, requestPayload: PayloadCreateUsersWithArrayInput}>("createUsersWithArrayInputFailure");

export const createUsersWithArrayInput = createSagaAction<PayloadCreateUsersWithArrayInput>("createUsersWithArrayInput");

export function *createUsersWithArrayInputSaga() {
    yield takeLatest(createUsersWithArrayInput, createUsersWithArrayInputSagaImp);
}

export function *createUsersWithArrayInputSagaImp(_action_: Action<PayloadCreateUsersWithArrayInput>): any {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            body,
        } = _payloadRest_;

        yield put(createUsersWithArrayInputRequest(_action_.payload));

        const response = yield apiCall(Api.userApi, Api.userApi['createUsersWithArrayInput'],
            userRecordUtils.toApiArray(body),
        );

            yield put(createUsersWithArrayInputSuccess());

        return undefined;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(createUsersWithArrayInputFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region createUsersWithListInput

export interface PayloadCreateUsersWithListInput extends PayloadCreateUsersWithListInputRequest, BasePayloadApiAction {
}

export interface PayloadCreateUsersWithListInputRequest {
    body: List<UserRecord>;
}

export const createUsersWithListInputRequest = createSagaAction<PayloadCreateUsersWithListInputRequest>("createUsersWithListInputRequest");
export const createUsersWithListInputSuccess = createSagaAction<void>("createUsersWithListInputSuccess");
export const createUsersWithListInputFailure = createSagaAction<{error: any, requestPayload: PayloadCreateUsersWithListInput}>("createUsersWithListInputFailure");

export const createUsersWithListInput = createSagaAction<PayloadCreateUsersWithListInput>("createUsersWithListInput");

export function *createUsersWithListInputSaga() {
    yield takeLatest(createUsersWithListInput, createUsersWithListInputSagaImp);
}

export function *createUsersWithListInputSagaImp(_action_: Action<PayloadCreateUsersWithListInput>): any {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            body,
        } = _payloadRest_;

        yield put(createUsersWithListInputRequest(_action_.payload));

        const response = yield apiCall(Api.userApi, Api.userApi['createUsersWithListInput'],
            userRecordUtils.toApiArray(body),
        );

            yield put(createUsersWithListInputSuccess());

        return undefined;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(createUsersWithListInputFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region deleteUser

export interface PayloadDeleteUser extends PayloadDeleteUserRequest, BasePayloadApiAction {
}

export interface PayloadDeleteUserRequest {
    username: string;
}

export const deleteUserRequest = createSagaAction<PayloadDeleteUserRequest>("deleteUserRequest");
export const deleteUserSuccess = createSagaAction<void>("deleteUserSuccess");
export const deleteUserFailure = createSagaAction<{error: any, requestPayload: PayloadDeleteUser}>("deleteUserFailure");

export const deleteUser = createSagaAction<PayloadDeleteUser>("deleteUser");

export function *deleteUserSaga() {
    yield takeLatest(deleteUser, deleteUserSagaImp);
}

export function *deleteUserSagaImp(_action_: Action<PayloadDeleteUser>): any {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            username,
        } = _payloadRest_;

        yield put(deleteUserRequest(_action_.payload));

        const response = yield apiCall(Api.userApi, Api.userApi['deleteUser'],
            username,
        );

            yield put(deleteUserSuccess());

        return undefined;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(deleteUserFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region getUserByName

export interface PayloadGetUserByName extends PayloadGetUserByNameRequest, BaseEntitySupportPayloadApiAction {
}

export interface PayloadGetUserByNameRequest {
    username: string;
}

export const getUserByNameRequest = createSagaAction<PayloadGetUserByNameRequest>("getUserByNameRequest");
export const getUserByNameSuccess = createSagaAction<UserRecord>("getUserByNameSuccess");
export const getUserByNameSuccess_Entities = createSagaAction<NormalizedRecordEntities>("getUserByNameSuccess_Entities");
export const getUserByNameFailure = createSagaAction<{error: any, requestPayload: PayloadGetUserByName}>("getUserByNameFailure");

export const getUserByName = createSagaAction<PayloadGetUserByName>("getUserByName");

export function *getUserByNameSaga() {
    yield takeLatest(getUserByName, getUserByNameSagaImp);
}

export function *getUserByNameSagaImp(_action_: Action<PayloadGetUserByName>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {toEntities, toInlined = !toEntities, ...requestPayload} = _payloadRest_;
        const {
            username,
        } = _payloadRest_;

        yield put(getUserByNameRequest(requestPayload));

        const response: Required<User> = yield apiCall(Api.userApi, Api.userApi['getUserByName'],
            username,
        );

        let successReturnValue: any = undefined;
        if (toEntities) {
            successReturnValue = userRecordUtils.fromApiArrayAsEntities([response]);
            yield put(normalizedEntities(successReturnValue));
            yield put(getUserByNameSuccess_Entities(successReturnValue));
        }
        if (toInlined) {
            successReturnValue = userRecordUtils.fromApi(response);
            yield put(getUserByNameSuccess(successReturnValue));
        }

        return successReturnValue;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(getUserByNameFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region loginUser

export interface PayloadLoginUser extends PayloadLoginUserRequest, BasePayloadApiAction {
}

export interface PayloadLoginUserRequest {
    username: string;
    password: string;
}

export const loginUserRequest = createSagaAction<PayloadLoginUserRequest>("loginUserRequest");
export const loginUserSuccess = createSagaAction<string>("loginUserSuccess");
export const loginUserFailure = createSagaAction<{error: any, requestPayload: PayloadLoginUser}>("loginUserFailure");

export const loginUser = createSagaAction<PayloadLoginUser>("loginUser");

export function *loginUserSaga() {
    yield takeLatest(loginUser, loginUserSagaImp);
}

export function *loginUserSagaImp(_action_: Action<PayloadLoginUser>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            username,
            password,
        } = _payloadRest_;

        yield put(loginUserRequest(_action_.payload));

        const response: Required<string> = yield apiCall(Api.userApi, Api.userApi['loginUser'],
            username,
            password,
        );

        let successReturnValue: any = undefined;
            yield put(loginUserSuccess(response));

        return response;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(loginUserFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region logoutUser

export interface PayloadLogoutUser extends BasePayloadApiAction {
}


export const logoutUserRequest = createSagaAction<void>("logoutUserRequest");
export const logoutUserSuccess = createSagaAction<void>("logoutUserSuccess");
export const logoutUserFailure = createSagaAction<{error: any, requestPayload: PayloadLogoutUser}>("logoutUserFailure");

export const logoutUser = createSagaAction<PayloadLogoutUser>("logoutUser");

export function *logoutUserSaga() {
    yield takeLatest(logoutUser, logoutUserSagaImp);
}

export function *logoutUserSagaImp(_action_: Action<PayloadLogoutUser>): any {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {

        yield put(logoutUserRequest());

        const response = yield apiCall(Api.userApi, Api.userApi['logoutUser'],
        );

            yield put(logoutUserSuccess());

        return undefined;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(logoutUserFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
//region updateUser

export interface PayloadUpdateUser extends PayloadUpdateUserRequest, BasePayloadApiAction {
}

export interface PayloadUpdateUserRequest {
    username: string;
    body: UserRecord;
}

export const updateUserRequest = createSagaAction<PayloadUpdateUserRequest>("updateUserRequest");
export const updateUserSuccess = createSagaAction<void>("updateUserSuccess");
export const updateUserFailure = createSagaAction<{error: any, requestPayload: PayloadUpdateUser}>("updateUserFailure");

export const updateUser = createSagaAction<PayloadUpdateUser>("updateUser");

export function *updateUserSaga() {
    yield takeLatest(updateUser, updateUserSagaImp);
}

export function *updateUserSagaImp(_action_: Action<PayloadUpdateUser>) {
    const {markErrorsAsHandled, ..._payloadRest_} = _action_.payload;
    try {
        const {
            username,
            body,
        } = _payloadRest_;

        yield put(updateUserRequest(_action_.payload));

        const response: Required<DefaultMetaOnlyResponse> = yield apiCall(Api.userApi, Api.userApi['updateUser'],
            username,
            userRecordUtils.toApi(body),
        );

            yield put(updateUserSuccess());

        return undefined;
    } catch (error: any) {
        if (markErrorsAsHandled) {error.wasHandled = true; }
        yield put(updateUserFailure({error, requestPayload: _action_.payload}));
        return error;
    }
}
//endregion
