# Xojo API client for XojoOpenAPIClientSynchronous

This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://github.com/OAI/OpenAPI-Specification) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.XojoClientCodegen

## Installation

This project contains generated code suitable for both Desktop and Console applications on all operating systems.

The code is generated for Xojo's API v1.

The generated code is packaged into a single Module (`XojoOpenAPIClientSynchronous`), which we suggest copying to your project after opening the generated `XojoOpenAPIClientSynchronous.xojo_project` in [Xojo](https://xojo.com/). Working in the generated Xojo project is not recommended.

> See also Xojo's [Sharing code among multiple projects](https://documentation.xojo.com/topics/code_management/sharing_code_among_multiple_projects.html).

This project depends on [Xoson](https://github.com/Topheee/xoson) `v2.2.0` (and above). Download it to your computer:
```shell
git clone 'https://github.com/Topheee/xoson.git'
```

Open the `Xoson.xojo_project` from the cloned git repository with Xojo and copy the `Xoson` module to your project. Similarly, open the `XojoOpenAPIClientSynchronous.xojo_project` file with Xojo and copy `XojoOpenAPIClientSynchronous` to your project.

> Since Xojo currently has no package manager, you need to manually copy both the `Xoson` and the `XojoOpenAPIClientSynchronous` modules to your Xojo project.

Both modules must not be copied into another module, but must reside at the top level of your project.

### Customization

The generator can be configured with the following options.

Option | Used | Description
--- | --- | ---
`projectName` | `XojoOpenAPIClientSynchronous` | The name of the generated project and module.
`nonPublicApi` | `false` | Generate `Protected` instead of `Public` methods, if set.
`library` | `httpsocket` | Internal Xojo standard library object to use. Currently only `httpsocket` (`HTTPSocket` class) is supported.
`serializationLibrary` | `{xoson` | Internal library to use for serialization. Currently only `xoson` ([Xoson](https://github.com/Topheee/xoson) library) is supported.
`supportsAsync` | `false` | If `true`, generated APIs will use callbacks instead of blocking the main thread.

### Usage

Communication with the OpenAPI server is done by instantiating one of the classes below `XojoOpenAPIClientSynchronous.APIs`, configuring it - by setting `BasePath`, `UseHTTPS`, and `Port` - and invoking the `Public ` methods.

If the methods returns `True`, the API request was successful. Otherwise, the `localOutStatus` parameter contains information about the failure. Note that despite this `ByRef` parameter, the methods may still raise an exception!

The method blocks until the response is received.

> The property `AdditionalHeaders` allows sending further headers with each request. Set it to a new `Dictionary`, with the Keys being the header names and the values either being a single String or an array of Strings.

__Error handling__, as well as status reporting, is done via class `XojoOpenAPIClientSynchronous.XojoOpenAPIClientSynchronousException`. Note that an instance of this class does not always indicate an error - check `IsError` to find out.
- `ErrorNumber` is set to one of the `XojoOpenAPIClientSynchronous.kError` constants, or `0` in case of no error.
- `HTTPStatus` is set to the HTTP status code as returned by the server. If the error is unrelated to HTTP, this property is `-1`.
- `SocketCode` contains the socket error, if any; otherwise `0`.

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*XojoOpenAPIClientSynchronous.APIs.PetApi* | [**AddPet**](PetApi.md#addpet) | **POST** /pet | Add a new pet to the store
*XojoOpenAPIClientSynchronous.APIs.PetApi* | [**DeletePet**](PetApi.md#deletepet) | **DELETE** /pet/{petId} | Deletes a pet
*XojoOpenAPIClientSynchronous.APIs.PetApi* | [**FindPetsByStatus**](PetApi.md#findpetsbystatus) | **GET** /pet/findByStatus | Finds Pets by status
*XojoOpenAPIClientSynchronous.APIs.PetApi* | [**FindPetsByTags**](PetApi.md#findpetsbytags) | **GET** /pet/findByTags | Finds Pets by tags
*XojoOpenAPIClientSynchronous.APIs.PetApi* | [**GetPetById**](PetApi.md#getpetbyid) | **GET** /pet/{petId} | Find pet by ID
*XojoOpenAPIClientSynchronous.APIs.PetApi* | [**UpdatePet**](PetApi.md#updatepet) | **PUT** /pet | Update an existing pet
*XojoOpenAPIClientSynchronous.APIs.PetApi* | [**UpdatePetWithForm**](PetApi.md#updatepetwithform) | **POST** /pet/{petId} | Updates a pet in the store with form data
*XojoOpenAPIClientSynchronous.APIs.PetApi* | [**UploadFile**](PetApi.md#uploadfile) | **POST** /pet/{petId}/uploadImage | uploads an image
*XojoOpenAPIClientSynchronous.APIs.StoreApi* | [**DeleteOrder**](StoreApi.md#deleteorder) | **DELETE** /store/order/{orderId} | Delete purchase order by ID
*XojoOpenAPIClientSynchronous.APIs.StoreApi* | [**GetInventory**](StoreApi.md#getinventory) | **GET** /store/inventory | Returns pet inventories by status
*XojoOpenAPIClientSynchronous.APIs.StoreApi* | [**GetOrderById**](StoreApi.md#getorderbyid) | **GET** /store/order/{orderId} | Find purchase order by ID
*XojoOpenAPIClientSynchronous.APIs.StoreApi* | [**PlaceOrder**](StoreApi.md#placeorder) | **POST** /store/order | Place an order for a pet
*XojoOpenAPIClientSynchronous.APIs.UserApi* | [**CreateUser**](UserApi.md#createuser) | **POST** /user | Create user
*XojoOpenAPIClientSynchronous.APIs.UserApi* | [**CreateUsersWithArrayInput**](UserApi.md#createuserswitharrayinput) | **POST** /user/createWithArray | Creates list of users with given input array
*XojoOpenAPIClientSynchronous.APIs.UserApi* | [**CreateUsersWithListInput**](UserApi.md#createuserswithlistinput) | **POST** /user/createWithList | Creates list of users with given input array
*XojoOpenAPIClientSynchronous.APIs.UserApi* | [**DeleteUser**](UserApi.md#deleteuser) | **DELETE** /user/{username} | Delete user
*XojoOpenAPIClientSynchronous.APIs.UserApi* | [**GetUserByName**](UserApi.md#getuserbyname) | **GET** /user/{username} | Get user by user name
*XojoOpenAPIClientSynchronous.APIs.UserApi* | [**LoginUser**](UserApi.md#loginuser) | **GET** /user/login | Logs user into the system
*XojoOpenAPIClientSynchronous.APIs.UserApi* | [**LogoutUser**](UserApi.md#logoutuser) | **GET** /user/logout | Logs out current logged in user session
*XojoOpenAPIClientSynchronous.APIs.UserApi* | [**UpdateUser**](UserApi.md#updateuser) | **PUT** /user/{username} | Updated user


## Documentation For Models

 - [XojoOpenAPIClientSynchronous.Models.ApiResponse](ApiResponse.md)
 - [XojoOpenAPIClientSynchronous.Models.Category](Category.md)
 - [XojoOpenAPIClientSynchronous.Models.Order](Order.md)
 - [XojoOpenAPIClientSynchronous.Models.Pet](Pet.md)
 - [XojoOpenAPIClientSynchronous.Models.Tag](Tag.md)
 - [XojoOpenAPIClientSynchronous.Models.User](User.md)


## Documentation For Authorization


## petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
 - **write:pets**: modify pets in your account
 - **read:pets**: read your pets

## api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header


## Author



