# Documentation for zapier generator

This generator generates a partial implementation of a zapier integration from an openapi specification.

## Why is it partial?

It's a partial integration because you have to put in some code for it to be 100% complete, code that depends only on how your api is structured.

Here there are all the parts you need to complete by yourself: 

### 1) **utils/utils.js** isSearchAction method
This method has to return either true or false if a method is a [zapier search action](https://platform.zapier.com/docs/search-create).
```
const isSearchAction = (key) => {
    // TODO: custom logic
    return false
}
```

### 2) **utils/utils.js** searchMiddleware method
This method has to return an array of resources (searches must return an array), if you have pagination or you api returns an array inside nested fields, here you have to extract the array.

```
const searchMiddleware = (action) => {
    // TODO: custom logic
    return action
}
```

### 3) **authentication.js**
This file must be written completely according to your api authentication, you can get it generated automatically by creating the integration on the zapier website and filling the requested data, or you can build it yourself following [this guide](https://platform.zapier.com/cli_tutorials/getting-started#adding-authentication).

## Samples
To get your app made public on zapier you must provide a sample (json example response) for each of your actions, these samples get automatically generated by this generator but you have to have actual response examples in you openapi file.  

For example: 

```
CreateUserResponse:
    description: Example response
    content:
        application/json:
            schema:
                $ref: ./models/responses/CreateUserResponse.yaml
                examples:
                    example-1:
                        value:
                        data:
                            id: 12345
                            name: user1
```
