# openapi3-extensions-x-auth-id-alias-jersey2-java8

OpenAPI Extension x-auth-id-alias

- API version: 1.0.0

- Generator version: 7.20.0-SNAPSHOT

This specification shows how to use x-auth-id-alias extension for API keys.


*Automatically generated by the [OpenAPI Generator](https://openapi-generator.tech)*

## Requirements

Building the API client library requires:

1. Java 1.8+
2. Maven (3.8.3+)/Gradle (7.2+)

## Installation

To install the API client library to your local Maven repository, simply execute:

```shell
mvn clean install
```

To deploy it to a remote Maven repository instead, configure the settings of the repository and execute:

```shell
mvn clean deploy
```

Refer to the [OSSRH Guide](http://central.sonatype.org/pages/ossrh-guide.html) for more information.

### Maven users

Add this dependency to your project's POM:

```xml
<dependency>
  <groupId>org.openapitools</groupId>
  <artifactId>openapi3-extensions-x-auth-id-alias-jersey2-java8</artifactId>
  <version>1.0.0</version>
  <scope>compile</scope>
</dependency>
```

### Gradle users

Add this dependency to your project's build file:

```groovy
  repositories {
    mavenCentral()     // Needed if the 'openapi3-extensions-x-auth-id-alias-jersey2-java8' jar has been published to maven central.
    mavenLocal()       // Needed if the 'openapi3-extensions-x-auth-id-alias-jersey2-java8' jar has been published to the local maven repo.
  }

  dependencies {
     implementation "org.openapitools:openapi3-extensions-x-auth-id-alias-jersey2-java8:1.0.0"
  }
```

### Others

At first generate the JAR by executing:

```shell
mvn clean package
```

Then manually install the following JARs:

- `target/openapi3-extensions-x-auth-id-alias-jersey2-java8-1.0.0.jar`
- `target/lib/*.jar`

## Usage

To add a HTTP proxy for the API client, use `ClientConfig`:
```java

import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientProperties;
import org.openapitools.client.*;
import org.openapitools.client.api.UsageApi;

...

ApiClient defaultClient = Configuration.getDefaultApiClient();
ClientConfig clientConfig = defaultClient.getClientConfig();
clientConfig.connectorProvider(new ApacheConnectorProvider());
clientConfig.property(ClientProperties.PROXY_URI, "http://proxy_url_here");
clientConfig.property(ClientProperties.PROXY_USERNAME, "proxy_username");
clientConfig.property(ClientProperties.PROXY_PASSWORD, "proxy_password");
defaultClient.setClientConfig(clientConfig);

UsageApi apiInstance = new UsageApi(defaultClient);

```

## Getting Started

Please follow the [installation](#installation) instruction and execute the following Java code:

```java

import org.openapitools.client.*;
import org.openapitools.client.auth.*;
import org.openapitools.client.model.*;
import org.openapitools.client.api.UsageApi;

public class UsageApiExample {

    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("http://petstore.swagger.io:80/v2");
        
        // Configure API key authorization: api_key
        ApiKeyAuth api_key = (ApiKeyAuth) defaultClient.getAuthentication("api_key");
        api_key.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //api_key.setApiKeyPrefix("Token");

        // Configure API key authorization: api_key_query
        ApiKeyAuth api_key_query = (ApiKeyAuth) defaultClient.getAuthentication("api_key_query");
        api_key_query.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //api_key_query.setApiKeyPrefix("Token");

        UsageApi apiInstance = new UsageApi(defaultClient);
        try {
            Object result = apiInstance.anyKey();
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UsageApi#anyKey");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}

```

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io:80/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*UsageApi* | [**anyKey**](docs/UsageApi.md#anyKey) | **GET** /any | Use any API key
*UsageApi* | [**bothKeys**](docs/UsageApi.md#bothKeys) | **GET** /both | Use both API keys
*UsageApi* | [**keyInHeader**](docs/UsageApi.md#keyInHeader) | **GET** /header | Use API key in header
*UsageApi* | [**keyInQuery**](docs/UsageApi.md#keyInQuery) | **GET** /query | Use API key in query


## Documentation for Models



<a id="documentation-for-authorization"></a>
## Documentation for Authorization


Authentication schemes defined for the API:
<a id="api_key"></a>
### api_key


- **Type**: API key
- **API key parameter name**: X-Api-Key
- **Location**: HTTP header

<a id="api_key_query"></a>
### api_key_query


- **Type**: API key
- **API key parameter name**: api_key
- **Location**: URL query string


## Recommendation

It's recommended to create an instance of `ApiClient` per thread in a multithreaded environment to avoid any potential issues.

## Author



