# dynamic_servers

DynamicServers - the Ruby gem for the OpenAPI Extension with dynamic servers

This specification shows how to use dynamic servers.

This SDK is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.RubyClientCodegen

## Installation

### Build a gem

To build the Ruby code into a gem:

```shell
gem build dynamic_servers.gemspec
```

Then either install the gem locally:

```shell
gem install ./dynamic_servers-1.0.0.gem
```

(for development, run `gem install --dev ./dynamic_servers-1.0.0.gem` to install the development dependencies)

or publish the gem to a gem hosting service, e.g. [RubyGems](https://rubygems.org/).

Finally add this to the Gemfile:

    gem 'dynamic_servers', '~> 1.0.0'

### Install from Git

If the Ruby gem is hosted at a git repository: https://github.com/GIT_USER_ID/GIT_REPO_ID, then add the following in the Gemfile:

    gem 'dynamic_servers', :git => 'https://github.com/GIT_USER_ID/GIT_REPO_ID.git'

### Include the Ruby code directly

Include the Ruby code directly using `-I` as follows:

```shell
ruby -Ilib script.rb
```

## Getting Started

Please follow the [installation](#installation) procedure and then run the following code:

```ruby
# Load the gem
require 'dynamic_servers'

api_instance = DynamicServers::UsageApi.new

begin
  #Use custom server
  result = api_instance.custom_server
  p result
rescue DynamicServers::ApiError => e
  puts "Exception when calling UsageApi->custom_server: #{e}"
end

```

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io:80/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DynamicServers::UsageApi* | [**custom_server**](docs/UsageApi.md#custom_server) | **GET** /custom | Use custom server
*DynamicServers::UsageApi* | [**default_server**](docs/UsageApi.md#default_server) | **GET** /default | Use default server


## Documentation for Models



## Documentation for Authorization

Endpoints do not require authorization.

