/*
OpenAPI Petstore

This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package petstore

import (
	"encoding/json"
	"fmt"
	"gopkg.in/validator.v2"
)

// FruitReq - struct for FruitReq
type FruitReq struct {
	AppleReq *AppleReq
	BananaReq *BananaReq
}

// AppleReqAsFruitReq is a convenience function that returns AppleReq wrapped in FruitReq
func AppleReqAsFruitReq(v *AppleReq) FruitReq {
	return FruitReq{
		AppleReq: v,
	}
}

// BananaReqAsFruitReq is a convenience function that returns BananaReq wrapped in FruitReq
func BananaReqAsFruitReq(v *BananaReq) FruitReq {
	return FruitReq{
		BananaReq: v,
	}
}


// Unmarshal JSON data into one of the pointers in the struct
func (dst *FruitReq) UnmarshalJSON(data []byte) error {
	var err error
	match := 0
	// try to unmarshal data into AppleReq
	err = newStrictDecoder(data).Decode(&dst.AppleReq)
	if err == nil {
		jsonAppleReq, _ := json.Marshal(dst.AppleReq)
		if string(jsonAppleReq) == "{}" { // empty struct
			dst.AppleReq = nil
		} else {
			if err = validator.Validate(dst.AppleReq); err != nil {
				dst.AppleReq = nil
			} else {
				match++
			}
		}
	} else {
		dst.AppleReq = nil
	}

	// try to unmarshal data into BananaReq
	err = newStrictDecoder(data).Decode(&dst.BananaReq)
	if err == nil {
		jsonBananaReq, _ := json.Marshal(dst.BananaReq)
		if string(jsonBananaReq) == "{}" { // empty struct
			dst.BananaReq = nil
		} else {
			if err = validator.Validate(dst.BananaReq); err != nil {
				dst.BananaReq = nil
			} else {
				match++
			}
		}
	} else {
		dst.BananaReq = nil
	}

	if match > 1 { // more than 1 match
		// reset to nil
		dst.AppleReq = nil
		dst.BananaReq = nil

		return fmt.Errorf("data matches more than one schema in oneOf(FruitReq)")
	} else if match == 1 {
		return nil // exactly one match
	} else { // no match
		return fmt.Errorf("data failed to match schemas in oneOf(FruitReq)")
	}
}

// Marshal data from the first non-nil pointers in the struct to JSON
func (src FruitReq) MarshalJSON() ([]byte, error) {
	if src.AppleReq != nil {
		return json.Marshal(&src.AppleReq)
	}

	if src.BananaReq != nil {
		return json.Marshal(&src.BananaReq)
	}

	return nil, nil // no data in oneOf schemas
}

// Get the actual instance
func (obj *FruitReq) GetActualInstance() (interface{}) {
	if obj == nil {
		return nil
	}
	if obj.AppleReq != nil {
		return obj.AppleReq
	}

	if obj.BananaReq != nil {
		return obj.BananaReq
	}

	// all schemas are nil
	return nil
}

// Get the actual instance value
func (obj FruitReq) GetActualInstanceValue() (interface{}) {
	if obj.AppleReq != nil {
		return *obj.AppleReq
	}

	if obj.BananaReq != nil {
		return *obj.BananaReq
	}

	// all schemas are nil
	return nil
}

type NullableFruitReq struct {
	value *FruitReq
	isSet bool
}

func (v NullableFruitReq) Get() *FruitReq {
	return v.value
}

func (v *NullableFruitReq) Set(val *FruitReq) {
	v.value = val
	v.isSet = true
}

func (v NullableFruitReq) IsSet() bool {
	return v.isSet
}

func (v *NullableFruitReq) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableFruitReq(val *FruitReq) *NullableFruitReq {
	return &NullableFruitReq{value: val, isSet: true}
}

func (v NullableFruitReq) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableFruitReq) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


