/*
OpenAPI Petstore

This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package petstore

import (
	"encoding/json"
	"time"
	"fmt"
	"gopkg.in/validator.v2"
)

// OneOfPrimitiveTypes - struct for OneOfPrimitiveTypes
type OneOfPrimitiveTypes struct {
	String *string
	TimeTime *time.Time
}

// stringAsOneOfPrimitiveTypes is a convenience function that returns string wrapped in OneOfPrimitiveTypes
func StringAsOneOfPrimitiveTypes(v *string) OneOfPrimitiveTypes {
	return OneOfPrimitiveTypes{
		String: v,
	}
}

// time.TimeAsOneOfPrimitiveTypes is a convenience function that returns time.Time wrapped in OneOfPrimitiveTypes
func TimeTimeAsOneOfPrimitiveTypes(v *time.Time) OneOfPrimitiveTypes {
	return OneOfPrimitiveTypes{
		TimeTime: v,
	}
}


// Unmarshal JSON data into one of the pointers in the struct
func (dst *OneOfPrimitiveTypes) UnmarshalJSON(data []byte) error {
	var err error
	match := 0
	// try to unmarshal data into String
	err = newStrictDecoder(data).Decode(&dst.String)
	if err == nil {
		jsonString, _ := json.Marshal(dst.String)
		if string(jsonString) == "{}" { // empty struct
			dst.String = nil
		} else {
			if err = validator.Validate(dst.String); err != nil {
				dst.String = nil
			} else {
				match++
			}
		}
	} else {
		dst.String = nil
	}

	// try to unmarshal data into TimeTime
	err = newStrictDecoder(data).Decode(&dst.TimeTime)
	if err == nil {
		jsonTimeTime, _ := json.Marshal(dst.TimeTime)
		if string(jsonTimeTime) == "{}" { // empty struct
			dst.TimeTime = nil
		} else {
			if err = validator.Validate(dst.TimeTime); err != nil {
				dst.TimeTime = nil
			} else {
				match++
			}
		}
	} else {
		dst.TimeTime = nil
	}

	if match > 1 { // more than 1 match
		// reset to nil
		dst.String = nil
		dst.TimeTime = nil

		return fmt.Errorf("data matches more than one schema in oneOf(OneOfPrimitiveTypes)")
	} else if match == 1 {
		return nil // exactly one match
	} else { // no match
		return fmt.Errorf("data failed to match schemas in oneOf(OneOfPrimitiveTypes)")
	}
}

// Marshal data from the first non-nil pointers in the struct to JSON
func (src OneOfPrimitiveTypes) MarshalJSON() ([]byte, error) {
	if src.String != nil {
		return json.Marshal(&src.String)
	}

	if src.TimeTime != nil {
		return json.Marshal(&src.TimeTime)
	}

	return nil, nil // no data in oneOf schemas
}

// Get the actual instance
func (obj *OneOfPrimitiveTypes) GetActualInstance() (interface{}) {
	if obj == nil {
		return nil
	}
	if obj.String != nil {
		return obj.String
	}

	if obj.TimeTime != nil {
		return obj.TimeTime
	}

	// all schemas are nil
	return nil
}

// Get the actual instance value
func (obj OneOfPrimitiveTypes) GetActualInstanceValue() (interface{}) {
	if obj.String != nil {
		return *obj.String
	}

	if obj.TimeTime != nil {
		return *obj.TimeTime
	}

	// all schemas are nil
	return nil
}

type NullableOneOfPrimitiveTypes struct {
	value *OneOfPrimitiveTypes
	isSet bool
}

func (v NullableOneOfPrimitiveTypes) Get() *OneOfPrimitiveTypes {
	return v.value
}

func (v *NullableOneOfPrimitiveTypes) Set(val *OneOfPrimitiveTypes) {
	v.value = val
	v.isSet = true
}

func (v NullableOneOfPrimitiveTypes) IsSet() bool {
	return v.isSet
}

func (v *NullableOneOfPrimitiveTypes) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableOneOfPrimitiveTypes(val *OneOfPrimitiveTypes) *NullableOneOfPrimitiveTypes {
	return &NullableOneOfPrimitiveTypes{value: val, isSet: true}
}

func (v NullableOneOfPrimitiveTypes) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableOneOfPrimitiveTypes) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


