# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from petstore_api.models.read_only_first import ReadOnlyFirst
from typing import Optional, Set
from typing_extensions import Self

class ArrayTest(BaseModel):
    """
    ArrayTest
    """ # noqa: E501
    array_of_string: Optional[Annotated[List[StrictStr], Field(min_length=0, max_length=3)]] = None
    array_of_nullable_float: Optional[List[Optional[StrictFloat]]] = None
    array_array_of_integer: Optional[List[List[StrictInt]]] = None
    array_array_of_model: Optional[List[List[ReadOnlyFirst]]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["array_of_string", "array_of_nullable_float", "array_array_of_integer", "array_array_of_model"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ArrayTest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in array_array_of_model (list of list)
        _items = []
        if self.array_array_of_model:
            for _item_array_array_of_model in self.array_array_of_model:
                if _item_array_array_of_model:
                    _items.append(
                         [_inner_item.to_dict() for _inner_item in _item_array_array_of_model if _inner_item is not None]
                    )
            _dict['array_array_of_model'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ArrayTest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "array_of_string": obj.get("array_of_string"),
            "array_of_nullable_float": obj.get("array_of_nullable_float"),
            "array_array_of_integer": obj.get("array_array_of_integer"),
            "array_array_of_model": [
                    [ReadOnlyFirst.from_dict(_inner_item) for _inner_item in _item]
                    for _item in obj["array_array_of_model"]
                ] if obj.get("array_array_of_model") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


