# coding: utf-8

"""
    OpenAPI Petstore

    This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import Field, StrictBool
from petstore_api.models.creature import Creature
from petstore_api.models.creature_info import CreatureInfo

class HuntingDog(Creature):
    """
    HuntingDog
    """
    is_trained: Optional[StrictBool] = Field(default=None, alias="isTrained")
    __properties = ["info", "type", "isTrained"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> HuntingDog:
        """Create an instance of HuntingDog from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of info
        if self.info:
            _dict['info'] = self.info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> HuntingDog:
        """Create an instance of HuntingDog from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return HuntingDog.parse_obj(obj)

        _obj = HuntingDog.parse_obj({
            "info": CreatureInfo.from_dict(obj.get("info")) if obj.get("info") is not None else None,
            "type": obj.get("type"),
            "is_trained": obj.get("isTrained")
        })
        return _obj


