# petstore-api
This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 1.0.0
- Generator version: 7.20.0-SNAPSHOT
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import petstore_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import petstore_api
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
import datetime
import petstore_api
from petstore_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://petstore.swagger.io:80/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = petstore_api.Configuration(
    host = "http://petstore.swagger.io:80/v2"
)



# Enter a context with an instance of the API client
with petstore_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = petstore_api.AnotherFakeApi(api_client)
    client = petstore_api.Client() # Client | client model

    try:
        # To test special tags
        api_response = api_instance.call_123_test_special_tags(client)
        print("The response of AnotherFakeApi->call_123_test_special_tags:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AnotherFakeApi->call_123_test_special_tags: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://petstore.swagger.io:80/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnotherFakeApi* | [**call_123_test_special_tags**](docs/AnotherFakeApi.md#call_123_test_special_tags) | **PATCH** /another-fake/dummy | To test special tags
*DefaultApi* | [**foo_get**](docs/DefaultApi.md#foo_get) | **GET** /foo | 
*FakeApi* | [**fake_any_type_request_body**](docs/FakeApi.md#fake_any_type_request_body) | **POST** /fake/any_type_body | test any type request body
*FakeApi* | [**fake_enum_ref_query_parameter**](docs/FakeApi.md#fake_enum_ref_query_parameter) | **GET** /fake/enum_ref_query_parameter | test enum reference query parameter
*FakeApi* | [**fake_health_get**](docs/FakeApi.md#fake_health_get) | **GET** /fake/health | Health check endpoint
*FakeApi* | [**fake_http_signature_test**](docs/FakeApi.md#fake_http_signature_test) | **GET** /fake/http-signature-test | test http signature authentication
*FakeApi* | [**fake_outer_boolean_serialize**](docs/FakeApi.md#fake_outer_boolean_serialize) | **POST** /fake/outer/boolean | 
*FakeApi* | [**fake_outer_composite_serialize**](docs/FakeApi.md#fake_outer_composite_serialize) | **POST** /fake/outer/composite | 
*FakeApi* | [**fake_outer_number_serialize**](docs/FakeApi.md#fake_outer_number_serialize) | **POST** /fake/outer/number | 
*FakeApi* | [**fake_outer_string_serialize**](docs/FakeApi.md#fake_outer_string_serialize) | **POST** /fake/outer/string | 
*FakeApi* | [**fake_property_enum_integer_serialize**](docs/FakeApi.md#fake_property_enum_integer_serialize) | **POST** /fake/property/enum-int | 
*FakeApi* | [**fake_ref_enum_string**](docs/FakeApi.md#fake_ref_enum_string) | **GET** /fake/ref_enum_string | test ref to enum string
*FakeApi* | [**fake_return_boolean**](docs/FakeApi.md#fake_return_boolean) | **GET** /fake/return_boolean | test returning boolean
*FakeApi* | [**fake_return_byte_like_json**](docs/FakeApi.md#fake_return_byte_like_json) | **GET** /fake/return_byte_like_json | test byte like json
*FakeApi* | [**fake_return_enum**](docs/FakeApi.md#fake_return_enum) | **GET** /fake/return_enum | test returning enum
*FakeApi* | [**fake_return_enum_like_json**](docs/FakeApi.md#fake_return_enum_like_json) | **GET** /fake/return_enum_like_json | test enum like json
*FakeApi* | [**fake_return_float**](docs/FakeApi.md#fake_return_float) | **GET** /fake/return_float | test returning float
*FakeApi* | [**fake_return_int**](docs/FakeApi.md#fake_return_int) | **GET** /fake/return_int | test returning int
*FakeApi* | [**fake_return_list_of_objects**](docs/FakeApi.md#fake_return_list_of_objects) | **GET** /fake/return_list_of_object | test returning list of objects
*FakeApi* | [**fake_return_str_like_json**](docs/FakeApi.md#fake_return_str_like_json) | **GET** /fake/return_str_like_json | test str like json
*FakeApi* | [**fake_return_string**](docs/FakeApi.md#fake_return_string) | **GET** /fake/return_string | test returning string
*FakeApi* | [**fake_uuid_example**](docs/FakeApi.md#fake_uuid_example) | **GET** /fake/uuid_example | test uuid example
*FakeApi* | [**test_additional_properties_reference**](docs/FakeApi.md#test_additional_properties_reference) | **POST** /fake/additionalProperties-reference | test referenced additionalProperties
*FakeApi* | [**test_body_with_binary**](docs/FakeApi.md#test_body_with_binary) | **PUT** /fake/body-with-binary | 
*FakeApi* | [**test_body_with_file_schema**](docs/FakeApi.md#test_body_with_file_schema) | **PUT** /fake/body-with-file-schema | 
*FakeApi* | [**test_body_with_query_params**](docs/FakeApi.md#test_body_with_query_params) | **PUT** /fake/body-with-query-params | 
*FakeApi* | [**test_client_model**](docs/FakeApi.md#test_client_model) | **PATCH** /fake | To test \&quot;client\&quot; model
*FakeApi* | [**test_date_time_query_parameter**](docs/FakeApi.md#test_date_time_query_parameter) | **PUT** /fake/date-time-query-params | 
*FakeApi* | [**test_empty_and_non_empty_responses**](docs/FakeApi.md#test_empty_and_non_empty_responses) | **POST** /fake/empty_and_non_empty_responses | test empty and non-empty responses
*FakeApi* | [**test_endpoint_parameters**](docs/FakeApi.md#test_endpoint_parameters) | **POST** /fake | Fake endpoint for testing various parameters 假端點 偽のエンドポイント 가짜 엔드 포인트 
*FakeApi* | [**test_error_responses_with_model**](docs/FakeApi.md#test_error_responses_with_model) | **POST** /fake/error_responses_with_model | test error responses with model
*FakeApi* | [**test_group_parameters**](docs/FakeApi.md#test_group_parameters) | **DELETE** /fake | Fake endpoint to test group parameters (optional)
*FakeApi* | [**test_inline_additional_properties**](docs/FakeApi.md#test_inline_additional_properties) | **POST** /fake/inline-additionalProperties | test inline additionalProperties
*FakeApi* | [**test_inline_freeform_additional_properties**](docs/FakeApi.md#test_inline_freeform_additional_properties) | **POST** /fake/inline-freeform-additionalProperties | test inline free-form additionalProperties
*FakeApi* | [**test_json_form_data**](docs/FakeApi.md#test_json_form_data) | **GET** /fake/jsonFormData | test json serialization of form data
*FakeApi* | [**test_object_for_multipart_requests**](docs/FakeApi.md#test_object_for_multipart_requests) | **POST** /fake/object_for_multipart_requests | 
*FakeApi* | [**test_query_parameter_collection_format**](docs/FakeApi.md#test_query_parameter_collection_format) | **PUT** /fake/test-query-parameters | 
*FakeApi* | [**test_string_map_reference**](docs/FakeApi.md#test_string_map_reference) | **POST** /fake/stringMap-reference | test referenced string map
*FakeApi* | [**upload_file_with_additional_properties**](docs/FakeApi.md#upload_file_with_additional_properties) | **POST** /fake/upload_file_with_additional_properties | uploads a file and additional properties using multipart/form-data
*FakeClassnameTags123Api* | [**test_classname**](docs/FakeClassnameTags123Api.md#test_classname) | **PATCH** /fake_classname_test | To test class name in snake case
*ImportTestDatetimeApi* | [**import_test_return_datetime**](docs/ImportTestDatetimeApi.md#import_test_return_datetime) | **GET** /import_test/return_datetime | test date time
*PetApi* | [**add_pet**](docs/PetApi.md#add_pet) | **POST** /pet | Add a new pet to the store
*PetApi* | [**delete_pet**](docs/PetApi.md#delete_pet) | **DELETE** /pet/{petId} | Deletes a pet
*PetApi* | [**find_pets_by_status**](docs/PetApi.md#find_pets_by_status) | **GET** /pet/findByStatus | Finds Pets by status
*PetApi* | [**find_pets_by_tags**](docs/PetApi.md#find_pets_by_tags) | **GET** /pet/findByTags | Finds Pets by tags
*PetApi* | [**get_pet_by_id**](docs/PetApi.md#get_pet_by_id) | **GET** /pet/{petId} | Find pet by ID
*PetApi* | [**update_pet**](docs/PetApi.md#update_pet) | **PUT** /pet | Update an existing pet
*PetApi* | [**update_pet_with_form**](docs/PetApi.md#update_pet_with_form) | **POST** /pet/{petId} | Updates a pet in the store with form data
*PetApi* | [**upload_file**](docs/PetApi.md#upload_file) | **POST** /pet/{petId}/uploadImage | uploads an image
*PetApi* | [**upload_file_with_required_file**](docs/PetApi.md#upload_file_with_required_file) | **POST** /fake/{petId}/uploadImageWithRequiredFile | uploads an image (required)
*StoreApi* | [**delete_order**](docs/StoreApi.md#delete_order) | **DELETE** /store/order/{order_id} | Delete purchase order by ID
*StoreApi* | [**get_inventory**](docs/StoreApi.md#get_inventory) | **GET** /store/inventory | Returns pet inventories by status
*StoreApi* | [**get_order_by_id**](docs/StoreApi.md#get_order_by_id) | **GET** /store/order/{order_id} | Find purchase order by ID
*StoreApi* | [**place_order**](docs/StoreApi.md#place_order) | **POST** /store/order | Place an order for a pet
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /user | Create user
*UserApi* | [**create_users_with_array_input**](docs/UserApi.md#create_users_with_array_input) | **POST** /user/createWithArray | Creates list of users with given input array
*UserApi* | [**create_users_with_list_input**](docs/UserApi.md#create_users_with_list_input) | **POST** /user/createWithList | Creates list of users with given input array
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /user/{username} | Delete user
*UserApi* | [**get_user_by_name**](docs/UserApi.md#get_user_by_name) | **GET** /user/{username} | Get user by user name
*UserApi* | [**login_user**](docs/UserApi.md#login_user) | **GET** /user/login | Logs user into the system
*UserApi* | [**logout_user**](docs/UserApi.md#logout_user) | **GET** /user/logout | Logs out current logged in user session
*UserApi* | [**update_user**](docs/UserApi.md#update_user) | **PUT** /user/{username} | Updated user


## Documentation For Models

 - [AdditionalPropertiesAnyType](docs/AdditionalPropertiesAnyType.md)
 - [AdditionalPropertiesClass](docs/AdditionalPropertiesClass.md)
 - [AdditionalPropertiesObject](docs/AdditionalPropertiesObject.md)
 - [AdditionalPropertiesWithDescriptionOnly](docs/AdditionalPropertiesWithDescriptionOnly.md)
 - [AllOfSuperModel](docs/AllOfSuperModel.md)
 - [AllOfWithSingleRef](docs/AllOfWithSingleRef.md)
 - [Animal](docs/Animal.md)
 - [AnyOfColor](docs/AnyOfColor.md)
 - [AnyOfPig](docs/AnyOfPig.md)
 - [ArrayOfArrayOfModel](docs/ArrayOfArrayOfModel.md)
 - [ArrayOfArrayOfNumberOnly](docs/ArrayOfArrayOfNumberOnly.md)
 - [ArrayOfNumberOnly](docs/ArrayOfNumberOnly.md)
 - [ArrayTest](docs/ArrayTest.md)
 - [BaseDiscriminator](docs/BaseDiscriminator.md)
 - [BasquePig](docs/BasquePig.md)
 - [Bathing](docs/Bathing.md)
 - [Capitalization](docs/Capitalization.md)
 - [Cat](docs/Cat.md)
 - [Category](docs/Category.md)
 - [CircularAllOfRef](docs/CircularAllOfRef.md)
 - [CircularReferenceModel](docs/CircularReferenceModel.md)
 - [ClassModel](docs/ClassModel.md)
 - [Client](docs/Client.md)
 - [Color](docs/Color.md)
 - [Creature](docs/Creature.md)
 - [CreatureInfo](docs/CreatureInfo.md)
 - [DanishPig](docs/DanishPig.md)
 - [DataOutputFormat](docs/DataOutputFormat.md)
 - [DeprecatedObject](docs/DeprecatedObject.md)
 - [DiscriminatorAllOfSub](docs/DiscriminatorAllOfSub.md)
 - [DiscriminatorAllOfSuper](docs/DiscriminatorAllOfSuper.md)
 - [Dog](docs/Dog.md)
 - [DummyModel](docs/DummyModel.md)
 - [EnumArrays](docs/EnumArrays.md)
 - [EnumClass](docs/EnumClass.md)
 - [EnumNumberVendorExt](docs/EnumNumberVendorExt.md)
 - [EnumRefWithDefaultValue](docs/EnumRefWithDefaultValue.md)
 - [EnumString1](docs/EnumString1.md)
 - [EnumString2](docs/EnumString2.md)
 - [EnumStringVendorExt](docs/EnumStringVendorExt.md)
 - [EnumTest](docs/EnumTest.md)
 - [Feeding](docs/Feeding.md)
 - [File](docs/File.md)
 - [FileSchemaTestClass](docs/FileSchemaTestClass.md)
 - [FirstRef](docs/FirstRef.md)
 - [Foo](docs/Foo.md)
 - [FooGetDefaultResponse](docs/FooGetDefaultResponse.md)
 - [FormatTest](docs/FormatTest.md)
 - [HasOnlyReadOnly](docs/HasOnlyReadOnly.md)
 - [HealthCheckResult](docs/HealthCheckResult.md)
 - [HuntingDog](docs/HuntingDog.md)
 - [Info](docs/Info.md)
 - [InnerDictWithProperty](docs/InnerDictWithProperty.md)
 - [InputAllOf](docs/InputAllOf.md)
 - [IntOrString](docs/IntOrString.md)
 - [ListClass](docs/ListClass.md)
 - [MapOfArrayOfModel](docs/MapOfArrayOfModel.md)
 - [MapTest](docs/MapTest.md)
 - [MixedPropertiesAndAdditionalPropertiesClass](docs/MixedPropertiesAndAdditionalPropertiesClass.md)
 - [Model200Response](docs/Model200Response.md)
 - [ModelApiResponse](docs/ModelApiResponse.md)
 - [ModelField](docs/ModelField.md)
 - [ModelReturn](docs/ModelReturn.md)
 - [MultiArrays](docs/MultiArrays.md)
 - [Name](docs/Name.md)
 - [NullableClass](docs/NullableClass.md)
 - [NullableProperty](docs/NullableProperty.md)
 - [NumberOnly](docs/NumberOnly.md)
 - [ObjectToTestAdditionalProperties](docs/ObjectToTestAdditionalProperties.md)
 - [ObjectWithDeprecatedFields](docs/ObjectWithDeprecatedFields.md)
 - [OneOfEnumString](docs/OneOfEnumString.md)
 - [Order](docs/Order.md)
 - [OuterComposite](docs/OuterComposite.md)
 - [OuterEnum](docs/OuterEnum.md)
 - [OuterEnumDefaultValue](docs/OuterEnumDefaultValue.md)
 - [OuterEnumInteger](docs/OuterEnumInteger.md)
 - [OuterEnumIntegerDefaultValue](docs/OuterEnumIntegerDefaultValue.md)
 - [OuterObjectWithEnumProperty](docs/OuterObjectWithEnumProperty.md)
 - [Parent](docs/Parent.md)
 - [ParentWithOptionalDict](docs/ParentWithOptionalDict.md)
 - [Pet](docs/Pet.md)
 - [Pig](docs/Pig.md)
 - [PonySizes](docs/PonySizes.md)
 - [PoopCleaning](docs/PoopCleaning.md)
 - [PrimitiveString](docs/PrimitiveString.md)
 - [PropertyMap](docs/PropertyMap.md)
 - [PropertyNameCollision](docs/PropertyNameCollision.md)
 - [ReadOnlyFirst](docs/ReadOnlyFirst.md)
 - [SecondCircularAllOfRef](docs/SecondCircularAllOfRef.md)
 - [SecondRef](docs/SecondRef.md)
 - [SelfReferenceModel](docs/SelfReferenceModel.md)
 - [SingleRefType](docs/SingleRefType.md)
 - [SpecialCharacterEnum](docs/SpecialCharacterEnum.md)
 - [SpecialModelName](docs/SpecialModelName.md)
 - [SpecialName](docs/SpecialName.md)
 - [Tag](docs/Tag.md)
 - [Task](docs/Task.md)
 - [TaskActivity](docs/TaskActivity.md)
 - [TestEnum](docs/TestEnum.md)
 - [TestEnumWithDefault](docs/TestEnumWithDefault.md)
 - [TestErrorResponsesWithModel400Response](docs/TestErrorResponsesWithModel400Response.md)
 - [TestErrorResponsesWithModel404Response](docs/TestErrorResponsesWithModel404Response.md)
 - [TestInlineFreeformAdditionalPropertiesRequest](docs/TestInlineFreeformAdditionalPropertiesRequest.md)
 - [TestModelWithEnumDefault](docs/TestModelWithEnumDefault.md)
 - [TestObjectForMultipartRequestsRequestMarker](docs/TestObjectForMultipartRequestsRequestMarker.md)
 - [Tiger](docs/Tiger.md)
 - [Type](docs/Type.md)
 - [UnnamedDictWithAdditionalModelListProperties](docs/UnnamedDictWithAdditionalModelListProperties.md)
 - [UnnamedDictWithAdditionalStringListProperties](docs/UnnamedDictWithAdditionalStringListProperties.md)
 - [UploadFileWithAdditionalPropertiesRequestObject](docs/UploadFileWithAdditionalPropertiesRequestObject.md)
 - [User](docs/User.md)
 - [WithNestedOneOf](docs/WithNestedOneOf.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="petstore_auth"></a>
### petstore_auth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: http://petstore.swagger.io/api/oauth/dialog
- **Scopes**: 
 - **write:pets**: modify pets in your account
 - **read:pets**: read your pets

<a id="api_key"></a>
### api_key

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: HTTP header

<a id="api_key_query"></a>
### api_key_query

- **Type**: API key
- **API key parameter name**: api_key_query
- **Location**: URL query string

<a id="http_basic_test"></a>
### http_basic_test

- **Type**: HTTP basic authentication

<a id="bearer_test"></a>
### bearer_test

- **Type**: Bearer authentication (JWT)

<a id="http_signature_test"></a>
### http_signature_test

- **Type**: HTTP signature authentication


## Author




