// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

/*
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * API version: 1.0.0
 */

package petstoreserver

import (
	"net/http"
	"github.com/go-chi/chi/v5"
)

// A Route defines the parameters for an api endpoint
type Route struct {
	Name        string
	Method	    string
	Pattern	    string
	HandlerFunc http.HandlerFunc
}

// Routes is a map of defined api endpoints
type Routes map[string]Route

// Router defines the required methods for retrieving api routes
type Router interface {
	Routes() Routes
	OrderedRoutes() []Route
}

// NewRouter creates a new router for any number of api routers
func NewRouter(routers ...Router) chi.Router {
	router := chi.NewRouter()
	router.Use(Logger)
	for _, api := range routers {
		for _, route := range api.OrderedRoutes() {
			var handler http.Handler = route.HandlerFunc
			router.Method(route.Method, route.Pattern, handler)
		}
	}

	return router
}
