/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/

/*
* PetApiController.hpp
*
* 
*/

#ifndef PET_API_IMPL_H_
#define PET_API_IMPL_H_


#include <PetApi.hpp>
#include "oatpp/core/Types.hpp"


#include "ApiResponse.hpp"
#include "Pet.hpp"

namespace org::openapitools::server::api
{

class  PetApiController : public PetApi {
public:
    /// <summary>
    /// Add a new pet to the store
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="pet">Pet object that needs to be added to the store</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> add_pet(const std::shared_ptr<IncomingRequest> &request, const oatpp::Object<org::openapitools::server::model::Pet> &pet);
    /// <summary>
    /// Deletes a pet
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="petId">Pet id to delete</param>
    /// <param name="apiKey"> (optional, default to &quot;&quot;)</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> delete_pet(const std::shared_ptr<IncomingRequest> &request, const oatpp::Int64 &petId, const oatpp::String &apiKey);
    /// <summary>
    /// Finds Pets by status
    /// </summary>
    /// <remarks>
    /// Multiple status values can be provided with comma separated strings
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="status">Status values that need to be considered for filter</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> find_pets_by_status(const std::shared_ptr<IncomingRequest> &request, const oatpp::Vector<oatpp::String> &status);
    /// <summary>
    /// Finds Pets by tags
    /// </summary>
    /// <remarks>
    /// Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="tags">Tags to filter by</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> find_pets_by_tags(const std::shared_ptr<IncomingRequest> &request, const oatpp::Vector<oatpp::String> &tags);
    /// <summary>
    /// Find pet by ID
    /// </summary>
    /// <remarks>
    /// Returns a single pet
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="petId">ID of pet to return</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> get_pet_by_id(const std::shared_ptr<IncomingRequest> &request, const oatpp::Int64 &petId);
    /// <summary>
    /// Update an existing pet
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="pet">Pet object that needs to be added to the store</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> update_pet(const std::shared_ptr<IncomingRequest> &request, const oatpp::Object<org::openapitools::server::model::Pet> &pet);
    /// <summary>
    /// Updates a pet in the store with form data
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="petId">ID of pet that needs to be updated</param>
    
    
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> update_pet_with_form(const std::shared_ptr<IncomingRequest> &request, const oatpp::Int64 &petId);
    /// <summary>
    /// uploads an image
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="petId">ID of pet to update</param>
    
    
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> upload_file(const std::shared_ptr<IncomingRequest> &request, const oatpp::Int64 &petId);
};

} // namespace org::openapitools::server::api



#endif
