/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/

/*
* UserApiController.hpp
*
* 
*/

#ifndef USER_API_IMPL_H_
#define USER_API_IMPL_H_


#include <UserApi.hpp>
#include "oatpp/core/Types.hpp"


#include "User.hpp"

namespace org::openapitools::server::api
{

class  UserApiController : public UserApi {
public:
    /// <summary>
    /// Create user
    /// </summary>
    /// <remarks>
    /// This can only be done by the logged in user.
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="user">Created user object</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> create_user(const std::shared_ptr<IncomingRequest> &request, const oatpp::Object<org::openapitools::server::model::User> &user);
    /// <summary>
    /// Creates list of users with given input array
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="user">List of user object</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> create_users_with_array_input(const std::shared_ptr<IncomingRequest> &request, const oatpp::Vector<oatpp::Object<org::openapitools::server::model::User>> &user);
    /// <summary>
    /// Creates list of users with given input array
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="user">List of user object</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> create_users_with_list_input(const std::shared_ptr<IncomingRequest> &request, const oatpp::Vector<oatpp::Object<org::openapitools::server::model::User>> &user);
    /// <summary>
    /// Delete user
    /// </summary>
    /// <remarks>
    /// This can only be done by the logged in user.
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="username">The name that needs to be deleted</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> delete_user(const std::shared_ptr<IncomingRequest> &request, const oatpp::String &username);
    /// <summary>
    /// Get user by user name
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="username">The name that needs to be fetched. Use user1 for testing.</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> get_user_by_name(const std::shared_ptr<IncomingRequest> &request, const oatpp::String &username);
    /// <summary>
    /// Logs user into the system
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="username">The user name for login</param>
    /// <param name="password">The password for login in clear text</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> login_user(const std::shared_ptr<IncomingRequest> &request, const oatpp::String &username, const oatpp::String &password);
    /// <summary>
    /// Logs out current logged in user session
    /// </summary>
    /// <remarks>
    /// 
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> logout_user(const std::shared_ptr<IncomingRequest> &request);
    /// <summary>
    /// Updated user
    /// </summary>
    /// <remarks>
    /// This can only be done by the logged in user.
    /// </remarks>
    /// <param name="request">HTTP Request</param>
    /// <param name="username">name that need to be deleted</param>
    /// <param name="user">Updated user object</param>
    virtual std::shared_ptr<oatpp::web::protocol::http::outgoing::Response> update_user(const std::shared_ptr<IncomingRequest> &request, const oatpp::String &username, const oatpp::Object<org::openapitools::server::model::User> &user);
};

} // namespace org::openapitools::server::api



#endif
