/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI-Generator unset.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


#include <corvusoft/restbed/byte.hpp>
#include <corvusoft/restbed/string.hpp>
#include <corvusoft/restbed/settings.hpp>
#include <corvusoft/restbed/request.hpp>
#include <corvusoft/restbed/uri.hpp>
#include <boost/property_tree/ptree.hpp>
#include <boost/property_tree/json_parser.hpp>
#include <boost/lexical_cast.hpp>
#include <boost/algorithm/string.hpp>

#include "PetApi.h"

namespace org {
namespace openapitools {
namespace server {
namespace api {

using namespace org::openapitools::server::model;

PetApiException::PetApiException(int status_code, std::string what)
  : m_status(status_code),
    m_what(what)
{

}
int PetApiException::getStatus() const
{
    return m_status;
}
const char* PetApiException::what() const noexcept
{
    return m_what.c_str();
}


template<class MODEL_T>
std::shared_ptr<MODEL_T> extractJsonModelBodyParam(const std::string& bodyContent)
{
    std::stringstream sstream(bodyContent);
    boost::property_tree::ptree pt;
    boost::property_tree::json_parser::read_json(sstream, pt);

    auto model = std::make_shared<MODEL_T>(pt);
    return model;
}

template<class MODEL_T>
std::vector<std::shared_ptr<MODEL_T>> extractJsonArrayBodyParam(const std::string& bodyContent)
{
    std::stringstream sstream(bodyContent);
    boost::property_tree::ptree pt;
    boost::property_tree::json_parser::read_json(sstream, pt);

    auto arrayRet = std::vector<std::shared_ptr<MODEL_T>>();
    for (const auto& child: pt) {
        arrayRet.emplace_back(std::make_shared<MODEL_T>(child.second));
    }
    return arrayRet;
}

template <class KEY_T, class VAL_T>
std::string convertMapResponse(const std::map<KEY_T, VAL_T>& map)
{
    boost::property_tree::ptree pt;
    for(const auto &kv: map) {
    pt.push_back(boost::property_tree::ptree::value_type(
        boost::lexical_cast<std::string>(kv.first),
        boost::property_tree::ptree(
        boost::lexical_cast<std::string>(kv.second))));
    }
    std::stringstream sstream;
    write_json(sstream, pt);
    std::string result = sstream.str();
    return result;
}

PetApiPetResource::PetApiPetResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/pet/");
	this->set_method_handler("POST",
		std::bind(&PetApiPetResource::handler_POST_internal, this,
			std::placeholders::_1));
	this->set_method_handler("PUT",
		std::bind(&PetApiPetResource::handler_PUT_internal, this,
			std::placeholders::_1));
}

PetApiPetResource::~PetApiPetResource()
{
}

std::pair<int, std::string> PetApiPetResource::handlePetApiException(const PetApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> PetApiPetResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> PetApiPetResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void PetApiPetResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void PetApiPetResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, const std::string& contentType)
{
    session->close(status, result, { {"Connection", "close"}, {"Content-Type", contentType} });
}

void PetApiPetResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void PetApiPetResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();
    std::string bodyContent = extractBodyContent(session);

    // Get body params or form params here from the body content string
    auto pet = extractJsonModelBodyParam<Pet>(bodyContent);




    int status_code = 500;
    std::shared_ptr<Pet> resultObject = std::make_shared<Pet>();
    std::string result = "";

    try {
        std::tie(status_code, resultObject) =
             handler_POST(pet);
    }
    catch(const PetApiException& e) {
        std::tie(status_code, result) = handlePetApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 200) {
        result = resultObject->toJsonString();

        const constexpr auto contentType = "application/json";
        returnResponse(session, 200, result.empty() ? "successful operation" : result, contentType);
        return;
    }
    if (status_code == 405) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 405, result.empty() ? "Invalid input" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}

// x-extension
void PetApiPetResource::handler_PUT_internal(const std::shared_ptr<restbed::Session> session) {

    const auto request = session->get_request();
    std::string bodyContent = extractBodyContent(session);

    // body params or form params here from the body content string
    auto pet = extractJsonModelBodyParam<Pet>(bodyContent);


    int status_code = 500;
    std::shared_ptr<Pet> resultObject = std::make_shared<Pet>();
    std::string result = "";

    try {
        std::tie(status_code, resultObject) =
            handler_PUT(pet);
    }
    catch(const PetApiException& e) {
        std::tie(status_code, result) = handlePetApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 200) {
        result = resultObject->toJsonString();

        const constexpr auto contentType = "application/json";
        returnResponse(session, 200, result.empty() ? "successful operation" : result, contentType);
        return;
    }
    if (status_code == 400) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 400, result.empty() ? "Invalid ID supplied" : result, contentType);
        return;
    }
    if (status_code == 404) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 404, result.empty() ? "Pet not found" : result, contentType);
        return;
    }
    if (status_code == 405) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 405, result.empty() ? "Validation exception" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}

std::pair<int, std::shared_ptr<Pet>> PetApiPetResource::handler_POST(
        std::shared_ptr<Pet> const & pet)
{
    throw PetApiException(501, "Not implemented");
}

std::pair<int, std::shared_ptr<Pet>> PetApiPetResource::handler_PUT(
    std::shared_ptr<Pet> const & pet)
{
    throw PetApiException(501, "Not implemented");
}

std::string PetApiPetResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}
PetApiPetPetIdResource::PetApiPetPetIdResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/pet/{petId: .*}/");
	this->set_method_handler("DELETE",
		std::bind(&PetApiPetPetIdResource::handler_DELETE_internal, this,
			std::placeholders::_1));
	this->set_method_handler("GET",
		std::bind(&PetApiPetPetIdResource::handler_GET_internal, this,
			std::placeholders::_1));
	this->set_method_handler("POST",
		std::bind(&PetApiPetPetIdResource::handler_POST_internal, this,
			std::placeholders::_1));
}

PetApiPetPetIdResource::~PetApiPetPetIdResource()
{
}

std::pair<int, std::string> PetApiPetPetIdResource::handlePetApiException(const PetApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> PetApiPetPetIdResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> PetApiPetPetIdResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void PetApiPetPetIdResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void PetApiPetPetIdResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, const std::string& contentType)
{
    session->close(status, result, { {"Connection", "close"}, {"Content-Type", contentType} });
}

void PetApiPetPetIdResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void PetApiPetPetIdResource::handler_DELETE_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();

    // Getting the path params
    const int64_t petId = getPathParam_petId(request);


    // Getting the headers
    const std::string apiKey = getHeader_api_key(request);

    int status_code = 500;
    std::string result = "";

    try {
         status_code =
             handler_DELETE(petId, apiKey);
    }
    catch(const PetApiException& e) {
        std::tie(status_code, result) = handlePetApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 400) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 400, result.empty() ? "Invalid pet value" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}

// x-extension
void PetApiPetPetIdResource::handler_GET_internal(const std::shared_ptr<restbed::Session> session) {

    const auto request = session->get_request();

    // Getting the path params
    const int64_t petId = getPathParam_petId_x_extension(request);


    int status_code = 500;
    std::shared_ptr<Pet> resultObject = std::make_shared<Pet>();
    std::string result = "";

    try {
        std::tie(status_code, resultObject) =
            handler_GET(petId);
    }
    catch(const PetApiException& e) {
        std::tie(status_code, result) = handlePetApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 200) {
        result = resultObject->toJsonString();

        const constexpr auto contentType = "application/json";
        returnResponse(session, 200, result.empty() ? "successful operation" : result, contentType);
        return;
    }
    if (status_code == 400) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 400, result.empty() ? "Invalid ID supplied" : result, contentType);
        return;
    }
    if (status_code == 404) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 404, result.empty() ? "Pet not found" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}
// x-extension
void PetApiPetPetIdResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session) {

    const auto request = session->get_request();

    // Getting the path params
    const int64_t petId = getPathParam_petId_x_extension(request);


    int status_code = 500;
    std::string result = "";

    try {
        status_code =
            handler_POST(petId, name, status);
    }
    catch(const PetApiException& e) {
        std::tie(status_code, result) = handlePetApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 405) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 405, result.empty() ? "Invalid input" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}

int PetApiPetPetIdResource::handler_DELETE(
        int64_t const & petId, std::string const & apiKey)
{
    throw PetApiException(501, "Not implemented");
}

std::pair<int, std::shared_ptr<Pet>> PetApiPetPetIdResource::handler_GET(
    int64_t const & petId)
{
    throw PetApiException(501, "Not implemented");
}
int PetApiPetPetIdResource::handler_POST(
    int64_t const & petId, std::string const & name, std::string const & status)
{
    throw PetApiException(501, "Not implemented");
}

std::string PetApiPetPetIdResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}
PetApiPetFindByStatusResource::PetApiPetFindByStatusResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/pet/findByStatus/");
	this->set_method_handler("GET",
		std::bind(&PetApiPetFindByStatusResource::handler_GET_internal, this,
			std::placeholders::_1));
}

PetApiPetFindByStatusResource::~PetApiPetFindByStatusResource()
{
}

std::pair<int, std::string> PetApiPetFindByStatusResource::handlePetApiException(const PetApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> PetApiPetFindByStatusResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> PetApiPetFindByStatusResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void PetApiPetFindByStatusResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void PetApiPetFindByStatusResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, const std::string& contentType)
{
    session->close(status, result, { {"Connection", "close"}, {"Content-Type", contentType} });
}

void PetApiPetFindByStatusResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void PetApiPetFindByStatusResource::handler_GET_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();


    // Getting the query params


    int status_code = 500;
    std::vector<std::shared_ptr<Pet>> resultObject = std::vector<std::shared_ptr<Pet>>();
    std::string result = "";

    try {
        std::tie(status_code, resultObject) =
             handler_GET(status);
    }
    catch(const PetApiException& e) {
        std::tie(status_code, result) = handlePetApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 200) {

        const constexpr auto contentType = "application/json";
        returnResponse(session, 200, result.empty() ? "successful operation" : result, contentType);
        return;
    }
    if (status_code == 400) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 400, result.empty() ? "Invalid status value" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}


std::pair<int, std::vector<std::shared_ptr<Pet>>> PetApiPetFindByStatusResource::handler_GET(
        std::vector<std::string> const & status)
{
    throw PetApiException(501, "Not implemented");
}


std::string PetApiPetFindByStatusResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}
PetApiPetFindByTagsResource::PetApiPetFindByTagsResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/pet/findByTags/");
	this->set_method_handler("GET",
		std::bind(&PetApiPetFindByTagsResource::handler_GET_internal, this,
			std::placeholders::_1));
}

PetApiPetFindByTagsResource::~PetApiPetFindByTagsResource()
{
}

std::pair<int, std::string> PetApiPetFindByTagsResource::handlePetApiException(const PetApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> PetApiPetFindByTagsResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> PetApiPetFindByTagsResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void PetApiPetFindByTagsResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void PetApiPetFindByTagsResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, const std::string& contentType)
{
    session->close(status, result, { {"Connection", "close"}, {"Content-Type", contentType} });
}

void PetApiPetFindByTagsResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void PetApiPetFindByTagsResource::handler_GET_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();


    // Getting the query params


    int status_code = 500;
    std::vector<std::shared_ptr<Pet>> resultObject = std::vector<std::shared_ptr<Pet>>();
    std::string result = "";

    try {
        std::tie(status_code, resultObject) =
             handler_GET(tags);
    }
    catch(const PetApiException& e) {
        std::tie(status_code, result) = handlePetApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 200) {

        const constexpr auto contentType = "application/json";
        returnResponse(session, 200, result.empty() ? "successful operation" : result, contentType);
        return;
    }
    if (status_code == 400) {

        const constexpr auto contentType = "text/plain";
        returnResponse(session, 400, result.empty() ? "Invalid tag value" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}


std::pair<int, std::vector<std::shared_ptr<Pet>>> PetApiPetFindByTagsResource::handler_GET(
        std::vector<std::string> const & tags)
{
    throw PetApiException(501, "Not implemented");
}


std::string PetApiPetFindByTagsResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}
PetApiPetPetIdUploadImageResource::PetApiPetPetIdUploadImageResource(const std::string& context /* = "/v2" */)
{
	this->set_path(context + "/pet/{petId: .*}/uploadImage/");
	this->set_method_handler("POST",
		std::bind(&PetApiPetPetIdUploadImageResource::handler_POST_internal, this,
			std::placeholders::_1));
}

PetApiPetPetIdUploadImageResource::~PetApiPetPetIdUploadImageResource()
{
}

std::pair<int, std::string> PetApiPetPetIdUploadImageResource::handlePetApiException(const PetApiException& e)
{
    return std::make_pair<int, std::string>(e.getStatus(), e.what());
}

std::pair<int, std::string> PetApiPetPetIdUploadImageResource::handleStdException(const std::exception& e)
{
    return std::make_pair<int, std::string>(500, e.what());
}

std::pair<int, std::string> PetApiPetPetIdUploadImageResource::handleUnspecifiedException()
{
    return std::make_pair<int, std::string>(500, "Unknown exception occurred");
}

void PetApiPetPetIdUploadImageResource::setResponseHeader(const std::shared_ptr<restbed::Session>& session, const std::string& header)
{
    session->set_header(header, "");
}

void PetApiPetPetIdUploadImageResource::returnResponse(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result, const std::string& contentType)
{
    session->close(status, result, { {"Connection", "close"}, {"Content-Type", contentType} });
}

void PetApiPetPetIdUploadImageResource::defaultSessionClose(const std::shared_ptr<restbed::Session>& session, const int status, const std::string& result)
{
    session->close(status, result, { {"Connection", "close"} });
}

void PetApiPetPetIdUploadImageResource::handler_POST_internal(const std::shared_ptr<restbed::Session> session)
{
    const auto request = session->get_request();

    // Getting the path params
    const int64_t petId = getPathParam_petId(request);



    int status_code = 500;
    std::shared_ptr<ApiResponse> resultObject = std::make_shared<ApiResponse>();
    std::string result = "";

    try {
        std::tie(status_code, resultObject) =
             handler_POST(petId, additionalMetadata, file);
    }
    catch(const PetApiException& e) {
        std::tie(status_code, result) = handlePetApiException(e);
    }
    catch(const std::exception& e) {
        std::tie(status_code, result) = handleStdException(e);
    }
    catch(...) {
        std::tie(status_code, result) = handleUnspecifiedException();
    }

    if (status_code == 200) {
        result = resultObject->toJsonString();

        const constexpr auto contentType = "application/json";
        returnResponse(session, 200, result.empty() ? "successful operation" : result, contentType);
        return;
    }
    defaultSessionClose(session, status_code, result);
}


std::pair<int, std::shared_ptr<ApiResponse>> PetApiPetPetIdUploadImageResource::handler_POST(
        int64_t const & petId, std::string const & additionalMetadata, std::string const & file)
{
    throw PetApiException(501, "Not implemented");
}


std::string PetApiPetPetIdUploadImageResource::extractBodyContent(const std::shared_ptr<restbed::Session>& session) {
  const auto request = session->get_request();
  int content_length = request->get_header("Content-Length", 0);
  std::string bodyContent;
  session->fetch(content_length,
                 [&bodyContent](const std::shared_ptr<restbed::Session> session,
                                const restbed::Bytes &body) {
                   bodyContent = restbed::String::format(
                       "%.*s\n", (int)body.size(), body.data());
                 });
  return bodyContent;
}

PetApi::PetApi(std::shared_ptr<restbed::Service> const& restbedService)
: m_service(restbedService)
{
}

PetApi::~PetApi() {}

void PetApi::setPetApiPetResource(std::shared_ptr<PetApiPetResource> spPetApiPetResource) {
    m_spPetApiPetResource = spPetApiPetResource;
    m_service->publish(m_spPetApiPetResource);
}
void PetApi::setPetApiPetPetIdResource(std::shared_ptr<PetApiPetPetIdResource> spPetApiPetPetIdResource) {
    m_spPetApiPetPetIdResource = spPetApiPetPetIdResource;
    m_service->publish(m_spPetApiPetPetIdResource);
}
void PetApi::setPetApiPetFindByStatusResource(std::shared_ptr<PetApiPetFindByStatusResource> spPetApiPetFindByStatusResource) {
    m_spPetApiPetFindByStatusResource = spPetApiPetFindByStatusResource;
    m_service->publish(m_spPetApiPetFindByStatusResource);
}
void PetApi::setPetApiPetFindByTagsResource(std::shared_ptr<PetApiPetFindByTagsResource> spPetApiPetFindByTagsResource) {
    m_spPetApiPetFindByTagsResource = spPetApiPetFindByTagsResource;
    m_service->publish(m_spPetApiPetFindByTagsResource);
}
void PetApi::setPetApiPetPetIdUploadImageResource(std::shared_ptr<PetApiPetPetIdUploadImageResource> spPetApiPetPetIdUploadImageResource) {
    m_spPetApiPetPetIdUploadImageResource = spPetApiPetPetIdUploadImageResource;
    m_service->publish(m_spPetApiPetPetIdUploadImageResource);
}


void PetApi::publishDefaultResources() {
    if (!m_spPetApiPetResource) {
        setPetApiPetResource(std::make_shared<PetApiPetResource>());
    }
    if (!m_spPetApiPetPetIdResource) {
        setPetApiPetPetIdResource(std::make_shared<PetApiPetPetIdResource>());
    }
    if (!m_spPetApiPetFindByStatusResource) {
        setPetApiPetFindByStatusResource(std::make_shared<PetApiPetFindByStatusResource>());
    }
    if (!m_spPetApiPetFindByTagsResource) {
        setPetApiPetFindByTagsResource(std::make_shared<PetApiPetFindByTagsResource>());
    }
    if (!m_spPetApiPetPetIdUploadImageResource) {
        setPetApiPetPetIdUploadImageResource(std::make_shared<PetApiPetPetIdUploadImageResource>());
    }
}

std::shared_ptr<restbed::Service> PetApi::service() {
    return m_service;
}


}
}
}
}

