/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI-Generator unset.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/*
 * UserApi.h
 *
 * 
 */

#ifndef UserApi_H_
#define UserApi_H_


#include <memory>
#include <utility>
#include <exception>

#include <corvusoft/restbed/session.hpp>
#include <corvusoft/restbed/resource.hpp>
#include <corvusoft/restbed/request.hpp>
#include <corvusoft/restbed/service.hpp>
#include <corvusoft/restbed/settings.hpp>

#include "User.h"
#include <string>
#include <vector>

namespace org {
namespace openapitools {
namespace server {
namespace api {

using namespace org::openapitools::server::model;

///
/// Exception to flag problems in the handlers
///
class  UserApiException: public std::exception
{
public:
    UserApiException(int status_code, std::string what);

    int getStatus() const;
    const char* what() const noexcept override;

private:
    int m_status;
    std::string m_what;
};

/// <summary>
/// Create user
/// </summary>
/// <remarks>
/// This can only be done by the logged in user.
/// </remarks>
class  UserApiUserResource: public restbed::Resource
{
public:
    UserApiUserResource(const std::string& context = "/v2");
    virtual ~UserApiUserResource();

protected:
    //////////////////////////////////////////////////////////
    // Override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_POST(
        std::shared_ptr<User> const & user);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);



    virtual std::pair<int, std::string> handleUserApiException(const UserApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);


    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, const std::string& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};


/// <summary>
/// Creates list of users with given input array
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  UserApiUserCreateWithArrayResource: public restbed::Resource
{
public:
    UserApiUserCreateWithArrayResource(const std::string& context = "/v2");
    virtual ~UserApiUserCreateWithArrayResource();

protected:
    //////////////////////////////////////////////////////////
    // Override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_POST(
        std::vector<std::shared_ptr<User>> const & user);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);



    virtual std::pair<int, std::string> handleUserApiException(const UserApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);


    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, const std::string& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};


/// <summary>
/// Creates list of users with given input array
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  UserApiUserCreateWithListResource: public restbed::Resource
{
public:
    UserApiUserCreateWithListResource(const std::string& context = "/v2");
    virtual ~UserApiUserCreateWithListResource();

protected:
    //////////////////////////////////////////////////////////
    // Override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_POST(
        std::vector<std::shared_ptr<User>> const & user);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);



    virtual std::pair<int, std::string> handleUserApiException(const UserApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);


    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, const std::string& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};


/// <summary>
/// Delete user
/// </summary>
/// <remarks>
/// This can only be done by the logged in user.
/// </remarks>
class  UserApiUserUsernameResource: public restbed::Resource
{
public:
    UserApiUserUsernameResource(const std::string& context = "/v2");
    virtual ~UserApiUserUsernameResource();

protected:
    //////////////////////////////////////////////////////////
    // Override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_DELETE(
        std::string const & username);

    virtual std::pair<int, std::shared_ptr<User>> handler_GET(
        std::string const & username);
    virtual int handler_PUT(
        std::string const & username, std::shared_ptr<User> const & user);

protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);

    virtual std::string getPathParam_username(const std::shared_ptr<const restbed::Request>& request)
    {
        return request->get_path_parameter("username", "");
    }


    virtual std::string getPathParam_username_x_extension(const std::shared_ptr<const restbed::Request>& request)
    {
        return request->get_path_parameter("username", "");
    }
    virtual std::string getPathParam_username_x_extension(const std::shared_ptr<const restbed::Request>& request)
    {
        return request->get_path_parameter("username", "");
    }

    virtual std::pair<int, std::string> handleUserApiException(const UserApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);


    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, const std::string& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_DELETE_internal(const std::shared_ptr<restbed::Session> session);
    void handler_GET_internal(const std::shared_ptr<restbed::Session> session);
    void handler_PUT_internal(const std::shared_ptr<restbed::Session> session);
};


/// <summary>
/// Logs user into the system
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  UserApiUserLoginResource: public restbed::Resource
{
public:
    UserApiUserLoginResource(const std::string& context = "/v2");
    virtual ~UserApiUserLoginResource();

protected:
    //////////////////////////////////////////////////////////
    // Override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, std::string> handler_GET(
        std::string const & username, std::string const & password);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);

    virtual std::string getQueryParam_username(const std::shared_ptr<const restbed::Request>& request)
    {
        return request->get_query_parameter("username", "");
    }

    virtual std::string getQueryParam_password(const std::shared_ptr<const restbed::Request>& request)
    {
        return request->get_query_parameter("password", "");
    }



    virtual std::pair<int, std::string> handleUserApiException(const UserApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);


    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, const std::string& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_GET_internal(const std::shared_ptr<restbed::Session> session);
};


/// <summary>
/// Logs out current logged in user session
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  UserApiUserLogoutResource: public restbed::Resource
{
public:
    UserApiUserLogoutResource(const std::string& context = "/v2");
    virtual ~UserApiUserLogoutResource();

protected:
    //////////////////////////////////////////////////////////
    // Override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_GET(
        );


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);



    virtual std::pair<int, std::string> handleUserApiException(const UserApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);


    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, const std::string& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_GET_internal(const std::shared_ptr<restbed::Session> session);
};



//
// The restbed service to actually implement the REST server
//
class  UserApi
{
public:
    explicit UserApi(std::shared_ptr<restbed::Service> const& restbedService);
	virtual ~UserApi();

    virtual void setUserApiUserResource(std::shared_ptr<UserApiUserResource> spUserApiUserResource);
    virtual void setUserApiUserCreateWithArrayResource(std::shared_ptr<UserApiUserCreateWithArrayResource> spUserApiUserCreateWithArrayResource);
    virtual void setUserApiUserCreateWithListResource(std::shared_ptr<UserApiUserCreateWithListResource> spUserApiUserCreateWithListResource);
    virtual void setUserApiUserUsernameResource(std::shared_ptr<UserApiUserUsernameResource> spUserApiUserUsernameResource);
    virtual void setUserApiUserLoginResource(std::shared_ptr<UserApiUserLoginResource> spUserApiUserLoginResource);
    virtual void setUserApiUserLogoutResource(std::shared_ptr<UserApiUserLogoutResource> spUserApiUserLogoutResource);

    virtual void publishDefaultResources();

    virtual std::shared_ptr<restbed::Service> service();

protected:
	std::shared_ptr<UserApiUserResource> m_spUserApiUserResource;
	std::shared_ptr<UserApiUserCreateWithArrayResource> m_spUserApiUserCreateWithArrayResource;
	std::shared_ptr<UserApiUserCreateWithListResource> m_spUserApiUserCreateWithListResource;
	std::shared_ptr<UserApiUserUsernameResource> m_spUserApiUserUsernameResource;
	std::shared_ptr<UserApiUserLoginResource> m_spUserApiUserLoginResource;
	std::shared_ptr<UserApiUserLogoutResource> m_spUserApiUserLogoutResource;

private:
    std::shared_ptr<restbed::Service> m_service;
};


}
}
}
}

#endif /* UserApi_H_ */

