/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 7.20.0-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/*
 * FakeApi.h
 *
 * 
 */

#ifndef FakeApi_H_
#define FakeApi_H_


#include <memory>
#include <utility>
#include <exception>
#include <functional>

#include <corvusoft/restbed/session.hpp>
#include <corvusoft/restbed/resource.hpp>
#include <corvusoft/restbed/request.hpp>
#include <corvusoft/restbed/service.hpp>
#include <corvusoft/restbed/settings.hpp>

#include "AnyType.h"
#include "ChildWithNullable.h"
#include "Client.h"
#include "EnumClass.h"
#include "FakeBigDecimalMap_200_response.h"
#include "FileSchemaTestClass.h"
#include "HealthCheckResult.h"
#include "OuterComposite.h"
#include "OuterObjectWithEnumProperty.h"
#include "Pet.h"
#include "TestInlineFreeformAdditionalProperties_request.h"
#include "User.h"
#include <map>
#include <string>
#include <vector>

namespace org {
namespace openapitools {
namespace server {
namespace api {

using namespace org::openapitools::server::model;

///
/// Exception to flag problems in the handlers
///
class  FakeApiException: public std::exception
{
public:
    FakeApiException(int status_code, std::string what);

    int getStatus() const;
    const char* what() const noexcept override;

private:
    int m_status;
    std::string m_what;
};

namespace FakeApiResources {
/// <summary>
/// 
/// </summary>
/// <remarks>
/// for Java apache and Java native, test toUrlQueryString for maps with BegDecimal keys
/// </remarks>
class  FakeBigDecimalMapResource: public restbed::Resource
{
public:
    FakeBigDecimalMapResource(const std::string& context = "/v2");
    virtual ~FakeBigDecimalMapResource() = default;

    FakeBigDecimalMapResource(
        const FakeBigDecimalMapResource& other) = default; // copy constructor
    FakeBigDecimalMapResource(FakeBigDecimalMapResource&& other) noexcept = default; // move constructor

    FakeBigDecimalMapResource& operator=(const FakeBigDecimalMapResource& other) = default; // copy assignment
    FakeBigDecimalMapResource& operator=(FakeBigDecimalMapResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<std::pair<int, FakeBigDecimalMap_200_response>(
        )> handler_GET_func =
            []() -> std::pair<int, FakeBigDecimalMap_200_response>
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, FakeBigDecimalMap_200_response> handler_GET(
        );


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_GET_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// Health check endpoint
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  FakeHealthResource: public restbed::Resource
{
public:
    FakeHealthResource(const std::string& context = "/v2");
    virtual ~FakeHealthResource() = default;

    FakeHealthResource(
        const FakeHealthResource& other) = default; // copy constructor
    FakeHealthResource(FakeHealthResource&& other) noexcept = default; // move constructor

    FakeHealthResource& operator=(const FakeHealthResource& other) = default; // copy assignment
    FakeHealthResource& operator=(FakeHealthResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<std::pair<int, HealthCheckResult>(
        )> handler_GET_func =
            []() -> std::pair<int, HealthCheckResult>
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, HealthCheckResult> handler_GET(
        );


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_GET_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// test http signature authentication
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  FakeHttp_signature_testResource: public restbed::Resource
{
public:
    FakeHttp_signature_testResource(const std::string& context = "/v2");
    virtual ~FakeHttp_signature_testResource() = default;

    FakeHttp_signature_testResource(
        const FakeHttp_signature_testResource& other) = default; // copy constructor
    FakeHttp_signature_testResource(FakeHttp_signature_testResource&& other) noexcept = default; // move constructor

    FakeHttp_signature_testResource& operator=(const FakeHttp_signature_testResource& other) = default; // copy assignment
    FakeHttp_signature_testResource& operator=(FakeHttp_signature_testResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<int(
        Pet & pet, std::string & query1, std::string & header1)> handler_GET_func =
            [](Pet &, std::string &, std::string &) -> int
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_GET(
        Pet & pet, std::string & query1, std::string & header1);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_GET_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// 
/// </summary>
/// <remarks>
/// Test serialization of outer boolean types
/// </remarks>
class  FakeOuterBooleanResource: public restbed::Resource
{
public:
    FakeOuterBooleanResource(const std::string& context = "/v2");
    virtual ~FakeOuterBooleanResource() = default;

    FakeOuterBooleanResource(
        const FakeOuterBooleanResource& other) = default; // copy constructor
    FakeOuterBooleanResource(FakeOuterBooleanResource&& other) noexcept = default; // move constructor

    FakeOuterBooleanResource& operator=(const FakeOuterBooleanResource& other) = default; // copy assignment
    FakeOuterBooleanResource& operator=(FakeOuterBooleanResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<std::pair<int, bool>(
        bool & body)> handler_POST_func =
            [](bool &) -> std::pair<int, bool>
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, bool> handler_POST(
        bool & body);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// 
/// </summary>
/// <remarks>
/// Test serialization of object with outer number type
/// </remarks>
class  FakeOuterCompositeResource: public restbed::Resource
{
public:
    FakeOuterCompositeResource(const std::string& context = "/v2");
    virtual ~FakeOuterCompositeResource() = default;

    FakeOuterCompositeResource(
        const FakeOuterCompositeResource& other) = default; // copy constructor
    FakeOuterCompositeResource(FakeOuterCompositeResource&& other) noexcept = default; // move constructor

    FakeOuterCompositeResource& operator=(const FakeOuterCompositeResource& other) = default; // copy assignment
    FakeOuterCompositeResource& operator=(FakeOuterCompositeResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<std::pair<int, OuterComposite>(
        OuterComposite & outerComposite)> handler_POST_func =
            [](OuterComposite &) -> std::pair<int, OuterComposite>
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, OuterComposite> handler_POST(
        OuterComposite & outerComposite);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// 
/// </summary>
/// <remarks>
/// Test serialization of outer number types
/// </remarks>
class  FakeOuterNumberResource: public restbed::Resource
{
public:
    FakeOuterNumberResource(const std::string& context = "/v2");
    virtual ~FakeOuterNumberResource() = default;

    FakeOuterNumberResource(
        const FakeOuterNumberResource& other) = default; // copy constructor
    FakeOuterNumberResource(FakeOuterNumberResource&& other) noexcept = default; // move constructor

    FakeOuterNumberResource& operator=(const FakeOuterNumberResource& other) = default; // copy assignment
    FakeOuterNumberResource& operator=(FakeOuterNumberResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<std::pair<int, double>(
        double & body)> handler_POST_func =
            [](double &) -> std::pair<int, double>
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, double> handler_POST(
        double & body);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// 
/// </summary>
/// <remarks>
/// Test serialization of outer string types
/// </remarks>
class  FakeOuterStringResource: public restbed::Resource
{
public:
    FakeOuterStringResource(const std::string& context = "/v2");
    virtual ~FakeOuterStringResource() = default;

    FakeOuterStringResource(
        const FakeOuterStringResource& other) = default; // copy constructor
    FakeOuterStringResource(FakeOuterStringResource&& other) noexcept = default; // move constructor

    FakeOuterStringResource& operator=(const FakeOuterStringResource& other) = default; // copy assignment
    FakeOuterStringResource& operator=(FakeOuterStringResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<std::pair<int, std::string>(
        std::string & body)> handler_POST_func =
            [](std::string &) -> std::pair<int, std::string>
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, std::string> handler_POST(
        std::string & body);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// 
/// </summary>
/// <remarks>
/// Test serialization of enum (int) properties with examples
/// </remarks>
class  FakePropertyEnum_intResource: public restbed::Resource
{
public:
    FakePropertyEnum_intResource(const std::string& context = "/v2");
    virtual ~FakePropertyEnum_intResource() = default;

    FakePropertyEnum_intResource(
        const FakePropertyEnum_intResource& other) = default; // copy constructor
    FakePropertyEnum_intResource(FakePropertyEnum_intResource&& other) noexcept = default; // move constructor

    FakePropertyEnum_intResource& operator=(const FakePropertyEnum_intResource& other) = default; // copy assignment
    FakePropertyEnum_intResource& operator=(FakePropertyEnum_intResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<std::pair<int, OuterObjectWithEnumProperty>(
        OuterObjectWithEnumProperty & outerObjectWithEnumProperty)> handler_POST_func =
            [](OuterObjectWithEnumProperty &) -> std::pair<int, OuterObjectWithEnumProperty>
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, OuterObjectWithEnumProperty> handler_POST(
        OuterObjectWithEnumProperty & outerObjectWithEnumProperty);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// test referenced additionalProperties
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  FakeAdditionalProperties_referenceResource: public restbed::Resource
{
public:
    FakeAdditionalProperties_referenceResource(const std::string& context = "/v2");
    virtual ~FakeAdditionalProperties_referenceResource() = default;

    FakeAdditionalProperties_referenceResource(
        const FakeAdditionalProperties_referenceResource& other) = default; // copy constructor
    FakeAdditionalProperties_referenceResource(FakeAdditionalProperties_referenceResource&& other) noexcept = default; // move constructor

    FakeAdditionalProperties_referenceResource& operator=(const FakeAdditionalProperties_referenceResource& other) = default; // copy assignment
    FakeAdditionalProperties_referenceResource& operator=(FakeAdditionalProperties_referenceResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<int(
        std::map<std::string, AnyType> & requestBody)> handler_POST_func =
            [](std::map<std::string, AnyType> &) -> int
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_POST(
        std::map<std::string, AnyType> & requestBody);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// 
/// </summary>
/// <remarks>
/// For this test, the body has to be a binary file.
/// </remarks>
class  FakeBody_with_binaryResource: public restbed::Resource
{
public:
    FakeBody_with_binaryResource(const std::string& context = "/v2");
    virtual ~FakeBody_with_binaryResource() = default;

    FakeBody_with_binaryResource(
        const FakeBody_with_binaryResource& other) = default; // copy constructor
    FakeBody_with_binaryResource(FakeBody_with_binaryResource&& other) noexcept = default; // move constructor

    FakeBody_with_binaryResource& operator=(const FakeBody_with_binaryResource& other) = default; // copy assignment
    FakeBody_with_binaryResource& operator=(FakeBody_with_binaryResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<int(
        std::string & body)> handler_PUT_func =
            [](std::string &) -> int
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_PUT(
        std::string & body);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_PUT_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// 
/// </summary>
/// <remarks>
/// For this test, the body for this request must reference a schema named &#x60;File&#x60;.
/// </remarks>
class  FakeBody_with_file_schemaResource: public restbed::Resource
{
public:
    FakeBody_with_file_schemaResource(const std::string& context = "/v2");
    virtual ~FakeBody_with_file_schemaResource() = default;

    FakeBody_with_file_schemaResource(
        const FakeBody_with_file_schemaResource& other) = default; // copy constructor
    FakeBody_with_file_schemaResource(FakeBody_with_file_schemaResource&& other) noexcept = default; // move constructor

    FakeBody_with_file_schemaResource& operator=(const FakeBody_with_file_schemaResource& other) = default; // copy assignment
    FakeBody_with_file_schemaResource& operator=(FakeBody_with_file_schemaResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<int(
        FileSchemaTestClass & fileSchemaTestClass)> handler_PUT_func =
            [](FileSchemaTestClass &) -> int
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_PUT(
        FileSchemaTestClass & fileSchemaTestClass);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_PUT_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// 
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  FakeBody_with_query_paramsResource: public restbed::Resource
{
public:
    FakeBody_with_query_paramsResource(const std::string& context = "/v2");
    virtual ~FakeBody_with_query_paramsResource() = default;

    FakeBody_with_query_paramsResource(
        const FakeBody_with_query_paramsResource& other) = default; // copy constructor
    FakeBody_with_query_paramsResource(FakeBody_with_query_paramsResource&& other) noexcept = default; // move constructor

    FakeBody_with_query_paramsResource& operator=(const FakeBody_with_query_paramsResource& other) = default; // copy assignment
    FakeBody_with_query_paramsResource& operator=(FakeBody_with_query_paramsResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<int(
        std::string & query, User & user)> handler_PUT_func =
            [](std::string &, User &) -> int
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_PUT(
        std::string & query, User & user);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_PUT_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// To test \&quot;client\&quot; model
/// </summary>
/// <remarks>
/// To test \&quot;client\&quot; model
/// </remarks>
class  FakeResource: public restbed::Resource
{
public:
    FakeResource(const std::string& context = "/v2");
    virtual ~FakeResource() = default;

    FakeResource(
        const FakeResource& other) = default; // copy constructor
    FakeResource(FakeResource&& other) noexcept = default; // move constructor

    FakeResource& operator=(const FakeResource& other) = default; // copy assignment
    FakeResource& operator=(FakeResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<std::pair<int, Client>(
        Client & client)> handler_PATCH_func =
            [](Client &) -> std::pair<int, Client>
                { throw FakeApiException(501, "Not implemented"); };

    std::function<int(
        double & number, double & r_double, std::string & patternWithoutDelimiter, std::string & byte, int32_t & integer, int32_t & int32, int64_t & int64, float & r_float, std::string & string, std::string & binary, std::string & date, std::string & dateTime, std::string & password, std::string & callback)> handler_POST_func =
            [](double &, double &, std::string &, std::string &, int32_t &, int32_t &, int64_t &, float &, std::string &, std::string &, std::string &, std::string &, std::string &, std::string &) -> int
                { throw FakeApiException(501, "Not implemented"); };

    std::function<int(
        std::vector<std::string> & enumHeaderStringArray, std::string & enumHeaderString, std::vector<std::string> & enumQueryStringArray, std::string & enumQueryString, int32_t & enumQueryInteger, double & enumQueryDouble, std::vector<EnumClass> & enumQueryModelArray, std::vector<std::string> & enumFormStringArray, std::string & enumFormString)> handler_GET_func =
            [](std::vector<std::string> &, std::string &, std::vector<std::string> &, std::string &, int32_t &, double &, std::vector<EnumClass> &, std::vector<std::string> &, std::string &) -> int
                { throw FakeApiException(501, "Not implemented"); };

    std::function<int(
        int32_t & requiredStringGroup, bool & requiredBooleanGroup, int64_t & requiredInt64Group, int32_t & stringGroup, bool & booleanGroup, int64_t & int64Group)> handler_DELETE_func =
            [](int32_t &, bool &, int64_t &, int32_t &, bool &, int64_t &) -> int
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual std::pair<int, Client> handler_PATCH(
        Client & client);

    virtual int handler_POST(
        double & number, double & r_double, std::string & patternWithoutDelimiter, std::string & byte, int32_t & integer, int32_t & int32, int64_t & int64, float & r_float, std::string & string, std::string & binary, std::string & date, std::string & dateTime, std::string & password, std::string & callback);
    virtual int handler_GET(
        std::vector<std::string> & enumHeaderStringArray, std::string & enumHeaderString, std::vector<std::string> & enumQueryStringArray, std::string & enumQueryString, int32_t & enumQueryInteger, double & enumQueryDouble, std::vector<EnumClass> & enumQueryModelArray, std::vector<std::string> & enumFormStringArray, std::string & enumFormString);
    virtual int handler_DELETE(
        int32_t & requiredStringGroup, bool & requiredBooleanGroup, int64_t & requiredInt64Group, int32_t & stringGroup, bool & booleanGroup, int64_t & int64Group);

protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_PATCH_internal(const std::shared_ptr<restbed::Session> session);
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
    void handler_GET_internal(const std::shared_ptr<restbed::Session> session);
    void handler_DELETE_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// test inline additionalProperties
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  FakeInline_additionalPropertiesResource: public restbed::Resource
{
public:
    FakeInline_additionalPropertiesResource(const std::string& context = "/v2");
    virtual ~FakeInline_additionalPropertiesResource() = default;

    FakeInline_additionalPropertiesResource(
        const FakeInline_additionalPropertiesResource& other) = default; // copy constructor
    FakeInline_additionalPropertiesResource(FakeInline_additionalPropertiesResource&& other) noexcept = default; // move constructor

    FakeInline_additionalPropertiesResource& operator=(const FakeInline_additionalPropertiesResource& other) = default; // copy assignment
    FakeInline_additionalPropertiesResource& operator=(FakeInline_additionalPropertiesResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<int(
        std::map<std::string, std::string> & requestBody)> handler_POST_func =
            [](std::map<std::string, std::string> &) -> int
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_POST(
        std::map<std::string, std::string> & requestBody);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// test inline free-form additionalProperties
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  FakeInline_freeform_additionalPropertiesResource: public restbed::Resource
{
public:
    FakeInline_freeform_additionalPropertiesResource(const std::string& context = "/v2");
    virtual ~FakeInline_freeform_additionalPropertiesResource() = default;

    FakeInline_freeform_additionalPropertiesResource(
        const FakeInline_freeform_additionalPropertiesResource& other) = default; // copy constructor
    FakeInline_freeform_additionalPropertiesResource(FakeInline_freeform_additionalPropertiesResource&& other) noexcept = default; // move constructor

    FakeInline_freeform_additionalPropertiesResource& operator=(const FakeInline_freeform_additionalPropertiesResource& other) = default; // copy assignment
    FakeInline_freeform_additionalPropertiesResource& operator=(FakeInline_freeform_additionalPropertiesResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<int(
        TestInlineFreeformAdditionalProperties_request & testInlineFreeformAdditionalPropertiesRequest)> handler_POST_func =
            [](TestInlineFreeformAdditionalProperties_request &) -> int
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_POST(
        TestInlineFreeformAdditionalProperties_request & testInlineFreeformAdditionalPropertiesRequest);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// test json serialization of form data
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  FakeJsonFormDataResource: public restbed::Resource
{
public:
    FakeJsonFormDataResource(const std::string& context = "/v2");
    virtual ~FakeJsonFormDataResource() = default;

    FakeJsonFormDataResource(
        const FakeJsonFormDataResource& other) = default; // copy constructor
    FakeJsonFormDataResource(FakeJsonFormDataResource&& other) noexcept = default; // move constructor

    FakeJsonFormDataResource& operator=(const FakeJsonFormDataResource& other) = default; // copy assignment
    FakeJsonFormDataResource& operator=(FakeJsonFormDataResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<int(
        std::string & param, std::string & param2)> handler_GET_func =
            [](std::string &, std::string &) -> int
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_GET(
        std::string & param, std::string & param2);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_GET_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// test nullable parent property
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  FakeNullableResource: public restbed::Resource
{
public:
    FakeNullableResource(const std::string& context = "/v2");
    virtual ~FakeNullableResource() = default;

    FakeNullableResource(
        const FakeNullableResource& other) = default; // copy constructor
    FakeNullableResource(FakeNullableResource&& other) noexcept = default; // move constructor

    FakeNullableResource& operator=(const FakeNullableResource& other) = default; // copy assignment
    FakeNullableResource& operator=(FakeNullableResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<int(
        ChildWithNullable & childWithNullable)> handler_POST_func =
            [](ChildWithNullable &) -> int
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_POST(
        ChildWithNullable & childWithNullable);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// 
/// </summary>
/// <remarks>
/// To test the collection format in query parameters
/// </remarks>
class  FakeTest_query_parametersResource: public restbed::Resource
{
public:
    FakeTest_query_parametersResource(const std::string& context = "/v2");
    virtual ~FakeTest_query_parametersResource() = default;

    FakeTest_query_parametersResource(
        const FakeTest_query_parametersResource& other) = default; // copy constructor
    FakeTest_query_parametersResource(FakeTest_query_parametersResource&& other) noexcept = default; // move constructor

    FakeTest_query_parametersResource& operator=(const FakeTest_query_parametersResource& other) = default; // copy assignment
    FakeTest_query_parametersResource& operator=(FakeTest_query_parametersResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<int(
        std::vector<std::string> & pipe, std::vector<std::string> & ioutil, std::vector<std::string> & http, std::vector<std::string> & url, std::vector<std::string> & context, std::string & allowEmpty, std::map<std::string, std::string> & language)> handler_PUT_func =
            [](std::vector<std::string> &, std::vector<std::string> &, std::vector<std::string> &, std::vector<std::string> &, std::vector<std::string> &, std::string &, std::map<std::string, std::string> &) -> int
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_PUT(
        std::vector<std::string> & pipe, std::vector<std::string> & ioutil, std::vector<std::string> & http, std::vector<std::string> & url, std::vector<std::string> & context, std::string & allowEmpty, std::map<std::string, std::string> & language);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_PUT_internal(const std::shared_ptr<restbed::Session> session);
};

/// <summary>
/// test referenced string map
/// </summary>
/// <remarks>
/// 
/// </remarks>
class  FakeStringMap_referenceResource: public restbed::Resource
{
public:
    FakeStringMap_referenceResource(const std::string& context = "/v2");
    virtual ~FakeStringMap_referenceResource() = default;

    FakeStringMap_referenceResource(
        const FakeStringMap_referenceResource& other) = default; // copy constructor
    FakeStringMap_referenceResource(FakeStringMap_referenceResource&& other) noexcept = default; // move constructor

    FakeStringMap_referenceResource& operator=(const FakeStringMap_referenceResource& other) = default; // copy assignment
    FakeStringMap_referenceResource& operator=(FakeStringMap_referenceResource&& other) noexcept = default; // move assignment

    /////////////////////////////////////////////////////
    // Set these to implement the server functionality //
    /////////////////////////////////////////////////////
    std::function<int(
        std::map<std::string, std::string> & requestBody)> handler_POST_func =
            [](std::map<std::string, std::string> &) -> int
                { throw FakeApiException(501, "Not implemented"); };


protected:
    //////////////////////////////////////////////////////////
    // As an alternative to setting the `std::function`s    //
    // override these to implement the server functionality //
    //////////////////////////////////////////////////////////

    virtual int handler_POST(
        std::map<std::string, std::string> & requestBody);


protected:
    //////////////////////////////////////
    // Override these for customization //
    //////////////////////////////////////

    virtual std::string extractBodyContent(const std::shared_ptr<restbed::Session>& session);
    virtual std::string extractFormParamsFromBody(const std::string& paramName, const std::string& body);

    virtual std::pair<int, std::string> handleFakeApiException(const FakeApiException& e);
    virtual std::pair<int, std::string> handleStdException(const std::exception& e);
    virtual std::pair<int, std::string> handleUnspecifiedException();

    virtual void setResponseHeader(const std::shared_ptr<restbed::Session>& session,
        const std::string& header);

    virtual void returnResponse(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result, std::multimap<std::string, std::string>& contentType);
    virtual void defaultSessionClose(const std::shared_ptr<restbed::Session>& session,
        const int status, const std::string& result);

private:
    void handler_POST_internal(const std::shared_ptr<restbed::Session> session);
};

} /* namespace FakeApiResources */

using FakeApiFakeBigDecimalMapResource [[deprecated]] = FakeApiResources::FakeBigDecimalMapResource;
using FakeApiFakeHealthResource [[deprecated]] = FakeApiResources::FakeHealthResource;
using FakeApiFakeHttp_signature_testResource [[deprecated]] = FakeApiResources::FakeHttp_signature_testResource;
using FakeApiFakeOuterBooleanResource [[deprecated]] = FakeApiResources::FakeOuterBooleanResource;
using FakeApiFakeOuterCompositeResource [[deprecated]] = FakeApiResources::FakeOuterCompositeResource;
using FakeApiFakeOuterNumberResource [[deprecated]] = FakeApiResources::FakeOuterNumberResource;
using FakeApiFakeOuterStringResource [[deprecated]] = FakeApiResources::FakeOuterStringResource;
using FakeApiFakePropertyEnum_intResource [[deprecated]] = FakeApiResources::FakePropertyEnum_intResource;
using FakeApiFakeAdditionalProperties_referenceResource [[deprecated]] = FakeApiResources::FakeAdditionalProperties_referenceResource;
using FakeApiFakeBody_with_binaryResource [[deprecated]] = FakeApiResources::FakeBody_with_binaryResource;
using FakeApiFakeBody_with_file_schemaResource [[deprecated]] = FakeApiResources::FakeBody_with_file_schemaResource;
using FakeApiFakeBody_with_query_paramsResource [[deprecated]] = FakeApiResources::FakeBody_with_query_paramsResource;
using FakeApiFakeResource [[deprecated]] = FakeApiResources::FakeResource;
using FakeApiFakeInline_additionalPropertiesResource [[deprecated]] = FakeApiResources::FakeInline_additionalPropertiesResource;
using FakeApiFakeInline_freeform_additionalPropertiesResource [[deprecated]] = FakeApiResources::FakeInline_freeform_additionalPropertiesResource;
using FakeApiFakeJsonFormDataResource [[deprecated]] = FakeApiResources::FakeJsonFormDataResource;
using FakeApiFakeNullableResource [[deprecated]] = FakeApiResources::FakeNullableResource;
using FakeApiFakeTest_query_parametersResource [[deprecated]] = FakeApiResources::FakeTest_query_parametersResource;
using FakeApiFakeStringMap_referenceResource [[deprecated]] = FakeApiResources::FakeStringMap_referenceResource;

//
// The restbed service to actually implement the REST server
//
class  FakeApi
{
public:
    explicit FakeApi(std::shared_ptr<restbed::Service> const& restbedService);
    virtual ~FakeApi();

    std::shared_ptr<FakeApiResources::FakeBigDecimalMapResource> getFakeBigDecimalMapResource();
    std::shared_ptr<FakeApiResources::FakeHealthResource> getFakeHealthResource();
    std::shared_ptr<FakeApiResources::FakeHttp_signature_testResource> getFakeHttp_signature_testResource();
    std::shared_ptr<FakeApiResources::FakeOuterBooleanResource> getFakeOuterBooleanResource();
    std::shared_ptr<FakeApiResources::FakeOuterCompositeResource> getFakeOuterCompositeResource();
    std::shared_ptr<FakeApiResources::FakeOuterNumberResource> getFakeOuterNumberResource();
    std::shared_ptr<FakeApiResources::FakeOuterStringResource> getFakeOuterStringResource();
    std::shared_ptr<FakeApiResources::FakePropertyEnum_intResource> getFakePropertyEnum_intResource();
    std::shared_ptr<FakeApiResources::FakeAdditionalProperties_referenceResource> getFakeAdditionalProperties_referenceResource();
    std::shared_ptr<FakeApiResources::FakeBody_with_binaryResource> getFakeBody_with_binaryResource();
    std::shared_ptr<FakeApiResources::FakeBody_with_file_schemaResource> getFakeBody_with_file_schemaResource();
    std::shared_ptr<FakeApiResources::FakeBody_with_query_paramsResource> getFakeBody_with_query_paramsResource();
    std::shared_ptr<FakeApiResources::FakeResource> getFakeResource();
    std::shared_ptr<FakeApiResources::FakeInline_additionalPropertiesResource> getFakeInline_additionalPropertiesResource();
    std::shared_ptr<FakeApiResources::FakeInline_freeform_additionalPropertiesResource> getFakeInline_freeform_additionalPropertiesResource();
    std::shared_ptr<FakeApiResources::FakeJsonFormDataResource> getFakeJsonFormDataResource();
    std::shared_ptr<FakeApiResources::FakeNullableResource> getFakeNullableResource();
    std::shared_ptr<FakeApiResources::FakeTest_query_parametersResource> getFakeTest_query_parametersResource();
    std::shared_ptr<FakeApiResources::FakeStringMap_referenceResource> getFakeStringMap_referenceResource();

    void setResource(std::shared_ptr<FakeApiResources::FakeBigDecimalMapResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeHealthResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeHttp_signature_testResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeOuterBooleanResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeOuterCompositeResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeOuterNumberResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeOuterStringResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakePropertyEnum_intResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeAdditionalProperties_referenceResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeBody_with_binaryResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeBody_with_file_schemaResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeBody_with_query_paramsResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeInline_additionalPropertiesResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeInline_freeform_additionalPropertiesResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeJsonFormDataResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeNullableResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeTest_query_parametersResource> resource);
    void setResource(std::shared_ptr<FakeApiResources::FakeStringMap_referenceResource> resource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeBigDecimalMapResource(std::shared_ptr<FakeApiResources::FakeBigDecimalMapResource> spFakeApiFakeBigDecimalMapResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeHealthResource(std::shared_ptr<FakeApiResources::FakeHealthResource> spFakeApiFakeHealthResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeHttp_signature_testResource(std::shared_ptr<FakeApiResources::FakeHttp_signature_testResource> spFakeApiFakeHttp_signature_testResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeOuterBooleanResource(std::shared_ptr<FakeApiResources::FakeOuterBooleanResource> spFakeApiFakeOuterBooleanResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeOuterCompositeResource(std::shared_ptr<FakeApiResources::FakeOuterCompositeResource> spFakeApiFakeOuterCompositeResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeOuterNumberResource(std::shared_ptr<FakeApiResources::FakeOuterNumberResource> spFakeApiFakeOuterNumberResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeOuterStringResource(std::shared_ptr<FakeApiResources::FakeOuterStringResource> spFakeApiFakeOuterStringResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakePropertyEnum_intResource(std::shared_ptr<FakeApiResources::FakePropertyEnum_intResource> spFakeApiFakePropertyEnum_intResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeAdditionalProperties_referenceResource(std::shared_ptr<FakeApiResources::FakeAdditionalProperties_referenceResource> spFakeApiFakeAdditionalProperties_referenceResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeBody_with_binaryResource(std::shared_ptr<FakeApiResources::FakeBody_with_binaryResource> spFakeApiFakeBody_with_binaryResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeBody_with_file_schemaResource(std::shared_ptr<FakeApiResources::FakeBody_with_file_schemaResource> spFakeApiFakeBody_with_file_schemaResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeBody_with_query_paramsResource(std::shared_ptr<FakeApiResources::FakeBody_with_query_paramsResource> spFakeApiFakeBody_with_query_paramsResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeResource(std::shared_ptr<FakeApiResources::FakeResource> spFakeApiFakeResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeInline_additionalPropertiesResource(std::shared_ptr<FakeApiResources::FakeInline_additionalPropertiesResource> spFakeApiFakeInline_additionalPropertiesResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeInline_freeform_additionalPropertiesResource(std::shared_ptr<FakeApiResources::FakeInline_freeform_additionalPropertiesResource> spFakeApiFakeInline_freeform_additionalPropertiesResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeJsonFormDataResource(std::shared_ptr<FakeApiResources::FakeJsonFormDataResource> spFakeApiFakeJsonFormDataResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeNullableResource(std::shared_ptr<FakeApiResources::FakeNullableResource> spFakeApiFakeNullableResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeTest_query_parametersResource(std::shared_ptr<FakeApiResources::FakeTest_query_parametersResource> spFakeApiFakeTest_query_parametersResource);
    [[deprecated("use setResource()")]]
    virtual void setFakeApiFakeStringMap_referenceResource(std::shared_ptr<FakeApiResources::FakeStringMap_referenceResource> spFakeApiFakeStringMap_referenceResource);

    virtual void publishDefaultResources();

    virtual std::shared_ptr<restbed::Service> service();

protected:
    std::shared_ptr<FakeApiResources::FakeBigDecimalMapResource> m_spFakeBigDecimalMapResource;
    std::shared_ptr<FakeApiResources::FakeHealthResource> m_spFakeHealthResource;
    std::shared_ptr<FakeApiResources::FakeHttp_signature_testResource> m_spFakeHttp_signature_testResource;
    std::shared_ptr<FakeApiResources::FakeOuterBooleanResource> m_spFakeOuterBooleanResource;
    std::shared_ptr<FakeApiResources::FakeOuterCompositeResource> m_spFakeOuterCompositeResource;
    std::shared_ptr<FakeApiResources::FakeOuterNumberResource> m_spFakeOuterNumberResource;
    std::shared_ptr<FakeApiResources::FakeOuterStringResource> m_spFakeOuterStringResource;
    std::shared_ptr<FakeApiResources::FakePropertyEnum_intResource> m_spFakePropertyEnum_intResource;
    std::shared_ptr<FakeApiResources::FakeAdditionalProperties_referenceResource> m_spFakeAdditionalProperties_referenceResource;
    std::shared_ptr<FakeApiResources::FakeBody_with_binaryResource> m_spFakeBody_with_binaryResource;
    std::shared_ptr<FakeApiResources::FakeBody_with_file_schemaResource> m_spFakeBody_with_file_schemaResource;
    std::shared_ptr<FakeApiResources::FakeBody_with_query_paramsResource> m_spFakeBody_with_query_paramsResource;
    std::shared_ptr<FakeApiResources::FakeResource> m_spFakeResource;
    std::shared_ptr<FakeApiResources::FakeInline_additionalPropertiesResource> m_spFakeInline_additionalPropertiesResource;
    std::shared_ptr<FakeApiResources::FakeInline_freeform_additionalPropertiesResource> m_spFakeInline_freeform_additionalPropertiesResource;
    std::shared_ptr<FakeApiResources::FakeJsonFormDataResource> m_spFakeJsonFormDataResource;
    std::shared_ptr<FakeApiResources::FakeNullableResource> m_spFakeNullableResource;
    std::shared_ptr<FakeApiResources::FakeTest_query_parametersResource> m_spFakeTest_query_parametersResource;
    std::shared_ptr<FakeApiResources::FakeStringMap_referenceResource> m_spFakeStringMap_referenceResource;

private:
    std::shared_ptr<restbed::Service> m_service;
};


}
}
}
}

#endif /* FakeApi_H_ */

