# OpenAPI server library for Erlang

## Overview

An Erlang server stub generated by [OpenAPI Generator](https://openapi-generator.tech) given an OpenAPI spec.

## Prerequisites

1. [Erlang/OTP (v27)](https://www.erlang.org/)

2. [rebar3](https://rebar3.org/)

3. Erlang libraries:
    - [Cowboy](https://hex.pm/packages/cowboy)
    - [Ranch](https://hex.pm/packages/ranch)
    - [Jesse](https://hex.pm/packages/jesse)

4. OpenAPI generator script `openapi-generator-cli` 
(for more information see [OpenAPI Generator - Getting Started](https://github.com/OpenAPITools/openapi-generator#2---getting-started) )

5. OpenAPI specification file in the current folder (for example [petstore.yaml](https://raw.githubusercontent.com/openapitools/openapi-generator/master/modules/openapi-generator/src/test/resources/3_0/petstore.yaml))


## Getting started
Use `erlang-server` with `rebar3`

1. Create a folder with an Erlang application by using `rebar3`
    
    `$ rebar3 new app http_server`

2. Generate OpenAPI `erlang-server` project using `openapi-generator`
    
    `$ openapi-generator-cli generate -g erlang-server -i petstore.yaml -o ./http_server --additional-properties packageName=openapi`
    
3. Go into the `http_server` project folder

    `$ cd http_server`

    NOTE: The following generated files are now in the folder "http_server":

    - `src/http_server*.erl`, `http_server.app.src` -- Erlang application modules generated by `rebar3`

    - `src/openapi*.erl`, `openapi.app.src` -- REST API request handling modules generated by `openapi-generator-cli`

    - `priv/openapi.json` -- OpenAPI data in JSON format created by `openapi-generator-cli`

    - `rebar.config` -- Erlang project configuration file generated by `openapi-generator-cli`

4. Add the following line to the `start/2` function in the `src/http_server_app.erl`:

```erlang
    openapi_server:start(http_server,
        #{transport_opts => [{ip,{127,0,0,1}},
                             {port,8080} 
                            ]})
```

The updated `start/2` in `src/http_server_app.erl` should look like this:

```erlang
start(_StartType, _StartArgs) ->
    openapi_server:start(http_server,
        #{transport_opts => [{ip,{127,0,0,1}},
                             {port,8080} 
                            ]}),
    http_server_sup:start_link().
```

5. Update application configuration file `http_server.app.src` (in the `src` subfolder):
    
    1. Copy application name from `http_server.app.src` to `openapi.app.src`
    
    2. Copy `{mod,...}` rule from the `http_server.app.src` to `openapi.app.src`
    
    3. Copy `openapi.app.src` over `http_server.app.src`

        `$ cp src/openapi.app.src src/http_server.app.src`
    
    4. Remove `openapi.app.src`

        `$ rm src/openapi.app.src`

The updated `src/http_server.app.src` must be the only configuration file in the project and it should look like this:

```
{application, http_server,
    [   {description, "This is a sample petstore server"},
        {vsn, "1.0.0"},
        {registered, []},
        {mod, {http_server_app, []}},
        {applications, [kernel, stdlib, public_key, ssl, inets, ranch, cowboy]},
        {env, []},
        {modules, []},
        {licenses, ["Apache-2.0"]},
        {links, []}
    ]}.
```

6. Compile your `http_server` project
    
    `$ rebar3 compile`

7. Start Erlang virtual machine
    `$ rebar3 shell`

8. Start the application by running a following command in the `rebar3` shell

    `1> application:ensure_all_started(http_server).`

    Alternatively, you could start your application with the `rebar3` shell by adding the following lines to the `rebar.config`:
    ```
    {shell, [
        {apps, [http_server]}
    ]}.
    ```

Note: If you need to repeat code generation using `openapi-generator-cli`, but don't want to rewrite changes in files made manually, you could use file `.openapi-generator-ignore` in the project root folder. For example, such `.openapi-generator-ignore` will preserve manual changes done in the file `rebar.conf` (Point 8)

```
# OpenAPI Generator Ignore
rebar.config
```

To implement your own business logic, create a module called `http_server_logic` that implements the
behaviour `openapi_logic_handler`. Refer to `openapi_logic_handler` documentation for details.

