/*
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * API version: 1.0.0
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package petstoreserver

import (
	"net/http"

	"github.com/gin-gonic/gin"
)

// Route is the information for every URI.
type Route struct {
	// Name is the name of this Route.
	Name		string
	// Method is the string for the HTTP method. ex) GET, POST etc..
	Method		string
	// Pattern is the pattern of the URI.
	Pattern	 	string
	// HandlerFunc is the handler function of this route.
	HandlerFunc	gin.HandlerFunc
}

// NewRouter returns a new router.
func NewRouter(handleFunctions ApiHandleFunctions) *gin.Engine {
	return NewRouterWithGinEngine(gin.Default(), handleFunctions)
}

// NewRouter add routes to existing gin engine.
func NewRouterWithGinEngine(router *gin.Engine, handleFunctions ApiHandleFunctions) *gin.Engine {
	for _, route := range getRoutes(handleFunctions) {
		if route.HandlerFunc == nil {
			route.HandlerFunc = DefaultHandleFunc
		}
		switch route.Method {
		case http.MethodGet:
			router.GET(route.Pattern, route.HandlerFunc)
		case http.MethodPost:
			router.POST(route.Pattern, route.HandlerFunc)
		case http.MethodPut:
			router.PUT(route.Pattern, route.HandlerFunc)
		case http.MethodPatch:
			router.PATCH(route.Pattern, route.HandlerFunc)
		case http.MethodDelete:
			router.DELETE(route.Pattern, route.HandlerFunc)
		}
	}

	return router
}

// Default handler for not yet implemented routes
func DefaultHandleFunc(c *gin.Context) {
	c.String(http.StatusNotImplemented, "501 not implemented")
}

type ApiHandleFunctions struct {

	// Routes for the PetAPI part of the API
	PetAPI PetAPI
	// Routes for the StoreAPI part of the API
	StoreAPI StoreAPI
	// Routes for the UserAPI part of the API
	UserAPI UserAPI
}

func getRoutes(handleFunctions ApiHandleFunctions) []Route {
	return []Route{ 
		{
			"AddPet",
			http.MethodPost,
			"/v2/pet",
			handleFunctions.PetAPI.AddPet,
		},
		{
			"DeletePet",
			http.MethodDelete,
			"/v2/pet/:petId",
			handleFunctions.PetAPI.DeletePet,
		},
		{
			"FindPetsByStatus",
			http.MethodGet,
			"/v2/pet/findByStatus",
			handleFunctions.PetAPI.FindPetsByStatus,
		},
		{
			"FindPetsByTags",
			http.MethodGet,
			"/v2/pet/findByTags",
			handleFunctions.PetAPI.FindPetsByTags,
		},
		{
			"GetPetById",
			http.MethodGet,
			"/v2/pet/:petId",
			handleFunctions.PetAPI.GetPetById,
		},
		{
			"UpdatePet",
			http.MethodPut,
			"/v2/pet",
			handleFunctions.PetAPI.UpdatePet,
		},
		{
			"UpdatePetWithForm",
			http.MethodPost,
			"/v2/pet/:petId",
			handleFunctions.PetAPI.UpdatePetWithForm,
		},
		{
			"UploadFile",
			http.MethodPost,
			"/v2/pet/:petId/uploadImage",
			handleFunctions.PetAPI.UploadFile,
		},
		{
			"DeleteOrder",
			http.MethodDelete,
			"/v2/store/order/:orderId",
			handleFunctions.StoreAPI.DeleteOrder,
		},
		{
			"GetInventory",
			http.MethodGet,
			"/v2/store/inventory",
			handleFunctions.StoreAPI.GetInventory,
		},
		{
			"GetOrderById",
			http.MethodGet,
			"/v2/store/order/:orderId",
			handleFunctions.StoreAPI.GetOrderById,
		},
		{
			"PlaceOrder",
			http.MethodPost,
			"/v2/store/order",
			handleFunctions.StoreAPI.PlaceOrder,
		},
		{
			"CreateUser",
			http.MethodPost,
			"/v2/user",
			handleFunctions.UserAPI.CreateUser,
		},
		{
			"CreateUsersWithArrayInput",
			http.MethodPost,
			"/v2/user/createWithArray",
			handleFunctions.UserAPI.CreateUsersWithArrayInput,
		},
		{
			"CreateUsersWithListInput",
			http.MethodPost,
			"/v2/user/createWithList",
			handleFunctions.UserAPI.CreateUsersWithListInput,
		},
		{
			"DeleteUser",
			http.MethodDelete,
			"/v2/user/:username",
			handleFunctions.UserAPI.DeleteUser,
		},
		{
			"GetUserByName",
			http.MethodGet,
			"/v2/user/:username",
			handleFunctions.UserAPI.GetUserByName,
		},
		{
			"LoginUser",
			http.MethodGet,
			"/v2/user/login",
			handleFunctions.UserAPI.LoginUser,
		},
		{
			"LogoutUser",
			http.MethodGet,
			"/v2/user/logout",
			handleFunctions.UserAPI.LogoutUser,
		},
		{
			"UpdateUser",
			http.MethodPut,
			"/v2/user/:username",
			handleFunctions.UserAPI.UpdateUser,
		},
	}
}
