# OpenAPI Petstore

This is a sample server Petstore server. For this sample, you can use the api key &#x60;special-key&#x60; to test the authorization filters.

This is a microservice project based on Apache Dubbo, generated by [OpenAPI Generator](https://openapi-generator.tech).

- API version: 1.0.0
- Package version: 
- Generator: org.openapitools.codegen.languages.JavaDubboServerCodegen

## Technology Stack

- **Framework**: Apache Dubbo 3.2.18
- **Java**: 8+
- **Build Tool**: Maven 3.6+
- **Registry**: zookeeper://127.0.0.1:2181
- **Serialization**: Jackson JSON

## System Requirements

Building and running this project requires:
1. Java 8+
2. Maven 3.6+
3. Registry Center (Nacos or Zookeeper)

## Quick Start

### 1. Clone and Build Project

```bash
git clone <your-repo-url>
cd openapi-dubbo-server-petstore
mvn clean compile
```

### 2. Configure Registry Center

#### Using Nacos (Recommended)
```bash
# Download and start Nacos
wget https://github.com/alibaba/nacos/releases/download/2.2.4/nacos-server-2.2.4.tar.gz
tar -xzf nacos-server-2.2.4.tar.gz
cd nacos/bin
# Linux/Mac
./startup.sh -m standalone
# Windows
startup.cmd -m standalone
```

#### Using Zookeeper (Alternative)
```bash
# Download and start Zookeeper
wget https://downloads.apache.org/zookeeper/zookeeper-3.8.2/apache-zookeeper-3.8.2-bin.tar.gz
tar -xzf apache-zookeeper-3.8.2-bin.tar.gz
cd apache-zookeeper-3.8.2-bin
cp conf/zoo_sample.cfg conf/zoo.cfg
bin/zkServer.sh start
```

### 3. Configure Application

Edit the `src/main/resources/application.yml` file:

```yaml
# Dubbo Configuration
dubbo:
  application:
    name: openapi-dubbo-server-petstore
  registry:
    # Using Nacos
    address: nacos://127.0.0.1:8848
    # Or using Zookeeper
    # address: zookeeper://127.0.0.1:2181
  protocol:
    name: dubbo
    port: 20880
  provider:
    timeout: 10000

```

### 4. Start Application

```bash
# Build project
mvn clean compile

# Run main class
mvn exec:java -Dexec.mainClass=".Application"
```

## Project Structure

```
openapi-dubbo-server-petstore/
├── src/main/java//
│   └── Application.java                    # Main Application Class
├── src/main/resources/
│   └── application.yml                     # Application Configuration
├── pom.xml                                 # Maven Configuration
└── README.md                               # Project Documentation
```

## API Interfaces


### Service Interfaces


## Development Guide

### Implement Business Logic

1. Implement specific business logic in the generated `*DubboImpl.java` classes
2. Inject necessary business service dependencies
3. Handle exceptions and error scenarios

### Custom Configuration

1. **Timeout Configuration**: Adjust `dubbo.provider.timeout` in `application.yml`
2. **Thread Pool Configuration**: Configure `dubbo.provider.threads` and other parameters
3. **Serialization Configuration**: Choose appropriate serialization method

### Monitoring and Operations

1. **Health Checks**: Dubbo provides built-in health check endpoints
2. **Metrics Monitoring**: Integrate with Prometheus or other monitoring systems
3. **Log Management**: Configure appropriate log levels and output formats

## Testing

```bash
# Run unit tests
mvn test

# Run integration tests
mvn integration-test
```

## Deployment

### Development Environment
```bash
mvn spring-boot:run
```

### Production Environment
```bash
# Build production package
mvn clean package -Pprod

# Deploy using Docker
docker build -t openapi-dubbo-server-petstore:1.0.0 .
docker run -p 8080:8080 -p 20880:20880 openapi-dubbo-server-petstore:1.0.0
```

## Generator Configuration Options

This project supports the following OpenAPI Generator configuration options:

### Basic Configuration
- `title`: API service title name (Default: "OpenAPI Dubbo")
- `basePackage`: Base package name (Default: "org.openapitools")
- `configPackage`: Configuration class package name (Default: "org.openapitools.configuration")
- `dubboVersion`: Dubbo version (Default: "3.2.0")

### Generation Control
- `interfaceOnly`: Generate interfaces only, no implementation classes (Default: false)
- `serviceInterface`: Generate service interfaces (Default: true)
- `serviceImplementation`: Generate service implementations (Default: true)
- `async`: Use asynchronous methods (Default: false)
- `useTags`: Use tags to create class names (Default: true)
- `useGenericResponse`: Use generic response wrapper (Default: false)

### Registry Configuration
- `registry-address`: Registry address, supports full address format (Default: "zookeeper://127.0.0.1:2181")
  - Zookeeper example: `zookeeper://127.0.0.1:2181`
  - Nacos example: `nacos://127.0.0.1:8848`

#### 📋 Automatic Dependency Adaptation by Version
The generator automatically selects the correct dependencies based on Dubbo version:

**Dubbo 3.2 and earlier versions**:
- Zookeeper: `dubbo-dependencies-zookeeper` (Aggregation POM)
- Nacos: `dubbo-registry-nacos` + `nacos-client:2.2.4`

**Dubbo 3.3+ versions**:
- Zookeeper: `dubbo-registry-zookeeper` + `dubbo-remoting-zookeeper-curator5`
- Nacos: `dubbo-registry-nacos` + `nacos-client:2.5.0`

### Date-Time Library Configuration
- `dateLibrary`: Date-time library selection (Default: "java8")
  - `java8`: Java 8 native JSR310 (Recommended, for JDK 1.8+)
  - `java8-localdatetime`: Java 8 using LocalDateTime (For legacy applications only)
  - `joda`: Joda time library (For legacy applications only)
  - `legacy`: Traditional java.util.Date

### Usage Examples

#### 🔧 Dubbo 3.2 Version Example
```bash
# Using Zookeeper (3.2 version automatically uses dubbo-dependencies-zookeeper)
java -jar openapi-generator-cli.jar generate \
-i /Users/redoom/IdeaProjects/openapi.yaml \
-g java-dubbo \
-o /Users/redoom/IdeaProjects/openapi-test \
--additional-properties=registry-address=zookeeper://127.0.0.1:2181 \
--additional-properties=dubboVersion=3.2.0 \
--additional-properties=dateLibrary=java8

# Using Nacos (3.2 version uses nacos-client:2.2.4)
java -jar openapi-generator-cli.jar generate \
-i /Users/redoom/IdeaProjects/openapi.yaml \
-g java-dubbo \
-o /Users/redoom/IdeaProjects/openapi-test \
--additional-properties=registry-address=nacos://127.0.0.1:8848 \
--additional-properties=dubboVersion=3.2.0 \
--additional-properties=dateLibrary=java8
```

#### 🚀 Dubbo 3.3+ Version Example
```bash
# Using Zookeeper (3.3+ version automatically uses new modular dependencies)
java -jar openapi-generator-cli.jar generate \
-i /Users/redoom/IdeaProjects/openapi.yaml \
-g java-dubbo \
-o /Users/redoom/IdeaProjects/openapi-test \
--additional-properties=registry-address=zookeeper://127.0.0.1:2181 \
--additional-properties=dubboVersion=3.3.0 \
--additional-properties=dateLibrary=java8

# Using Nacos (3.3+ version uses nacos-client:2.5.0)
java -jar openapi-generator-cli.jar generate \
-i /Users/redoom/IdeaProjects/openapi.yaml \
-g java-dubbo \
-o /Users/redoom/IdeaProjects/openapi-test \
--additional-properties=registry-address=nacos://127.0.0.1:8848 \
--additional-properties=dubboVersion=3.3.0 \
--additional-properties=dateLibrary=java8
```

## Troubleshooting

### Common Issues

1. **Registry Connection Failed**
   - Check if the registry center is started
   - Verify network connection and port configuration

2. **Service Call Timeout**
   - Adjust `dubbo.provider.timeout` settings
   - Check network latency and service performance

3. **Serialization Exception**
   - Ensure all model classes implement `Serializable` interface
   - Check Jackson configuration

### Debug Logging

Enable debug mode to see detailed logs:

```yaml
logging:
  level:
    org.apache.dubbo: DEBUG
    : DEBUG
```

## License

This project is licensed under the [Apache License 2.0](LICENSE).

## Contributing

Issues and Pull Requests are welcome!

## Contact



---

> This project is automatically generated by OpenAPI Generator, based on Apache Dubbo microservice architecture.
