/**
* OpenAPI Petstore
* This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
*
* The version of the OpenAPI document: 1.0.0
* 
*
* NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
* https://openapi-generator.tech
* Do not edit the class manually.
*/
package org.openapitools.server

import io.ktor.resources.*
import kotlinx.serialization.*
import org.openapitools.server.models.*

object Paths {
    /**
     * Add a new pet to the store
     * 
     * @param pet Pet object that needs to be added to the store 
     */
    @Serializable @Resource("/pet") class addPet(val pet: Pet)

    /**
     * Deletes a pet
     * 
     * @param petId Pet id to delete 
     * @param apiKey  (optional)
     */
    @Serializable @Resource("/pet/{petId}") class deletePet(val petId: kotlin.Long, val apiKey: kotlin.String? = null)

    /**
     * Finds Pets by status
     * Multiple status values can be provided with comma separated strings
     * @param status Status values that need to be considered for filter 
     */
    @Serializable @Resource("/pet/findByStatus") class findPetsByStatus(val status: kotlin.collections.List<kotlin.String>)

    /**
     * Finds Pets by tags
     * Multiple tags can be provided with comma separated strings. Use tag1, tag2, tag3 for testing.
     * @param tags Tags to filter by 
     */
    @Serializable @Resource("/pet/findByTags") class findPetsByTags(val tags: kotlin.collections.List<kotlin.String>)

    /**
     * Find pet by ID
     * Returns a single pet
     * @param petId ID of pet to return 
     */
    @Serializable @Resource("/pet/{petId}") class getPetById(val petId: kotlin.Long)

    /**
     * Update an existing pet
     * 
     * @param pet Pet object that needs to be added to the store 
     */
    @Serializable @Resource("/pet") class updatePet(val pet: Pet)

    /**
     * Updates a pet in the store with form data
     * 
     * @param petId ID of pet that needs to be updated 
     * @param name Updated name of the pet (optional)
     * @param status Updated status of the pet (optional)
     */
    @Serializable @Resource("/pet/{petId}") class updatePetWithForm(val petId: kotlin.Long, val name: kotlin.String? = null, val status: kotlin.String? = null)

    /**
     * uploads an image
     * 
     * @param petId ID of pet to update 
     * @param additionalMetadata Additional data to pass to server (optional)
     * @param file file to upload (optional)
     */
    @Serializable @Resource("/pet/{petId}/uploadImage") class uploadFile(val petId: kotlin.Long, val additionalMetadata: kotlin.String? = null, val file: java.io.File? = null)

    /**
     * Delete purchase order by ID
     * For valid response try integer IDs with value &lt; 1000. Anything above 1000 or nonintegers will generate API errors
     * @param orderId ID of the order that needs to be deleted 
     */
    @Serializable @Resource("/store/order/{orderId}") class deleteOrder(val orderId: kotlin.String)

    /**
     * Returns pet inventories by status
     * Returns a map of status codes to quantities
     */
    @Serializable @Resource("/store/inventory") class getInventory

    /**
     * Find purchase order by ID
     * For valid response try integer IDs with value &lt;&#x3D; 5 or &gt; 10. Other values will generate exceptions
     * @param orderId ID of pet that needs to be fetched 
     */
    @Serializable @Resource("/store/order/{orderId}") class getOrderById(val orderId: kotlin.Long)

    /**
     * Place an order for a pet
     * 
     * @param order order placed for purchasing the pet 
     */
    @Serializable @Resource("/store/order") class placeOrder(val order: Order)

    /**
     * Create user
     * This can only be done by the logged in user.
     * @param user Created user object 
     */
    @Serializable @Resource("/user") class createUser(val user: User)

    /**
     * Creates list of users with given input array
     * 
     * @param user List of user object 
     */
    @Serializable @Resource("/user/createWithArray") class createUsersWithArrayInput(val user: kotlin.collections.List<User>)

    /**
     * Creates list of users with given input array
     * 
     * @param user List of user object 
     */
    @Serializable @Resource("/user/createWithList") class createUsersWithListInput(val user: kotlin.collections.List<User>)

    /**
     * Delete user
     * This can only be done by the logged in user.
     * @param username The name that needs to be deleted 
     */
    @Serializable @Resource("/user/{username}") class deleteUser(val username: kotlin.String)

    /**
     * Get user by user name
     * 
     * @param username The name that needs to be fetched. Use user1 for testing. 
     */
    @Serializable @Resource("/user/{username}") class getUserByName(val username: kotlin.String)

    /**
     * Logs user into the system
     * 
     * @param username The user name for login 
     * @param password The password for login in clear text 
     */
    @Serializable @Resource("/user/login") class loginUser(val username: kotlin.String, val password: kotlin.String)

    /**
     * Logs out current logged in user session
     * 
     */
    @Serializable @Resource("/user/logout") class logoutUser

    /**
     * Updated user
     * This can only be done by the logged in user.
     * @param username name that need to be deleted 
     * @param user Updated user object 
     */
    @Serializable @Resource("/user/{username}") class updateUser(val username: kotlin.String, val user: User)

}
