/**
* NOTE: Auto generated by OpenAPI Generator (7.20.0-SNAPSHOT)
* Spring 6 Declarative HTTP Interface
*/
package org.openapitools.api

import org.openapitools.model.ModelApiResponse
import org.openapitools.model.Pet

import io.swagger.v3.oas.annotations.*
import io.swagger.v3.oas.annotations.enums.*
import io.swagger.v3.oas.annotations.media.*
import io.swagger.v3.oas.annotations.responses.*
import io.swagger.v3.oas.annotations.security.*

import org.springframework.web.service.annotation.*
import org.springframework.web.bind.annotation.*
import org.springframework.http.HttpStatus

import org.springframework.validation.annotation.Validated
import jakarta.validation.Valid
import jakarta.validation.constraints.*


import kotlin.collections.List
import kotlin.collections.Map

@Validated
interface PetApi {

    @ResponseStatus(HttpStatus.OK)
    @HttpExchange(
        url = PATH_ADD_PET /* "/pet" */,
        method = "POST"
    )
    suspend fun addPet(
        @Parameter(description = "Pet object that needs to be added to the store", required = true) @Valid @RequestBody pet: Pet
    ): Pet

    @ResponseStatus(HttpStatus.BAD_REQUEST)
    @HttpExchange(
        url = PATH_DELETE_PET /* "/pet/{petId}" */,
        method = "DELETE"
    )
    suspend fun deletePet(
        @Parameter(description = "Pet id to delete", required = true) @PathVariable("petId") petId: kotlin.Long,
        @Parameter(description = "", `in` = ParameterIn.HEADER) @RequestHeader(value = "api_key", required = false) apiKey: kotlin.String?
    ): Unit

    @ResponseStatus(HttpStatus.OK)
    @HttpExchange(
        url = PATH_FIND_PETS_BY_STATUS /* "/pet/findByStatus" */,
        method = "GET"
    )
    suspend fun findPetsByStatus(
        @NotNull @Parameter(description = "Status values that need to be considered for filter", required = true, schema = Schema(allowableValues = ["available", "pending", "sold"])) @Valid @RequestParam(value = "status", required = true) status: kotlin.collections.List<kotlin.String>
    ): List<Pet>


    @ResponseStatus(HttpStatus.OK)
    @HttpExchange(
        url = PATH_FIND_PETS_BY_TAGS /* "/pet/findByTags" */,
        method = "GET"
    )
    suspend fun findPetsByTags(
        @NotNull @Parameter(description = "Tags to filter by", required = true) @Valid @RequestParam(value = "tags", required = true) tags: kotlin.collections.List<kotlin.String>
    ): List<Pet>


    @ResponseStatus(HttpStatus.OK)
    @HttpExchange(
        url = PATH_GET_PET_BY_ID /* "/pet/{petId}" */,
        method = "GET"
    )
    suspend fun getPetById(
        @Parameter(description = "ID of pet to return", required = true) @PathVariable("petId") petId: kotlin.Long
    ): Pet

    @ResponseStatus(HttpStatus.OK)
    @HttpExchange(
        url = PATH_UPDATE_PET /* "/pet" */,
        method = "PUT"
    )
    suspend fun updatePet(
        @Parameter(description = "Pet object that needs to be added to the store", required = true) @Valid @RequestBody pet: Pet
    ): Pet

    @ResponseStatus(HttpStatus.METHOD_NOT_ALLOWED)
    @HttpExchange(
        url = PATH_UPDATE_PET_WITH_FORM /* "/pet/{petId}" */,
        method = "POST"
    )
    suspend fun updatePetWithForm(
        @Parameter(description = "ID of pet that needs to be updated", required = true) @PathVariable("petId") petId: kotlin.Long,
        @Parameter(description = "Updated name of the pet") @Valid @RequestParam(value = "name", required = false) name: kotlin.String?,
        @Parameter(description = "Updated status of the pet") @Valid @RequestParam(value = "status", required = false) status: kotlin.String?
    ): Unit

    @ResponseStatus(HttpStatus.OK)
    @HttpExchange(
        url = PATH_UPLOAD_FILE /* "/pet/{petId}/uploadImage" */,
        method = "POST"
    )
    suspend fun uploadFile(
        @Parameter(description = "ID of pet to update", required = true) @PathVariable("petId") petId: kotlin.Long,
        @Parameter(description = "Additional data to pass to server") @Valid @RequestParam(value = "additionalMetadata", required = false) additionalMetadata: kotlin.String?,
        @Parameter(description = "file to upload") @Valid @RequestPart("file", required = false) file: org.springframework.web.multipart.MultipartFile
    ): ModelApiResponse

    companion object {
        //for your own safety never directly reuse these path definitions in tests
        const val PATH_ADD_PET: String = "/pet"
        const val PATH_DELETE_PET: String = "/pet/{petId}"
        const val PATH_FIND_PETS_BY_STATUS: String = "/pet/findByStatus"
        const val PATH_FIND_PETS_BY_TAGS: String = "/pet/findByTags"
        const val PATH_GET_PET_BY_ID: String = "/pet/{petId}"
        const val PATH_UPDATE_PET: String = "/pet"
        const val PATH_UPDATE_PET_WITH_FORM: String = "/pet/{petId}"
        const val PATH_UPLOAD_FILE: String = "/pet/{petId}/uploadImage"
    }
}
