/**
* NOTE: Auto generated by OpenAPI Generator (7.20.0-SNAPSHOT)
* Spring 6 Declarative HTTP Interface
*/
package org.openapitools.api

import org.openapitools.model.Order

import io.swagger.v3.oas.annotations.*
import io.swagger.v3.oas.annotations.enums.*
import io.swagger.v3.oas.annotations.media.*
import io.swagger.v3.oas.annotations.responses.*
import io.swagger.v3.oas.annotations.security.*

import org.springframework.web.service.annotation.*
import org.springframework.web.bind.annotation.*
import org.springframework.http.ResponseEntity

import org.springframework.validation.annotation.Validated
import jakarta.validation.Valid
import jakarta.validation.constraints.*


import kotlin.collections.List
import kotlin.collections.Map

@Validated
interface StoreApi {

    @HttpExchange(
        url = PATH_DELETE_ORDER /* "/store/order/{orderId}" */,
        method = "DELETE"
    )
    fun deleteOrder(
        @Parameter(description = "ID of the order that needs to be deleted", required = true) @PathVariable("orderId") orderId: kotlin.String
    ): ResponseEntity<Unit>


    @HttpExchange(
        url = PATH_GET_INVENTORY /* "/store/inventory" */,
        method = "GET"
    )
    fun getInventory(
    ): ResponseEntity<Map<String, kotlin.Int>>


    @HttpExchange(
        url = PATH_GET_ORDER_BY_ID /* "/store/order/{orderId}" */,
        method = "GET"
    )
    fun getOrderById(
        @Min(value=1L) @Max(value=5L) @Parameter(description = "ID of pet that needs to be fetched", required = true) @PathVariable("orderId") orderId: kotlin.Long
    ): ResponseEntity<Order>


    @HttpExchange(
        url = PATH_PLACE_ORDER /* "/store/order" */,
        method = "POST"
    )
    fun placeOrder(
        @Parameter(description = "order placed for purchasing the pet", required = true) @Valid @RequestBody order: Order
    ): ResponseEntity<Order>


    companion object {
        //for your own safety never directly reuse these path definitions in tests
        const val PATH_DELETE_ORDER: String = "/store/order/{orderId}"
        const val PATH_GET_INVENTORY: String = "/store/inventory"
        const val PATH_GET_ORDER_BY_ID: String = "/store/order/{orderId}"
        const val PATH_PLACE_ORDER: String = "/store/order"
    }
}
