/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (7.20.0-SNAPSHOT).
 * https://openapi-generator.tech
 * Do not edit the class manually.
*/
package org.openapitools.api

import org.openapitools.model.Order
import io.swagger.v3.oas.annotations.*
import io.swagger.v3.oas.annotations.enums.*
import io.swagger.v3.oas.annotations.media.*
import io.swagger.v3.oas.annotations.responses.*
import io.swagger.v3.oas.annotations.security.*
import org.springframework.http.HttpStatus
import org.springframework.http.MediaType
import org.springframework.http.ResponseEntity

import org.springframework.web.bind.annotation.*
import org.springframework.validation.annotation.Validated
import org.springframework.web.context.request.NativeWebRequest
import org.springframework.beans.factory.annotation.Autowired

import jakarta.validation.constraints.DecimalMax
import jakarta.validation.constraints.DecimalMin
import jakarta.validation.constraints.Email
import jakarta.validation.constraints.Max
import jakarta.validation.constraints.Min
import jakarta.validation.constraints.NotNull
import jakarta.validation.constraints.Pattern
import jakarta.validation.constraints.Size
import jakarta.validation.Valid

import kotlin.collections.List
import kotlin.collections.Map

@RestController
@Validated
interface StoreApi {

    @Operation(
        tags = ["store",],
        summary = "Delete purchase order by ID",
        operationId = "deleteOrder",
        description = """For valid response try integer IDs with value < 1000. Anything above 1000 or nonintegers will generate API errors""",
        responses = [
            ApiResponse(responseCode = "400", description = "Invalid ID supplied"),
            ApiResponse(responseCode = "404", description = "Order not found")
        ]
    )
    @RequestMapping(
        method = [RequestMethod.DELETE],
        value = [PATH_DELETE_ORDER /* "/store/order/{order_id}" */]
    )
    fun deleteOrder(
        @Parameter(description = "ID of the order that needs to be deleted", required = true) @PathVariable("order_id") orderId: kotlin.String
    ): ResponseEntity<Unit> {
        return ResponseEntity(HttpStatus.NOT_IMPLEMENTED)
    }

    @Operation(
        tags = ["store",],
        summary = "Returns pet inventories by status",
        operationId = "getInventory",
        description = """Returns a map of status codes to quantities""",
        responses = [
            ApiResponse(responseCode = "200", description = "successful operation", content = [Content(schema = Schema(implementation = kotlin.collections.Map::class))])
        ],
        security = [ SecurityRequirement(name = "api_key") ]
    )
    @RequestMapping(
        method = [RequestMethod.GET],
        value = [PATH_GET_INVENTORY /* "/store/inventory" */],
        produces = ["application/json"]
    )
    fun getInventory(): ResponseEntity<Map<String, kotlin.Int>> {
        return ResponseEntity(HttpStatus.NOT_IMPLEMENTED)
    }

    @Operation(
        tags = ["store",],
        summary = "Find purchase order by ID",
        operationId = "getOrderById",
        description = """For valid response try integer IDs with value <= 5 or > 10. Other values will generate exceptions""",
        responses = [
            ApiResponse(responseCode = "200", description = "successful operation", content = [Content(schema = Schema(implementation = Order::class))]),
            ApiResponse(responseCode = "400", description = "Invalid ID supplied"),
            ApiResponse(responseCode = "404", description = "Order not found")
        ]
    )
    @RequestMapping(
        method = [RequestMethod.GET],
        value = [PATH_GET_ORDER_BY_ID /* "/store/order/{order_id}" */],
        produces = ["application/xml", "application/json"]
    )
    fun getOrderById(
        @Min(value=1L) @Max(value=5L) @Parameter(description = "ID of pet that needs to be fetched", required = true) @PathVariable("order_id") orderId: kotlin.Long
    ): ResponseEntity<Order> {
        return ResponseEntity(HttpStatus.NOT_IMPLEMENTED)
    }

    @Operation(
        tags = ["store",],
        summary = "Place an order for a pet",
        operationId = "placeOrder",
        description = """""",
        responses = [
            ApiResponse(responseCode = "200", description = "successful operation", content = [Content(schema = Schema(implementation = Order::class))]),
            ApiResponse(responseCode = "400", description = "Invalid Order")
        ]
    )
    @RequestMapping(
        method = [RequestMethod.POST],
        value = [PATH_PLACE_ORDER /* "/store/order" */],
        produces = ["application/xml", "application/json"],
        consumes = ["application/json"]
    )
    fun placeOrder(
        @Parameter(description = "order placed for purchasing the pet", required = true) @Valid @RequestBody order: Order
    ): ResponseEntity<Order> {
        return ResponseEntity(HttpStatus.NOT_IMPLEMENTED)
    }

    companion object {
        //for your own safety never directly reuse these path definitions in tests
        const val PATH_DELETE_ORDER: String = "/store/order/{order_id}"
        const val PATH_GET_INVENTORY: String = "/store/inventory"
        const val PATH_GET_ORDER_BY_ID: String = "/store/order/{order_id}"
        const val PATH_PLACE_ORDER: String = "/store/order"
    }
}
