<?php
/**
 * Order
 *
 * PHP version 8.1.1
 *
 * @category Class
 * @package  OpenAPIServer\Model
 * @author   OpenAPI Generator team
 * @link     https://github.com/openapitools/openapi-generator
 */

/**
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 *
 * Generated by: https://github.com/openapitools/openapi-generator.git
 *
 */


namespace OpenAPIServer\Model;

/**
 * Class representing the Order model.
 *
 * An order for a pets from the pet store
 *
 * @package OpenAPIServer\Model
 * @author  OpenAPI Generator team
 */

class Order  implements \JsonSerializable
{
        /**
     * @var int|null
     * @SerializedName("id")
     * @Assert\Type("int")
     * @Type("int")
     */
    public ?int $id;

    /**
     * @var int|null
     * @SerializedName("petId")
     * @Assert\Type("int")
     * @Type("int")
     */
    public ?int $petId;

    /**
     * @var int|null
     * @SerializedName("quantity")
     * @Assert\Type("int")
     * @Type("int")
     */
    public ?int $quantity;

    /**
     * @var \DateTime|null
     * @SerializedName("shipDate")
     * @Assert\Type("\DateTime"))
     * @Type("DateTime")
     */
    public ?\DateTime $shipDate;

    /**
     * @var OrderStatus|null
     * @SerializedName("status")
        * @Accessor(getter="getSerializedStatus")
        * @Type("string")
     */
    public ?OrderStatus $status;

    /**
     * @var bool|null
     * @SerializedName("complete")
     * @Assert\Type("bool")
     * @Type("bool")
     */
    public ?bool $complete = false;

    /**
     * Constructor
     *
     * @param int|null $id
     * @param int|null $petId
     * @param int|null $quantity
     * @param \DateTime|null $shipDate
     * @param OrderStatus|null $status
     * @param bool|null $complete
     */
    public function __construct(?int $id, ?int $petId, ?int $quantity, ?\DateTime $shipDate, ?OrderStatus $status, ?bool $complete)
    {
        $this->id = $id;
        $this->petId = $petId;
        $this->quantity = $quantity;
        $this->shipDate = $shipDate;
        $this->status = $status;
        $this->complete = $complete;
    }

    public static function fromArray(array $data): self
    {
        return new self(
            $data['id'] ?? null,
            $data['petId'] ?? null,
            $data['quantity'] ?? null,
            isset($data['shipDate']) ? new \DateTime($data['shipDate']) : null,
            isset($data['status']) ? OrderStatus::tryFrom($data['status']) : null,
            $data['complete'] ?? null,
        );
    }

    public function jsonSerialize(): mixed {
        return [
            'id' => $this->id,
            'petId' => $this->petId,
            'quantity' => $this->quantity,
            'shipDate' => $this->shipDate?->format('c'),
            'status' => $this->status,
            'complete' => $this->complete,
        ];
    }
}


