<?php declare(strict_types=1);

/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 * PHP version 8.1
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI-Generator
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 * Source files are located at:
 *
 * > https://github.com/OpenAPITools/openapi-generator/blob/master/modules/openapi-generator/src/main/resources/php-laravel/
 */


namespace OpenAPI\Server\Http\Controllers;

use Crell\Serde\SerdeCommon;
use Illuminate\Routing\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


use OpenAPI\Server\Api\PetApiInterface;

class PetController extends Controller
{
    /**
     * Constructor
     */
    public function __construct(
        private readonly PetApiInterface $api,
        private readonly SerdeCommon $serde = new SerdeCommon(),
    )
    {
    }

    /**
     * Operation addPet
     *
     * Add a new pet to the store.
     *
     */
    public function addPet(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $pet = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\Pet::class);


        $apiResult = $this->api->addPet($pet);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent405) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 405);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation deletePet
     *
     * Deletes a pet.
     *
     */
    public function deletePet(Request $request, int $petId): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    'petId' => $petId,
                ],
                $request->all(),
            ),
            [
                'petId' => [
                    'required',
                    'integer',
                ],
                'apiKey' => [
                    'string',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }


        $apiKey = $request->string('apiKey')->value();


        $apiResult = $this->api->deletePet($petId, $apiKey);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation findPetsByStatus
     *
     * Finds Pets by status.
     *
     */
    public function findPetsByStatus(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
                'status' => [
                    'required',
                    'array',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $status = $request->get('status');


        $apiResult = $this->api->findPetsByStatus($status);

        if (is_array($apiResult)) {
            $serialized = array_map(fn ($item) => $this->serde->serialize($item, format: 'array'), $apiResult);
            return response()->json($serialized, 200);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation findPetsByTags
     *
     * Finds Pets by tags.
     *
     * @deprecated
     */
    public function findPetsByTags(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
                'tags' => [
                    'required',
                    'array',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $tags = $request->get('tags');


        $apiResult = $this->api->findPetsByTags($tags);

        if (is_array($apiResult)) {
            $serialized = array_map(fn ($item) => $this->serde->serialize($item, format: 'array'), $apiResult);
            return response()->json($serialized, 200);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation getPetById
     *
     * Find pet by ID.
     *
     */
    public function getPetById(Request $request, int $petId): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    'petId' => $petId,
                ],
                $request->all(),
            ),
            [
                'petId' => [
                    'required',
                    'integer',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }



        $apiResult = $this->api->getPetById($petId);

        if ($apiResult instanceof \OpenAPI\Server\Model\Pet) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent404) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 404);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation updatePet
     *
     * Update an existing pet.
     *
     */
    public function updatePet(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $pet = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\Pet::class);


        $apiResult = $this->api->updatePet($pet);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent404) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 404);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent405) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 405);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation updatePetWithForm
     *
     * Updates a pet in the store with form data.
     *
     */
    public function updatePetWithForm(Request $request, int $petId): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    'petId' => $petId,
                ],
                $request->all(),
            ),
            [
                'petId' => [
                    'required',
                    'integer',
                ],
                'name' => [
                    'string',
                ],
                'status' => [
                    'string',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }


        $name = $request->string('name')->value();

        $status = $request->string('status')->value();


        $apiResult = $this->api->updatePetWithForm($petId, $name, $status);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent200) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent405) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 405);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation uploadFile
     *
     * uploads an image.
     *
     */
    public function uploadFile(Request $request, int $petId): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    'petId' => $petId,
                ],
                $request->all(),
            ),
            [
                'petId' => [
                    'required',
                    'integer',
                ],
                'additionalMetadata' => [
                    'string',
                ],
                'file' => [
                    'file',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }


        $additionalMetadata = $request->string('additionalMetadata')->value();

        $file = $request->file('file');


        $apiResult = $this->api->uploadFile($petId, $additionalMetadata, $file);

        if ($apiResult instanceof \OpenAPI\Server\Model\ApiResponse) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation uploadFileWithRequiredFile
     *
     * uploads an image (required).
     *
     */
    public function uploadFileWithRequiredFile(Request $request, int $petId): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    'petId' => $petId,
                ],
                $request->all(),
            ),
            [
                'petId' => [
                    'required',
                    'integer',
                ],
                'requiredFile' => [
                    'file',
                    'required',
                ],
                'additionalMetadata' => [
                    'string',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }


        $requiredFile = $request->file('requiredFile');

        $additionalMetadata = $request->string('additionalMetadata')->value();


        $apiResult = $this->api->uploadFileWithRequiredFile($petId, $requiredFile, $additionalMetadata);

        if ($apiResult instanceof \OpenAPI\Server\Model\ApiResponse) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
}
