<?php declare(strict_types=1);

/**
 * OpenAPI Petstore
 * This spec is mainly for testing Petstore server and contains fake endpoints, models. Please do not use this for any other purpose. Special characters: \" \\
 * PHP version 8.1
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI-Generator
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 * Source files are located at:
 *
 * > https://github.com/OpenAPITools/openapi-generator/blob/master/modules/openapi-generator/src/main/resources/php-laravel/
 */


namespace OpenAPI\Server\Http\Controllers;

use Crell\Serde\SerdeCommon;
use Illuminate\Routing\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


use OpenAPI\Server\Api\UserApiInterface;

class UserController extends Controller
{
    /**
     * Constructor
     */
    public function __construct(
        private readonly UserApiInterface $api,
        private readonly SerdeCommon $serde = new SerdeCommon(),
    )
    {
    }

    /**
     * Operation createUser
     *
     * Create user.
     *
     */
    public function createUser(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $user = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\User::class);


        $apiResult = $this->api->createUser($user);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContentDefault) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 0);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation createUsersWithArrayInput
     *
     * Creates list of users with given input array.
     *
     */
    public function createUsersWithArrayInput(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $user = $request->get('user');


        $apiResult = $this->api->createUsersWithArrayInput($user);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContentDefault) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 0);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation createUsersWithListInput
     *
     * Creates list of users with given input array.
     *
     */
    public function createUsersWithListInput(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $user = $request->get('user');


        $apiResult = $this->api->createUsersWithListInput($user);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContentDefault) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 0);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation deleteUser
     *
     * Delete user.
     *
     */
    public function deleteUser(Request $request, string $username): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    'username' => $username,
                ],
                $request->all(),
            ),
            [
                'username' => [
                    'required',
                    'string',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }



        $apiResult = $this->api->deleteUser($username);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent404) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 404);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation getUserByName
     *
     * Get user by user name.
     *
     */
    public function getUserByName(Request $request, string $username): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    'username' => $username,
                ],
                $request->all(),
            ),
            [
                'username' => [
                    'required',
                    'string',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }



        $apiResult = $this->api->getUserByName($username);

        if ($apiResult instanceof \OpenAPI\Server\Model\User) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent404) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 404);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation loginUser
     *
     * Logs user into the system.
     *
     */
    public function loginUser(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
                'username' => [
                    'required',
                    'string',
                ],
                'password' => [
                    'required',
                    'string',
                ],
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        $username = $request->string('username')->value();

        $password = $request->string('password')->value();


        $apiResult = $this->api->loginUser($username, $password);

        if ($apiResult instanceof string) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 200);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation logoutUser
     *
     * Logs out current logged in user session.
     *
     */
    public function logoutUser(Request $request): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }


        $apiResult = $this->api->logoutUser();

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContentDefault) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 0);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
    /**
     * Operation updateUser
     *
     * Updated user.
     *
     */
    public function updateUser(Request $request, string $username): JsonResponse
    {
        $validator = Validator::make(
            array_merge(
                [
                    'username' => $username,
                ],
                $request->all(),
            ),
            [
            ],
        );

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }


        $user = $this->serde->deserialize($request->getContent(), from: 'json', to: \OpenAPI\Server\Model\User::class);


        $apiResult = $this->api->updateUser($username, $user);

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent400) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 400);
        }

        if ($apiResult instanceof \OpenAPI\Server\Model\NoContent404) {
            return response()->json($this->serde->serialize($apiResult, format: 'array'), 404);
        }


        // This shouldn't happen
        return response()->abort(500);
    }
}
