# OpenAPI generated server

Generated by the [OpenAPI Generator](https://openapi-generator.tech) project.

## Overview
This server stub aims to provide light, yet comprehensive structure for your API project using:

- PHP: >=8.1
- [Laminas Mezzio](https://docs.mezzio.dev/mezzio/): >=3.2
- [Path Handler](https://github.com/Articus/PathHandler): >=0.7

## How to use
All you have to do to start development is:

- install dependencies via [Composer](https://getcomposer.org/) (small note: [ext-yaml](https://pecl.php.net/package/yaml) is used only for configuration parsing, so if you want to drop this dependency, simply adjust `./application/container.php`)
- create cache folder: `mkdir -p ./data/cache` (you will need it later for configuration and metadata caches - check comments in `./application/config.yml`)
- start PHP development server: `php -S 0.0.0.0:8080 -t ./public` (or any other SAPI you prefer, just make sure that you configure webroot to `./public` and rewrites to `./public/index.php`)

After that you should be able to call all methods from your API spec. Most of the negative scenarios should be handled:

- `404 Not found` for unknown routes
- `406 Not acceptable` for invalid `Accept` header
- `415 Unsupported media type` for invalid `Content-Type` header
- `400 Malformed JSON` for unparsable JSON body
- `422 Unprocessable entity` for parsable JSON body that fails validation

But for obvious reason you will not get any `200 OK`, only `501 Not implemented`. So your next steps are:

- check all TODOs left in the stub code where generator was not smart enough and could not guarantee correct implementation
- implement your API security mechanism (either special attribute or separate middleware) - generator does not do anything about it yet
- implement your handlers - the most tricky part :)

## Enjoy!
Hopefully this stub will reduce the amount of boilerplate code you have to write manually. If you have any suggestions or questions about `php-mezzio-ph` generator, feel free to create issue either in [Path Handler repository](https://github.com/Articus/PathHandler/issues) or in [OpenAPI Generator repository](https://openapi-generator.tech/issues).
