<?php
/**
 * StoreApiInterface
 *
 * PHP version 8.1.1
 *
 * @category Class
 * @package  OpenAPI\Server
 * @author   OpenAPI Generator team
 * @link     https://github.com/openapitools/openapi-generator
 */

/**
 * OpenAPI Petstore
 *
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 * Generated by: https://github.com/openapitools/openapi-generator.git
 *
 */

/**
 * NOTE: This class is auto generated by the openapi generator program.
 * https://github.com/openapitools/openapi-generator
 * Do not edit the class manually.
 */

namespace OpenAPI\Server\Api;

use Symfony\Component\HttpFoundation\File\UploadedFile;
use OpenAPI\Server\Model\Order;

/**
 * StoreApiInterface Interface Doc Comment
 *
 * @category Interface
 * @package  OpenAPI\Server\Api
 * @author   OpenAPI Generator team
 * @link     https://github.com/openapitools/openapi-generator
 */
interface StoreApiInterface
{

    /**
     * Sets authentication method api_key
     *
     * @param string|null $value Value of the api_key authentication method.
     *
     * @return void
     */
    public function setapi_key(?string $value): void;

    /**
     * Operation deleteOrder
     *
     * Delete purchase order by ID
     *
     * @param  string $orderId  ID of the order that needs to be deleted (required)
     * @param  int     &$responseCode    The HTTP Response Code
     * @param  array   $responseHeaders  Additional HTTP headers to return with the response ()
     *
     * @return void
     */
    public function deleteOrder(
        string $orderId,
        int &$responseCode,
        array &$responseHeaders
    ): void;

    /**
     * Operation getInventory
     *
     * Returns pet inventories by status
     *
     * @param  int     &$responseCode    The HTTP Response Code
     * @param  array   $responseHeaders  Additional HTTP headers to return with the response ()
     *
     * @return array|object|null
     */
    public function getInventory(
        int &$responseCode,
        array &$responseHeaders
    ): array|object|null;

    /**
     * Operation getOrderById
     *
     * Find purchase order by ID
     *
     * @param  int $orderId  ID of pet that needs to be fetched (required)
     * @param  int     &$responseCode    The HTTP Response Code
     * @param  array   $responseHeaders  Additional HTTP headers to return with the response ()
     *
     * @return array|object|null
     */
    public function getOrderById(
        int $orderId,
        int &$responseCode,
        array &$responseHeaders
    ): array|object|null;

    /**
     * Operation placeOrder
     *
     * Place an order for a pet
     *
     * @param  Order $order  order placed for purchasing the pet (required)
     * @param  int     &$responseCode    The HTTP Response Code
     * @param  array   $responseHeaders  Additional HTTP headers to return with the response ()
     *
     * @return array|object|null
     */
    public function placeOrder(
        Order $order,
        int &$responseCode,
        array &$responseHeaders
    ): array|object|null;
}
