# Rust API for ops-v3

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

## Overview

This client/server was generated by the [openapi-generator]
(https://openapi-generator.tech) project.  By using the
[OpenAPI-Spec](https://github.com/OAI/OpenAPI-Specification) from a remote
server, you can easily generate a server stub.

To see how to make this your own, look here:

[README]((https://openapi-generator.tech))

- API version: 0.0.1
- Generator version: 7.20.0-SNAPSHOT



This autogenerated project defines an API crate `ops-v3` which contains:
* An `Api` trait defining the API in Rust.
* Data types representing the underlying data model.
* A `Client` type which implements `Api` and issues HTTP requests for each operation.
* A router which accepts HTTP requests and invokes the appropriate `Api` method for each operation.
* A CLI tool to drive basic API operations from the command line.

It also contains an example server and client which make use of `ops-v3`:

* The example server starts up a web server using the `ops-v3`
    router, and supplies a trivial implementation of `Api` which returns failure
    for every operation.
* The example client provides a CLI which lets you invoke
    any single operation on the `ops-v3` client by passing appropriate
    arguments on the command line.

You can use the example server and client as a basis for your own code.
See below for [more detail on the examples](#using-the-generated-library).

## CLI

Run the included CLI tool with:

```
cargo run --bin cli --features=cli
```

To pass in arguments, put them after `--`, for example:

```
cargo run --bin cli --features=cli -- --help
```

See the help text for available options.

To build a standalone tool, use:

```
cargo build --bin cli --features=cli --release
```

You'll find the binary at `target/release/cli`.

## Examples

Run examples with:

```
cargo run --example <example-name>
```

To pass in arguments to the examples, put them after `--`, for example:

```
cargo run --example client -- --help
```

### Running the example server
To run the server, follow these simple steps:

```
cargo run --example server
```

### Running the example client
To run a client, follow one of the following simple steps:

```
cargo run --example client Op10Get
cargo run --example client Op11Get
cargo run --example client Op12Get
cargo run --example client Op13Get
cargo run --example client Op14Get
cargo run --example client Op15Get
cargo run --example client Op16Get
cargo run --example client Op17Get
cargo run --example client Op18Get
cargo run --example client Op19Get
cargo run --example client Op1Get
cargo run --example client Op20Get
cargo run --example client Op21Get
cargo run --example client Op22Get
cargo run --example client Op23Get
cargo run --example client Op24Get
cargo run --example client Op25Get
cargo run --example client Op26Get
cargo run --example client Op27Get
cargo run --example client Op28Get
cargo run --example client Op29Get
cargo run --example client Op2Get
cargo run --example client Op30Get
cargo run --example client Op31Get
cargo run --example client Op32Get
cargo run --example client Op33Get
cargo run --example client Op34Get
cargo run --example client Op35Get
cargo run --example client Op36Get
cargo run --example client Op37Get
cargo run --example client Op3Get
cargo run --example client Op4Get
cargo run --example client Op5Get
cargo run --example client Op6Get
cargo run --example client Op7Get
cargo run --example client Op8Get
cargo run --example client Op9Get
```

### HTTPS
The examples can be run in HTTPS mode by passing in the flag `--https`, for example:

```
cargo run --example server -- --https
```

This will use the keys/certificates from the examples directory. Note that the
server chain is signed with `CN=localhost`.

## Using the generated library

The generated library has a few optional features that can be activated through Cargo.

* `server`
    * This defaults to enabled and creates the basic skeleton of a server implementation based on hyper
    * To create the server stack you'll need to provide an implementation of the API trait to provide the server function.
* `client`
    * This defaults to enabled and creates the basic skeleton of a client implementation based on hyper
    * The constructed client implements the API trait by making remote API call.
* `conversions`
    * This defaults to disabled and creates extra derives on models to allow "transmogrification" between objects of structurally similar types.
* `cli`
    * This defaults to disabled and is required for building the included CLI tool.
* `validate`
    * This defaults to disabled and allows JSON Schema validation of received data using `MakeService::set_validation` or `Service::set_validation`.
    * Note, enabling validation will have a performance penalty, especially if the API heavily uses regex based checks.

See https://doc.rust-lang.org/cargo/reference/manifest.html#the-features-section for how to use features in your `Cargo.toml`.

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[****](docs/default_api.md#) | **GET** /op10 | 
[****](docs/default_api.md#) | **GET** /op11 | 
[****](docs/default_api.md#) | **GET** /op12 | 
[****](docs/default_api.md#) | **GET** /op13 | 
[****](docs/default_api.md#) | **GET** /op14 | 
[****](docs/default_api.md#) | **GET** /op15 | 
[****](docs/default_api.md#) | **GET** /op16 | 
[****](docs/default_api.md#) | **GET** /op17 | 
[****](docs/default_api.md#) | **GET** /op18 | 
[****](docs/default_api.md#) | **GET** /op19 | 
[****](docs/default_api.md#) | **GET** /op1 | 
[****](docs/default_api.md#) | **GET** /op20 | 
[****](docs/default_api.md#) | **GET** /op21 | 
[****](docs/default_api.md#) | **GET** /op22 | 
[****](docs/default_api.md#) | **GET** /op23 | 
[****](docs/default_api.md#) | **GET** /op24 | 
[****](docs/default_api.md#) | **GET** /op25 | 
[****](docs/default_api.md#) | **GET** /op26 | 
[****](docs/default_api.md#) | **GET** /op27 | 
[****](docs/default_api.md#) | **GET** /op28 | 
[****](docs/default_api.md#) | **GET** /op29 | 
[****](docs/default_api.md#) | **GET** /op2 | 
[****](docs/default_api.md#) | **GET** /op30 | 
[****](docs/default_api.md#) | **GET** /op31 | 
[****](docs/default_api.md#) | **GET** /op32 | 
[****](docs/default_api.md#) | **GET** /op33 | 
[****](docs/default_api.md#) | **GET** /op34 | 
[****](docs/default_api.md#) | **GET** /op35 | 
[****](docs/default_api.md#) | **GET** /op36 | 
[****](docs/default_api.md#) | **GET** /op37 | 
[****](docs/default_api.md#) | **GET** /op3 | 
[****](docs/default_api.md#) | **GET** /op4 | 
[****](docs/default_api.md#) | **GET** /op5 | 
[****](docs/default_api.md#) | **GET** /op6 | 
[****](docs/default_api.md#) | **GET** /op7 | 
[****](docs/default_api.md#) | **GET** /op8 | 
[****](docs/default_api.md#) | **GET** /op9 | 


## Documentation For Models



## Documentation For Authorization
Endpoints do not require authorization.


## Author



