//> using scala "3.3.1"
//> using lib "com.lihaoyi::cask:0.8.3"
//> using lib "com.lihaoyi::scalatags:0.12.0"
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 *
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 *
 * https://openapi-generator.tech
 */


// this is generated from apiRoutes.mustache
package sample.cask.api

import sample.cask.model.*

import upickle.default.{ReadWriter => RW, macroRW}
import upickle.default.*
import scala.util.Try

import sample.cask.model.OneOfRequestAndResponse200Response
import sample.cask.model.OneOfRequestAndResponseRequest

class ComplexRouteRoutes(service : ComplexRouteService[Try]) extends cask.Routes {


        /** Example route with &#39;oneOf&#39; content and response
         * 
         */
        @cask.post("/complex-types")
        def oneOfRequestAndResponse(request: cask.Request) = {

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
              oneOfRequestAndResponseRequestJson <- Parsed.fromTry(request.bodyAsJson)
              oneOfRequestAndResponseRequestData <- Parsed.eval(OneOfRequestAndResponseRequestData.fromJson(oneOfRequestAndResponseRequestJson)) /* not array or map */
              oneOfRequestAndResponseRequest <- Parsed.fromTry(OneOfRequestAndResponseRequestData.validated(oneOfRequestAndResponseRequestData, failFast))
            resultTry <- Parsed.eval(service.oneOfRequestAndResponse(oneOfRequestAndResponseRequest))
            result <- Parsed.fromTry(resultTry)
        } yield result

        import OneOfRequestAndResponse200Response.{given, *} // this brings in upickle in the case of union (oneOf) types

        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(value : OneOfRequestAndResponse200Response) => cask.Response(data = write(value), 200, headers = Seq("Content-Type" -> "application/json"))
          case Right(other) => cask.Response(s"$other", 200)
        }
      }

    initialize()
}
