//> using scala "3.3.1"
//> using lib "com.lihaoyi::cask:0.8.3"
//> using lib "com.lihaoyi::scalatags:0.12.0"
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 *
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 *
 * https://openapi-generator.tech
 */


// this is generated from apiRoutes.mustache
package sample.cask.api

import sample.cask.model.*

import upickle.default.{ReadWriter => RW, macroRW}
import upickle.default.*
import scala.util.Try

import sample.cask.model.Order

class StoreRoutes(service : StoreService[Try]) extends cask.Routes {


        /** Delete purchase order by ID
         * 
         */
        @cask.delete("/store/order/:orderId")
        def deleteOrder(orderId : String, request: cask.Request) = {

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
            orderId <- Parsed(orderId)
            resultTry <- Parsed.eval(service.deleteOrder(orderId))
            result <- Parsed.fromTry(resultTry)
        } yield result


        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(other) => cask.Response(s"$other", 200)
        }
      }
        /** Returns pet inventories by status
         * 
         */
        @cask.get("/store/inventory")
        def getInventory(request: cask.Request) = {
            // auth method api_key : apiKey, keyParamName: api_key

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
            resultTry <- Parsed.eval(service.getInventory())
            result <- Parsed.fromTry(resultTry)
        } yield result


        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(value : Map[String, Int]) => cask.Response(data = write(value), 200, headers = Seq("Content-Type" -> "application/json"))
          case Right(other) => cask.Response(s"$other", 200)
        }
      }
        /** Find purchase order by ID
         * 
         */
        @cask.get("/store/order/:orderId")
        def getOrderById(orderId : Long, request: cask.Request) = {

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
            orderId <- Parsed(orderId)
            resultTry <- Parsed.eval(service.getOrderById(orderId))
            result <- Parsed.fromTry(resultTry)
        } yield result

        import Order.{given, *} // this brings in upickle in the case of union (oneOf) types

        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(value : Order) => cask.Response(data = write(value), 200, headers = Seq("Content-Type" -> "application/json"))
          case Right(other) => cask.Response(s"$other", 200)
        }
      }
        /** Place an order for a pet
         * 
         */
        @cask.post("/store/order")
        def placeOrder(request: cask.Request) = {

        def failFast = request.queryParams.keySet.contains("failFast")

        val result =         for {
              orderJson <- Parsed.fromTry(request.bodyAsJson)
              orderData <- Parsed.eval(OrderData.fromJson(orderJson)) /* not array or map */
              order <- Parsed.fromTry(OrderData.validated(orderData, failFast))
            resultTry <- Parsed.eval(service.placeOrder(order))
            result <- Parsed.fromTry(resultTry)
        } yield result

        import Order.{given, *} // this brings in upickle in the case of union (oneOf) types

        (result : @unchecked) match {
          case Left(error) => cask.Response(error, 500)
          case Right(value : Order) => cask.Response(data = write(value), 200, headers = Seq("Content-Type" -> "application/json"))
          case Right(other) => cask.Response(s"$other", 200)
        }
      }

    initialize()
}
