//> using scala "3.3.1"
//> using lib "com.lihaoyi::cask:0.8.3"
//> using lib "com.lihaoyi::scalatags:0.12.0"
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 *
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 *
 * https://openapi-generator.tech
 */


// generated from apiService.mustache
package sample.cask.api

import _root_.sample.cask.model.ApiResponse
import _root_.java.io.File
import _root_.sample.cask.model.Pet
import scala.util.Failure
import scala.util.Try
import _root_.sample.cask.model.*

/**
 * The PetService companion object.
 *
 * Use the PetService() companion object to create an instance which returns a 'not implemented' error
 * for each operation.
 *
 */
object PetService {

  /**
   * The 'Handler' is an implementation of PetService convenient for delegating or overriding individual functions
   */
  case class Handler[F[_]](
        addPetHandler : (pet : Pet) => F[Pet], 
        deletePetHandler : (petId : Long, apiKey : Option[String]) => F[Unit], 
        findPetsByStatusHandler : (status : Seq[String]) => F[List[Pet]], 
        findPetsByTagsHandler : (tags : Seq[String]) => F[List[Pet]], 
        getPetByIdHandler : (petId : Long) => F[Pet], 
        updatePetHandler : (pet : Pet) => F[Pet], 
        updatePetWithFormHandler : (petId : Long, name : Option[String], status : Option[String]) => F[Unit], 
        uploadFileHandler : (petId : Long, additionalMetadata : Option[String], file : Option[File]) => F[ApiResponse]
  ) extends PetService[F] {

        override def addPet(pet : Pet) : F[Pet] = {
          addPetHandler(pet)
        }

        override def deletePet(petId : Long, apiKey : Option[String]) : F[Unit] = {
          deletePetHandler(petId, apiKey)
        }

        override def findPetsByStatus(status : Seq[String]) : F[List[Pet]] = {
          findPetsByStatusHandler(status)
        }

        override def findPetsByTags(tags : Seq[String]) : F[List[Pet]] = {
          findPetsByTagsHandler(tags)
        }

        override def getPetById(petId : Long) : F[Pet] = {
          getPetByIdHandler(petId)
        }

        override def updatePet(pet : Pet) : F[Pet] = {
          updatePetHandler(pet)
        }

        override def updatePetWithForm(petId : Long, name : Option[String], status : Option[String]) : F[Unit] = {
          updatePetWithFormHandler(petId, name, status)
        }

        override def uploadFile(petId : Long, additionalMetadata : Option[String], file : Option[File]) : F[ApiResponse] = {
          uploadFileHandler(petId, additionalMetadata, file)
        }
  }

  def apply() : PetService[Try] = PetService.Handler[Try](
        (_) => notImplemented("addPet"), 
        (_, _) => notImplemented("deletePet"), 
        (_) => notImplemented("findPetsByStatus"), 
        (_) => notImplemented("findPetsByTags"), 
        (_) => notImplemented("getPetById"), 
        (_) => notImplemented("updatePet"), 
        (_, _, _) => notImplemented("updatePetWithForm"), 
        (_, _, _) => notImplemented("uploadFile")
  )

  private def notImplemented(name : String) = Failure(new Exception(s"TODO: $name not implemented"))
}

/**
 * The Pet business-logic
 *
 *
 * The 'asHandler' will return an implementation which allows for easily overriding individual operations.
 *
 * equally there are "on&lt;Function&gt;" helper methods for easily overriding individual functions
 *
 * @tparam F the effect type (Future, Try, IO, ID, etc) of the operations
 */
trait PetService[F[_]] {
  /** Add a new pet to the store
   * 
   * @return Pet
   */
  def addPet(pet : Pet) : F[Pet]

  /**
   * override addPet with the given handler
   * @return a new implementation of PetService[F] with addPet overridden using the given handler
   */
  final def onAddPet(handler : (pet : Pet) => F[Pet]) : PetService[F] = {
    asHandler.copy(addPetHandler = handler)
  }
  /** Deletes a pet
   * 
   * @return 
   */
  def deletePet(petId : Long, apiKey : Option[String]) : F[Unit]

  /**
   * override deletePet with the given handler
   * @return a new implementation of PetService[F] with deletePet overridden using the given handler
   */
  final def onDeletePet(handler : (petId : Long, apiKey : Option[String]) => F[Unit]) : PetService[F] = {
    asHandler.copy(deletePetHandler = handler)
  }
  /** Finds Pets by status
   * 
   * @return List[Pet]
   */
  def findPetsByStatus(status : Seq[String]) : F[List[Pet]]

  /**
   * override findPetsByStatus with the given handler
   * @return a new implementation of PetService[F] with findPetsByStatus overridden using the given handler
   */
  final def onFindPetsByStatus(handler : (status : Seq[String]) => F[List[Pet]]) : PetService[F] = {
    asHandler.copy(findPetsByStatusHandler = handler)
  }
  /** Finds Pets by tags
   * 
   * @return List[Pet]
   */
  def findPetsByTags(tags : Seq[String]) : F[List[Pet]]

  /**
   * override findPetsByTags with the given handler
   * @return a new implementation of PetService[F] with findPetsByTags overridden using the given handler
   */
  final def onFindPetsByTags(handler : (tags : Seq[String]) => F[List[Pet]]) : PetService[F] = {
    asHandler.copy(findPetsByTagsHandler = handler)
  }
  /** Find pet by ID
   * 
   * @return Pet
   */
  def getPetById(petId : Long) : F[Pet]

  /**
   * override getPetById with the given handler
   * @return a new implementation of PetService[F] with getPetById overridden using the given handler
   */
  final def onGetPetById(handler : (petId : Long) => F[Pet]) : PetService[F] = {
    asHandler.copy(getPetByIdHandler = handler)
  }
  /** Update an existing pet
   * 
   * @return Pet
   */
  def updatePet(pet : Pet) : F[Pet]

  /**
   * override updatePet with the given handler
   * @return a new implementation of PetService[F] with updatePet overridden using the given handler
   */
  final def onUpdatePet(handler : (pet : Pet) => F[Pet]) : PetService[F] = {
    asHandler.copy(updatePetHandler = handler)
  }
  /** Updates a pet in the store with form data
   * 
   * @return 
   */
  def updatePetWithForm(petId : Long, name : Option[String], status : Option[String]) : F[Unit]

  /**
   * override updatePetWithForm with the given handler
   * @return a new implementation of PetService[F] with updatePetWithForm overridden using the given handler
   */
  final def onUpdatePetWithForm(handler : (petId : Long, name : Option[String], status : Option[String]) => F[Unit]) : PetService[F] = {
    asHandler.copy(updatePetWithFormHandler = handler)
  }
  /** uploads an image
   * 
   * @return ApiResponse
   */
  def uploadFile(petId : Long, additionalMetadata : Option[String], file : Option[File]) : F[ApiResponse]

  /**
   * override uploadFile with the given handler
   * @return a new implementation of PetService[F] with uploadFile overridden using the given handler
   */
  final def onUploadFile(handler : (petId : Long, additionalMetadata : Option[String], file : Option[File]) => F[ApiResponse]) : PetService[F] = {
    asHandler.copy(uploadFileHandler = handler)
  }

  /**
   * @return a Handler implementation of this service
   */
  final def asHandler : PetService.Handler[F] = this match {
      case h : PetService.Handler[F] => h
      case _ =>
        PetService.Handler[F](
              (pet) => addPet(pet), 
              (petId, apiKey) => deletePet(petId, apiKey), 
              (status) => findPetsByStatus(status), 
              (tags) => findPetsByTags(tags), 
              (petId) => getPetById(petId), 
              (pet) => updatePet(pet), 
              (petId, name, status) => updatePetWithForm(petId, name, status), 
              (petId, additionalMetadata, file) => uploadFile(petId, additionalMetadata, file)
        )
  }

  /**
   * This function will change the effect type of this service.
   *
   * It's not unlike a typical map operation from A => B, except we're not mapping
   * a type from A to B, but rather from F[A] => G[A] using the 'changeEffect' function.
   *
   * For, this could turn an asynchronous service (one which returns Future[_] types) into
   * a synchronous one (one which returns Try[_] types) by awaiting on the Future.
   *
   * It could change an IO type (like cats effect or ZIO) into an ID[A] which is just:
   * ```
   * type ID[A] => A
   * ```
   *
   * @tparam G the new "polymorphic" effect type
   * @param changeEffect the "natural transformation" which can change one effect type into another
   * @return a new PetService service implementation with effect type [G]
   */
  final def mapEffect[G[_]](changeEffect : [A] => F[A] => G[A]) : PetService[G] = {
    val self = this

    new PetService[G] {
        override def addPet(pet : Pet) : G[Pet] = changeEffect {
          self.addPet(pet)
        }
        override def deletePet(petId : Long, apiKey : Option[String]) : G[Unit] = changeEffect {
          self.deletePet(petId, apiKey)
        }
        override def findPetsByStatus(status : Seq[String]) : G[List[Pet]] = changeEffect {
          self.findPetsByStatus(status)
        }
        override def findPetsByTags(tags : Seq[String]) : G[List[Pet]] = changeEffect {
          self.findPetsByTags(tags)
        }
        override def getPetById(petId : Long) : G[Pet] = changeEffect {
          self.getPetById(petId)
        }
        override def updatePet(pet : Pet) : G[Pet] = changeEffect {
          self.updatePet(pet)
        }
        override def updatePetWithForm(petId : Long, name : Option[String], status : Option[String]) : G[Unit] = changeEffect {
          self.updatePetWithForm(petId, name, status)
        }
        override def uploadFile(petId : Long, additionalMetadata : Option[String], file : Option[File]) : G[ApiResponse] = changeEffect {
          self.uploadFile(petId, additionalMetadata, file)
        }
    }
  }
}
