//> using scala "3.3.1"
//> using lib "com.lihaoyi::cask:0.8.3"
//> using lib "com.lihaoyi::scalatags:0.12.0"
/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 *
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 *
 * https://openapi-generator.tech
 */


// generated from apiService.mustache
package sample.cask.api

import _root_.java.time.OffsetDateTime
import _root_.sample.cask.model.User
import scala.util.Failure
import scala.util.Try
import _root_.sample.cask.model.*

/**
 * The UserService companion object.
 *
 * Use the UserService() companion object to create an instance which returns a 'not implemented' error
 * for each operation.
 *
 */
object UserService {

  /**
   * The 'Handler' is an implementation of UserService convenient for delegating or overriding individual functions
   */
  case class Handler[F[_]](
        createUserHandler : (user : User) => F[Unit], 
        createUsersWithArrayInputHandler : (user : Seq[User]) => F[Unit], 
        createUsersWithListInputHandler : (user : Seq[User]) => F[Unit], 
        deleteUserHandler : (username : String) => F[Unit], 
        getUserByNameHandler : (username : String) => F[User], 
        loginUserHandler : (username : String, password : String) => F[String], 
        logoutUserHandler : () => F[Unit], 
        updateUserHandler : (username : String, user : User) => F[Unit]
  ) extends UserService[F] {

        override def createUser(user : User) : F[Unit] = {
          createUserHandler(user)
        }

        override def createUsersWithArrayInput(user : Seq[User]) : F[Unit] = {
          createUsersWithArrayInputHandler(user)
        }

        override def createUsersWithListInput(user : Seq[User]) : F[Unit] = {
          createUsersWithListInputHandler(user)
        }

        override def deleteUser(username : String) : F[Unit] = {
          deleteUserHandler(username)
        }

        override def getUserByName(username : String) : F[User] = {
          getUserByNameHandler(username)
        }

        override def loginUser(username : String, password : String) : F[String] = {
          loginUserHandler(username, password)
        }

        override def logoutUser() : F[Unit] = {
          logoutUserHandler()
        }

        override def updateUser(username : String, user : User) : F[Unit] = {
          updateUserHandler(username, user)
        }
  }

  def apply() : UserService[Try] = UserService.Handler[Try](
        (_) => notImplemented("createUser"), 
        (_) => notImplemented("createUsersWithArrayInput"), 
        (_) => notImplemented("createUsersWithListInput"), 
        (_) => notImplemented("deleteUser"), 
        (_) => notImplemented("getUserByName"), 
        (_, _) => notImplemented("loginUser"), 
        () => notImplemented("logoutUser"), 
        (_, _) => notImplemented("updateUser")
  )

  private def notImplemented(name : String) = Failure(new Exception(s"TODO: $name not implemented"))
}

/**
 * The User business-logic
 *
 *
 * The 'asHandler' will return an implementation which allows for easily overriding individual operations.
 *
 * equally there are "on&lt;Function&gt;" helper methods for easily overriding individual functions
 *
 * @tparam F the effect type (Future, Try, IO, ID, etc) of the operations
 */
trait UserService[F[_]] {
  /** Create user
   * 
   * @return 
   */
  def createUser(user : User) : F[Unit]

  /**
   * override createUser with the given handler
   * @return a new implementation of UserService[F] with createUser overridden using the given handler
   */
  final def onCreateUser(handler : (user : User) => F[Unit]) : UserService[F] = {
    asHandler.copy(createUserHandler = handler)
  }
  /** Creates list of users with given input array
   * 
   * @return 
   */
  def createUsersWithArrayInput(user : Seq[User]) : F[Unit]

  /**
   * override createUsersWithArrayInput with the given handler
   * @return a new implementation of UserService[F] with createUsersWithArrayInput overridden using the given handler
   */
  final def onCreateUsersWithArrayInput(handler : (user : Seq[User]) => F[Unit]) : UserService[F] = {
    asHandler.copy(createUsersWithArrayInputHandler = handler)
  }
  /** Creates list of users with given input array
   * 
   * @return 
   */
  def createUsersWithListInput(user : Seq[User]) : F[Unit]

  /**
   * override createUsersWithListInput with the given handler
   * @return a new implementation of UserService[F] with createUsersWithListInput overridden using the given handler
   */
  final def onCreateUsersWithListInput(handler : (user : Seq[User]) => F[Unit]) : UserService[F] = {
    asHandler.copy(createUsersWithListInputHandler = handler)
  }
  /** Delete user
   * 
   * @return 
   */
  def deleteUser(username : String) : F[Unit]

  /**
   * override deleteUser with the given handler
   * @return a new implementation of UserService[F] with deleteUser overridden using the given handler
   */
  final def onDeleteUser(handler : (username : String) => F[Unit]) : UserService[F] = {
    asHandler.copy(deleteUserHandler = handler)
  }
  /** Get user by user name
   * 
   * @return User
   */
  def getUserByName(username : String) : F[User]

  /**
   * override getUserByName with the given handler
   * @return a new implementation of UserService[F] with getUserByName overridden using the given handler
   */
  final def onGetUserByName(handler : (username : String) => F[User]) : UserService[F] = {
    asHandler.copy(getUserByNameHandler = handler)
  }
  /** Logs user into the system
   * 
   * @return String
   */
  def loginUser(username : String, password : String) : F[String]

  /**
   * override loginUser with the given handler
   * @return a new implementation of UserService[F] with loginUser overridden using the given handler
   */
  final def onLoginUser(handler : (username : String, password : String) => F[String]) : UserService[F] = {
    asHandler.copy(loginUserHandler = handler)
  }
  /** Logs out current logged in user session
   * 
   * @return 
   */
  def logoutUser() : F[Unit]

  /**
   * override logoutUser with the given handler
   * @return a new implementation of UserService[F] with logoutUser overridden using the given handler
   */
  final def onLogoutUser(handler : () => F[Unit]) : UserService[F] = {
    asHandler.copy(logoutUserHandler = handler)
  }
  /** Updated user
   * 
   * @return 
   */
  def updateUser(username : String, user : User) : F[Unit]

  /**
   * override updateUser with the given handler
   * @return a new implementation of UserService[F] with updateUser overridden using the given handler
   */
  final def onUpdateUser(handler : (username : String, user : User) => F[Unit]) : UserService[F] = {
    asHandler.copy(updateUserHandler = handler)
  }

  /**
   * @return a Handler implementation of this service
   */
  final def asHandler : UserService.Handler[F] = this match {
      case h : UserService.Handler[F] => h
      case _ =>
        UserService.Handler[F](
              (user) => createUser(user), 
              (user) => createUsersWithArrayInput(user), 
              (user) => createUsersWithListInput(user), 
              (username) => deleteUser(username), 
              (username) => getUserByName(username), 
              (username, password) => loginUser(username, password), 
              () => logoutUser(), 
              (username, user) => updateUser(username, user)
        )
  }

  /**
   * This function will change the effect type of this service.
   *
   * It's not unlike a typical map operation from A => B, except we're not mapping
   * a type from A to B, but rather from F[A] => G[A] using the 'changeEffect' function.
   *
   * For, this could turn an asynchronous service (one which returns Future[_] types) into
   * a synchronous one (one which returns Try[_] types) by awaiting on the Future.
   *
   * It could change an IO type (like cats effect or ZIO) into an ID[A] which is just:
   * ```
   * type ID[A] => A
   * ```
   *
   * @tparam G the new "polymorphic" effect type
   * @param changeEffect the "natural transformation" which can change one effect type into another
   * @return a new UserService service implementation with effect type [G]
   */
  final def mapEffect[G[_]](changeEffect : [A] => F[A] => G[A]) : UserService[G] = {
    val self = this

    new UserService[G] {
        override def createUser(user : User) : G[Unit] = changeEffect {
          self.createUser(user)
        }
        override def createUsersWithArrayInput(user : Seq[User]) : G[Unit] = changeEffect {
          self.createUsersWithArrayInput(user)
        }
        override def createUsersWithListInput(user : Seq[User]) : G[Unit] = changeEffect {
          self.createUsersWithListInput(user)
        }
        override def deleteUser(username : String) : G[Unit] = changeEffect {
          self.deleteUser(username)
        }
        override def getUserByName(username : String) : G[User] = changeEffect {
          self.getUserByName(username)
        }
        override def loginUser(username : String, password : String) : G[String] = changeEffect {
          self.loginUser(username, password)
        }
        override def logoutUser() : G[Unit] = changeEffect {
          self.logoutUser()
        }
        override def updateUser(username : String, user : User) : G[Unit] = changeEffect {
          self.updateUser(username, user)
        }
    }
  }
}
