/**
 * OpenAPI Petstore
 * This is a sample server Petstore server. For this sample, you can use the api key `special-key` to test the authorization filters.
 *
 * OpenAPI spec version: 1.0.0
 *
 * Contact: team@openapitools.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 *
 * https://openapi-generator.tech
 */

// this model was generated using modelData.mustache
package sample.cask.model
import java.time.LocalDate
import java.time.OffsetDateTime
import java.util.UUID
import scala.math.BigDecimal
import ujson.Value
import scala.util.control.NonFatal
import scala.util.*

// see https://com-lihaoyi.github.io/upickle/
import upickle.default.{ReadWriter => RW, macroRW}
import upickle.default.*


        /** ComplexRequestData a data transfer object, primarily for simple json serialisation.
  * It has no validation - there may be nulls, values out of range, etc
  */
case class ComplexRequestData(
  `type`: ComplexRequest.TypeEnum,
/* A required string field */
  requiredField: String,
/* String with length constraints */
  stringField: String = "" ,
/* Integer with a range from 1 to 100 */
  integerField: Int = 0 ,
/* Number with exclusive minimum and maximum constraints */
  numberField: BigDecimal = 0 ,
/* A boolean field */
  booleanField: Boolean = false ,
/* A valid email address */
  emailField: String = "" ,
/* A valid UUID */
  uuidField: UUID = java.util.UUID.randomUUID() ,
/* A date field (YYYY-MM-DD) */
  dateField: LocalDate = null ,
/* A date-time field (RFC 3339 format) */
  dateTimeField: OffsetDateTime = null ,
/* An array of strings with min and max items constraints */
  arrayField: Seq[String] = Nil ,
/* A string field with enum validation */
  enumField: ComplexRequest.EnumFieldEnum = null ,
  nestedObject: ComplexRequestNestedObjectData = null ,
  arrayOfObjectsField: Seq[ComplexRequestArrayOfObjectsFieldInnerData] = Nil ,
/* A string field with regex pattern validation */
  patternField: String = "" ,
/* A string field that allows null values */
  nullableField: String = "" 
  , additionalProperties : ujson.Value =  ujson.Null

) derives RW {

  def asJsonString: String = asJson.toString()

  def asJson : ujson.Value = {
    val jason = writeJs(this)
    jason.obj.remove("additionalProperties")
    jason.mergeWith(additionalProperties)
  }

  def validationErrors(path : Seq[Field], failFast : Boolean) : Seq[ValidationError] = {
    val _allValidationErrors = scala.collection.mutable.ListBuffer[ValidationError]()
        // ================== `type` validation ==================
        
        
        
        

        // ================== requiredField validation ==================
        
        
        
        

        // ================== stringField validation ==================
        // validate min length 5
        if (_allValidationErrors.isEmpty || !failFast)  {
          val len = if stringField == null then 0 else stringField.length
            if (len < 5) {
               _allValidationErrors += ValidationError(path :+ ComplexRequest.Fields.stringField, s"length $len is shorter than the min length 5")
            }
        }
        // validate max length 100
        if (_allValidationErrors.isEmpty || !failFast)  {
          val len = if stringField == null then 0 else stringField.length
            if (len < 100) {
               _allValidationErrors += ValidationError(path :+ ComplexRequest.Fields.stringField, s"length $len is longer than the max length 100")
            }
        }
        
        
        
        

        // ================== integerField validation ==================
        // validate against minimum 1
        if (_allValidationErrors.isEmpty || !failFast) {
            if !(integerField >= 1) then
            _allValidationErrors += ValidationError(path :+ ComplexRequest.Fields.integerField, s"value '$integerField' is not greater than the minimum value 1")
        }
        // validate against maximum 100
        if (_allValidationErrors.isEmpty || !failFast) {
            if !(integerField <= 100) then
            _allValidationErrors += ValidationError(path :+ ComplexRequest.Fields.integerField, s"value '$integerField' is not greater than the maximum value 100")
        }
        
        
        
        

        // ================== numberField validation ==================
        
        
        
        

        // ================== booleanField validation ==================
        
        
        
        

        // ================== emailField validation ==================
        // validate emailField is a valid email address
        if (_allValidationErrors.isEmpty || !failFast) {
            val emailRegex = """^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$"""
            // validate emailField is email
            if (emailField == null || !emailRegex.r.matches(emailField)) {
              _allValidationErrors += ValidationError(path :+ ComplexRequest.Fields.emailField, s"$emailField is not a valid email address according to the pattern $emailRegex")
            }
        }
        
        
        
        

        // ================== uuidField validation ==================
        
        
        
        

        // ================== dateField validation ==================
        
        
        
        

        // ================== dateTimeField validation ==================
        
        
        
        

        // ================== arrayField validation ==================
        
        // validate min items 1
        if (_allValidationErrors.isEmpty || !failFast) {
          val len = if arrayField == null then 0 else arrayField.size
            if (len < 1) {
               _allValidationErrors += ValidationError(path :+ ComplexRequest.Fields.arrayField, s"arrayField has $len, which is less than the min items 1")
            }
        }
        // validate min items 10
        if (_allValidationErrors.isEmpty || !failFast) {
          val len = if arrayField == null then 0 else arrayField.size
            if (len > 10) {
               _allValidationErrors += ValidationError(path :+ ComplexRequest.Fields.arrayField, s"arrayField has $len, which is greater than the max items 10")
            }
        }
        
        
        

        // ================== enumField validation ==================
        
        
        
        

        // ================== nestedObject validation ==================
        
        
        
        
        // validating nestedObject
        if (_allValidationErrors.isEmpty || !failFast) {
            if nestedObject != null then _allValidationErrors ++= nestedObject.validationErrors(path :+ ComplexRequest.Fields.nestedObject, failFast)
        }

        // ================== arrayOfObjectsField validation ==================
        
        
        
        
        if (_allValidationErrors.isEmpty || !failFast) {
            if (arrayOfObjectsField != null) {
                arrayOfObjectsField.zipWithIndex.foreach {
                    case (value, i) if _allValidationErrors.isEmpty || !failFast =>
                      _allValidationErrors ++= value.validationErrors(
                        path :+ ComplexRequest.Fields.arrayOfObjectsField :+ Field(i.toString),
                        failFast)
                    case (value, i) =>
                }
            }
        }
        

        // ================== patternField validation ==================
        // validate against pattern '^[a-zA-Z0-9]{3,10}$'
        if (_allValidationErrors.isEmpty || !failFast) {
           val regex = """^[a-zA-Z0-9]{3,10}$"""
           if patternField == null || !regex.r.matches(patternField) then
              _allValidationErrors += ValidationError(path :+ ComplexRequest.Fields.patternField, s"value '$patternField' doesn't match pattern $regex")
        }
        
        
        
        

        // ================== nullableField validation ==================
        
        
        
        

    _allValidationErrors.toSeq
  }

  /**
   * @return the validated model within a Try (if successful)
   */
  def validated(failFast : Boolean = false) : scala.util.Try[ComplexRequest] = {
    validationErrors(Vector(), failFast) match {
      case Seq() => Success(asModel)
      case first +: theRest => Failure(ValidationErrors(first, theRest))
    }
  }

  /** use 'validated' to check validation */
  def asModel : ComplexRequest = {
    ComplexRequest(
        `type` = `type` /* 2 */,
        requiredField = requiredField /* 2 */,
        stringField = Option(stringField) /* 1 */,
        integerField = Option(integerField) /* 1 */,
        numberField = Option(numberField) /* 1 */,
        booleanField = Option(booleanField) /* 1 */,
        emailField = Option(emailField) /* 1 */,
        uuidField = Option(uuidField) /* 1 */,
        dateField = Option(dateField) /* 1 */,
        dateTimeField = Option(dateTimeField) /* 1 */,
        arrayField = arrayField /* 2 */,
        enumField = Option(enumField) /* 1 */,
        nestedObject = Option(nestedObject).map(_.asModel) /* 4 */,
        arrayOfObjectsField = arrayOfObjectsField.map(_.asModel) /* 5 */,
        patternField = Option(patternField) /* 1 */,
        nullableField = Option(nullableField) /* 1 */
    , additionalProperties
    )
  }
}

object ComplexRequestData {

  def validated(d8a : ComplexRequestData, failFast : Boolean) : scala.util.Try[ComplexRequest] = d8a.validated(failFast)

  def fromJson(jason : ujson.Value) : ComplexRequestData = try {
        val data = read[ComplexRequestData](jason)
        val obj = jason.obj
        ComplexRequest.Fields.values.foreach(v => obj.value.subtractOne(v.fieldName))
        data.copy(additionalProperties = obj)
    } catch {
      case NonFatal(e) => sys.error(s"Error creating ComplexRequestData from json '$jason': $e")
  }

  def fromJsonString(jason : String) : ComplexRequestData = {
        val parsed = try {
           read[ujson.Value](jason)
        } catch {
          case NonFatal(e) => sys.error(s"Error parsing json '$jason': $e")
        }
        fromJson(parsed)
  }

  def manyFromJsonString(jason : String) : Seq[ComplexRequestData] = try {
        read[List[ComplexRequestData]](jason)
    } catch {
        case NonFatal(e) => sys.error(s"Error parsing json '$jason' as list: $e")
    }

  def manyFromJsonStringValidated(jason : String, failFast : Boolean = false) : Try[Seq[ComplexRequest]] = {
      Try(manyFromJsonString(jason)).flatMap { list =>
        list.zipWithIndex.foldLeft(Try(Vector[ComplexRequest]())) {
          case (Success(list), (next, i)) => 
            next.validated(failFast) match {
              case Success(ok) => Success(list :+ ok)
              case Failure(err) => Failure(new Exception(s"Validation error on element $i: ${err.getMessage}", err))
            }
          case (fail, _)  => fail
        }
      }
    }

  def mapFromJsonString(jason : String) : Map[String, ComplexRequestData] = try {
        read[Map[String, ComplexRequestData]](jason)
    } catch {
        case NonFatal(e) => sys.error(s"Error parsing json '$jason' as map: $e")
    }


  def mapFromJsonStringValidated(jason : String, failFast : Boolean = false) : Try[Map[String, ComplexRequest]] = {
     Try(mapFromJsonString(jason)).flatMap { map =>
       map.foldLeft(Try(Map[String, ComplexRequest]())) {
         case (Success(map), (key, next)) =>
           next.validated(failFast) match {
             case Success(ok) => Success(map.updated(key, ok))
             case Failure(err) => Failure(new Exception(s"Validation error on element $key: ${err.getMessage}", err))
           }
         case (fail, _) => fail
       }
     }
  }
}

