/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.representations;

import java.util.ArrayList;
import java.util.List;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.representations.CFG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBlock {
    int _id;
    CFG _cfg;
    Label _label;
    List<IR_Instr> _instrs = new ArrayList<IR_Instr>();
    boolean _isLive;
    BasicBlock _rescuedBodyEndBB;

    public BasicBlock(CFG c, Label l) {
        this._label = l;
        this._isLive = true;
        this._cfg = c;
        this._id = c.getNextBBID();
        this._rescuedBodyEndBB = null;
    }

    void setRescuedBodyEndBB(BasicBlock rbEnd) {
        this._rescuedBodyEndBB = rbEnd;
    }

    public int getID() {
        return this._id;
    }

    public void addInstr(IR_Instr i) {
        this._instrs.add(i);
    }

    public void insertInstr(IR_Instr i) {
        this._instrs.add(0, i);
    }

    public List<IR_Instr> getInstrs() {
        return this._instrs;
    }

    public BasicBlock getRescuedBodyEndBB() {
        return this._rescuedBodyEndBB;
    }

    public String toString() {
        return "BB [" + this._id + ":" + this._label + "]";
    }

    public String toStringInstrs() {
        StringBuilder buf = new StringBuilder(this.toString() + "\n");
        for (IR_Instr instr : this.getInstrs()) {
            if (instr.isDead()) continue;
            buf.append('\t').append(instr).append('\n');
        }
        return buf.toString();
    }
}

